/*****************************************************************************
* FILE:         vd_clock_ClientSpmIf.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ClientSpmIf__IF__H_
#define __vd_clock_ClientSpmIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_vd_clock_ClientSpmIf.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_ClientSpmCallbackIf.h"

// vd_clock_tclClientSpmIf_Include: user specific code start
#include "I_vd_clock_ClientDiaglogIf.h"

class Ivd_clock_tclClientDiaglogIf;
// vd_clock_tclClientSpmIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivd_clock_tclClientSpm;

class vd_clock_tclClientSpmIf : public Ivd_clock_tclClientSpmIf, public vd_clock_tclClientSpmCallbackIF
{
public:

   vd_clock_tclClientSpmIf(tVoid); 
   vd_clock_tclClientSpmIf(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientSpmIf();

   virtual const tChar* getName() const { return "vd_clock_tclClientSpmIf"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tVoid getSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE& rSysPwrMode){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSysPwrModeStatus(rSysPwrMode);
   }


   virtual tBool sendSysPwrModeGet(){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSysPwrModeGet();
   }

private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onSysPwrModeStatus(spm_fi_tcl_SPM_e32_SYSPWRMODE SysPwrMode);


   // vd_clock_tclClientSpmIfDeclarations: user specific code start
   // vd_clock_tclClientSpmIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ivd_clock_tclClientSpm* _poClientRef;

// vd_clock_tclClientSpmIfDeclarationsPart2: user specific code start
   Ivd_clock_tclClientDiaglogIf* _poDiagHandler;
// vd_clock_tclClientSpmIfDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientSpmIf__IF__H_


