/*****************************************************************************
* FILE:         vd_clock_ClientSensor_pvIf.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ClientSensor_pvIf__IF__H_
#define __vd_clock_ClientSensor_pvIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_vd_clock_ClientSensor_pvIf.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_ClientSensor_pvCallbackIf.h"

// vd_clock_tclClientSensor_pvIf_Include: user specific code start
#include "vd_clock_datacontainer.h"
// vd_clock_tclClientSensor_pvIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivd_clock_tclClientSensor_pv;

class vd_clock_tclClientSensor_pvIf : public Ivd_clock_tclClientSensor_pvIf, public vd_clock_tclClientSensor_pvCallbackIF
{
public:

   vd_clock_tclClientSensor_pvIf(tVoid); 
   vd_clock_tclClientSensor_pvIf(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientSensor_pvIf();

   virtual const tChar* getName() const { return "vd_clock_tclClientSensor_pvIf"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendpositionGet(){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendpositionGet();
   }
   virtual tVoid getpositionStatus(tF64& rposLatitude, tF64& rposLongitude, sensor_fi_tcl_e8_position_source& rposSource, sensor_fi_tcl_e16_pv_ISOCountryCode& rcountryCode, sensor_fi_tcl_e8_countrycode_source& rcountryCodeSource, sensor_fi_tcl_pv_TimeZone& rtimeZone, sensor_fi_tcl_e8_timezone_source& rtimeZoneSource){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getpositionStatus(rposLatitude, rposLongitude, rposSource, rcountryCode, rcountryCodeSource, rtimeZone, rtimeZoneSource);
   }


private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onpositionStatus(tF64 posLatitude, tF64 posLongitude, sensor_fi_tcl_e8_position_source posSource, sensor_fi_tcl_e16_pv_ISOCountryCode countryCode, sensor_fi_tcl_e8_countrycode_source countryCodeSource, sensor_fi_tcl_pv_TimeZone timeZone, sensor_fi_tcl_e8_timezone_source timeZoneSource);


   // vd_clock_tclClientSensor_pvIfDeclarations: user specific code start
   // vd_clock_tclClientSensor_pvIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ivd_clock_tclClientSensor_pv* _poClientRef;

// vd_clock_tclClientSensor_pvIfDeclarationsPart2: user specific code start
   vdclk_tclDataContainer* _poContainer;

public:

   tS32 _DSTDiff,_TZDiff;
// vd_clock_tclClientSensor_pvIfDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientSensor_pvIf__IF__H_


