
/*****************************************************************************
* FILE:         vd_clock_ClientSensor_pvIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientSensor_pvIfIncludes: user specific code start
// vd_clock_tclClientSensor_pvIfIncludes: user specific code end

#include "vd_clock_ClientSensor_pvIf.h"
#include "Ivd_clock_ClientSensor_pv.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_SENSOR_PV
#include "trcGenProj/Header/vd_clock_ClientSensor_pvIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSensor_pvIf::
*             vd_clock_tclClientSensor_pvIf(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSensor_pvIf::vd_clock_tclClientSensor_pvIf(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientSensor_pvIf(poMainAppl)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientSensor_pvIfConstructor: user specific code start
   _poContainer  = OSAL_NULL;
   _DSTDiff = NULL;		//Coverity Fix
   _TZDiff = NULL;		//Coverity Fix
   // vd_clock_tclClientSensor_pvIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientSensor_pvIf::
*             ~vd_clock_tclClientSensor_pvIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientSensor_pvIf::~vd_clock_tclClientSensor_pvIf(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientSensor_pvIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientSensor_pvIfDestructor: user specific code start
   _poContainer = OSAL_NULL;
   // vd_clock_tclClientSensor_pvIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pvIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientSensor_pvIf.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     SENSOR_PV_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pvIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ivd_clock_tclClientSensor_pv*>(_cpoMain->getHandler("Ivd_clock_tclClientSensor_pv"));

   VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // vd_clock_tclClientSensor_pvIfvGetReferences: user specific code start
   _poContainer = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));

   VD_CLOCK_NULL_POINTER_CHECK(_poContainer);

   // vd_clock_tclClientSensor_pvIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pvIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pvIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf::vStartCommunication() entered."));
   // vd_clock_tclClientSensor_pvIfvStartCommunication: user specific code start
   // vd_clock_tclClientSensor_pvIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pvIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pvIf::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // vd_clock_tclClientSensor_pvIfvHandleMessage: user specific code start
   // vd_clock_tclClientSensor_pvIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pvIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pvIf::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientSensor_pvIfvHandleTraceMessage: user specific code start
   // vd_clock_tclClientSensor_pvIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pvIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pvIf::vTraceInfo()
{
   // vd_clock_tclClientSensor_pvIfvTraceInfo: user specific code start
   // vd_clock_tclClientSensor_pvIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pvIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pvIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf::onServiceAvailable() entered."));

   // vd_clock_tclClientSensor_pvIfvOnServiceAvailable: user specific code start
   // vd_clock_tclClientSensor_pvIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientSensor_pvIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientSensor_pvIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf::onServiceUnavailable() entered."));

   // vd_clock_tclClientSensor_pvIfvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientSensor_pvIfvOnServiceUnavailable: user specific code end
}

tVoid vd_clock_tclClientSensor_pvIf::onpositionStatus(tF64 posLatitude, tF64 posLongitude, sensor_fi_tcl_e8_position_source posSource, sensor_fi_tcl_e16_pv_ISOCountryCode countryCode, sensor_fi_tcl_e8_countrycode_source countryCodeSource, sensor_fi_tcl_pv_TimeZone timeZone, sensor_fi_tcl_e8_timezone_source timeZoneSource) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientSensor_pvIf::onpositionStatus(): CALLED" ) );

   // onpositionStatus: user specific code start

	ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf:Pos Source: %d countryCode: %d countryCodeSource: %d timeZone DSTState: %d DST Diff: %d  TZ diff: %d timeZoneSource: %d",
			posSource.enType,countryCode.enType,countryCodeSource.enType,timeZone.DST_State.enType, timeZone.DSTDifference.s32Value,timeZone.TimeZoneDifference.s32Value,timeZoneSource.enType));

	tU8 timezoneSource = timeZoneSource.enType;
	if(timezoneSource) // timezone source is MAPDATA or EXTERNAL
	{
		tBool _DSTState = FALSE;
		tU8 u8DSTState = (tU8)timeZone.DST_State.enType;
		switch(u8DSTState)
		{
		case sensor_fi_tcl_e8_pv_DST_State::FI_EN_PV_DAYLIGHT_SAVING_TIME:
		{
			_DSTState = TRUE;
			ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf:DST Enabled"));
		}
		break;
		case sensor_fi_tcl_e8_pv_DST_State::FI_EN_PV_STANDARD_TIME:
		{
			_DSTState = FALSE;
			ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf:DST Standard"));
		}
		break;
		default:
		{
			ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf invalid data"));
		}
		break;
		}

   _DSTDiff = timeZone.DSTDifference.s32Value;
   _TZDiff = timeZone.TimeZoneDifference.s32Value;

   if(_DSTState)
   {
	   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf Setting the DST Diff TZ diff %d %d", _DSTDiff, _TZDiff));
  	   _poContainer ->vUpdateDSTSensorTime(_DSTDiff,_TZDiff);
   }

   else
   {
	   ETG_TRACE_USR4(("vd_clock_tclClientSensor_pvIf Setting the TZ diff %d ",_TZDiff));
	   _poContainer ->vUpdateDSTSensorTime(0,_TZDiff);
   }

	}
   // onpositionStatus: user specific code end
}




// vd_clock_tclClientSensor_pvIfvd_clock_ClientSensor_pvIf: user specific code start
// vd_clock_tclClientSensor_pvIfvd_clock_ClientSensor_pvIf: user specific code end

//EOF
