
/*****************************************************************************
* FILE:         vd_clock_ClientProfileIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientProfileIfIncludes: user specific code start
#include "ProfileManager.h"
// vd_clock_tclClientProfileIfIncludes: user specific code end

#include "vd_clock_ClientProfileIf.h"
#include "Ivd_clock_ClientProfile.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_PROFILE
#include "trcGenProj/Header/vd_clock_ClientProfileIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientProfileIf::
*             vd_clock_tclClientProfileIf(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientProfileIf::vd_clock_tclClientProfileIf(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientProfileIf(poMainAppl)
{
   ETG_TRACE_USR4(("vd_clock_tclClientProfileIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientProfileIfConstructor: user specific code start
   _poProfileRef = OSAL_NULL;
   // vd_clock_tclClientProfileIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientProfileIf::
*             ~vd_clock_tclClientProfileIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientProfileIf::~vd_clock_tclClientProfileIf(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientProfileIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientProfileIfDestructor: user specific code start
   _poProfileRef = OSAL_NULL;
   // vd_clock_tclClientProfileIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientProfileIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientProfileIf.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     PROFILE_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientProfileIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientProfileIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ivd_clock_tclClientProfile*>(_cpoMain->getHandler("Ivd_clock_tclClientProfile"));

   VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // vd_clock_tclClientProfileIfvGetReferences: user specific code start
   _poProfileRef = dynamic_cast<profileManager*>(_cpoMain->getHandler("profileManager"));
   VD_CLOCK_NULL_POINTER_CHECK(_poProfileRef);
   // vd_clock_tclClientProfileIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientProfileIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientProfileIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientProfileIf::vStartCommunication() entered."));
   // vd_clock_tclClientProfileIfvStartCommunication: user specific code start
   sendRegisterClientMStart(); //To notify profile manager to register Clock CCA ID for Profile change Updates

   // vd_clock_tclClientProfileIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientProfileIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientProfileIf::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientProfileIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // vd_clock_tclClientProfileIfvHandleMessage: user specific code start
   // vd_clock_tclClientProfileIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientProfileIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientProfileIf::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientProfileIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientProfileIfvHandleTraceMessage: user specific code start
   // vd_clock_tclClientProfileIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientProfileIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientProfileIf::vTraceInfo()
{
   // vd_clock_tclClientProfileIfvTraceInfo: user specific code start
   // vd_clock_tclClientProfileIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientProfileIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientProfileIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientProfileIf::onServiceAvailable() entered."));

   // vd_clock_tclClientProfileIfvOnServiceAvailable: user specific code start
   // vd_clock_tclClientProfileIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientProfileIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientProfileIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientProfileIf::onServiceUnavailable() entered."));

   // vd_clock_tclClientProfileIfvOnServiceUnavailable: user specific code start
   // vd_clock_tclClientProfileIfvOnServiceUnavailable: user specific code end
}

tVoid vd_clock_tclClientProfileIf::onactiveProfileStatus(tU8 ID) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::onactiveProfileStatus(): CALLED" ) );

   // onactiveProfileStatus: user specific code start
   if(OSAL_NULL != _poProfileRef)
   {
	   //_poProfileRef->setActiveProfile(ID);
	   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::onactiveProfileStatus()-> Active Profile ID=%d", ID) );

   }

   // onactiveProfileStatus: user specific code end
}
tVoid vd_clock_tclClientProfileIf::onstatusStatus(profile_fi_tcl_e8_profileStatus status) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::onstatusStatus(): CALLED" ) );

   // onstatusStatus: user specific code start
   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::onstatusStatus()->Current Status= %d",status.enType) );
   if(OSAL_NULL != _poProfileRef)
   {
	   if(!status.enType)
	   {
		  // _poProfileRef->setProfileStatus(TRUE);
	   }
	   else
	   {
		  // _poProfileRef->setProfileStatus(FALSE);
	   }
   }
   // onstatusStatus: user specific code end
}
tVoid vd_clock_tclClientProfileIf::oncopyProfileStatus(tU8 sourceID, tU8 destinationID) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::oncopyProfileStatus(): CALLED" ) );

   // oncopyProfileStatus: user specific code start

   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::oncopyProfileStatus()->Copying from Profile=(%d) to (%d)",sourceID,destinationID) );
   profile_fi_tcl_e8_ClientResponse ResponseBack;
   ResponseBack.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS;
   sendonProfileCopiedMStart(ResponseBack);

   // oncopyProfileStatus: user specific code end
}
tVoid vd_clock_tclClientProfileIf::ondeleteProfileStatus(tU8 ProfileID) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::ondeleteProfileStatus(): CALLED" ) );

   // ondeleteProfileStatus: user specific code start

   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::ondeleteProfileStatus()->Deleted Profile=%d ",ProfileID ) );
   profile_fi_tcl_e8_ClientResponse ResponseBack;
   ResponseBack.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS;
   sendonProfileDeletedMStart(ResponseBack);

   // ondeleteProfileStatus: user specific code end
}
tVoid vd_clock_tclClientProfileIf::ondataChangedStatus(profile_fi_tcl_e8_changeProfile reason) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::ondataChangedStatus(): CALLED" ) );

   // ondataChangedStatus: user specific code start
   tBool bRequestStatus = FALSE;
   profile_fi_tcl_e8_DataChangedResponse result;
   switch(reason.enType)
   {
	   case profile_fi_tcl_e8_changeProfile::FI_EN_PREPARE:
	   {
		   //Prepared trigger is received from Profile Manager
		   //On this Trigger, simply we call store datapool to save current user data into datapool before switching.
		   if(_poProfileRef != NULL) {
			   _poProfileRef->HandlePrepareTrigger();
			   bRequestStatus = TRUE;
			   result.enType = result.FI_EN_PREPARED;
		   }
	   }
	   break;
	   case profile_fi_tcl_e8_changeProfile::FI_EN_PROFILECHANGED:
	   {
		   //This trigger will be sent by profile manager on change of user.
		   //We shall perform ReadFrom Datapool
		   //And update CCA Clients
		   if(_poProfileRef != NULL)
		   {
			   ETG_TRACE_USR4(("vd_clock_tclClientProfileIf::ondataChangedStatus:->FI_EN_PROFILECHANGED happened\n"));
			   _poProfileRef->HandleProfileChangeTrigger();
			   bRequestStatus = TRUE;
			   result.enType = result.FI_EN_PROFILE_CHANGED;
		   }

	   }
	   break;
	   case profile_fi_tcl_e8_changeProfile::FI_EN_DOWNLOAD:
	   break;
	   case profile_fi_tcl_e8_changeProfile::FI_EN_PROFILERESET:
	   {
		   if(_poProfileRef != NULL) {
		   _poProfileRef->HandleProfileChangeTrigger();
		   }

		   //Set the specified profile to the Default values
		   tU8 profileId;						//To get the profile Id to be deleted
		   getdeleteProfileStatus(profileId);
		   ETG_TRACE_USR4(("vd_clock_tclClientProfileIf::ondataChangedStatus:->FI_EN_PROFILERESET happened for: (%d)\n",profileId));
		   //bRequestStatus = TRUE;
	   }
	   break;
	   default:
	   break;
   }

   //Send response to the Profile Manager Component
   //profile_fi_tcl_e8_ClientResponse result;

   //result.enType = (bRequestStatus== TRUE)? result.FI_EN_SUCCESS : result.FI_EN_FAILED;
   if(bRequestStatus == TRUE)
   {
	   sendonDataChangedMStart(result);
   }

   // ondataChangedStatus: user specific code end
}
tVoid vd_clock_tclClientProfileIf::oncreateProfileStatus(tU8 ID) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::oncreateProfileStatus(): CALLED" ) );

   // oncreateProfileStatus: user specific code start

   ETG_TRACE_USR1( ( "vd_clock_tclClientProfileIf::oncreateProfileStatus() -> Profile ID = %d", ID) );
   profile_fi_tcl_e8_ClientResponse ResponseBack;
   ResponseBack.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS;
   sendonProfileCreatedMStart(ResponseBack);

   // oncreateProfileStatus: user specific code end
}




// vd_clock_tclClientProfileIfvd_clock_ClientProfileIf: user specific code start
// vd_clock_tclClientProfileIfvd_clock_ClientProfileIf: user specific code end

//EOF
