/*****************************************************************************
* FILE:         vd_clock_ClientDiaglogIf.h
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

#ifndef __vd_clock_ClientDiaglogIf__IF__H_
#define __vd_clock_ClientDiaglogIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_vd_clock_ClientDiaglogIf.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_ClientDiaglogCallbackIf.h"

// vd_clock_tclClientDiaglogIf_Include: user specific code start
// vd_clock_tclClientDiaglogIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ivd_clock_tclClientDiaglog;

class vd_clock_tclClientDiaglogIf : public Ivd_clock_tclClientDiaglogIf, public vd_clock_tclClientDiaglogCallbackIF
{
public:

   vd_clock_tclClientDiaglogIf(tVoid); 
   vd_clock_tclClientDiaglogIf(vd_clock_tclAppMain* poMainAppl);
   virtual ~vd_clock_tclClientDiaglogIf();

   virtual const tChar* getName() const { return "vd_clock_tclClientDiaglogIf"; };
   
   virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/


   virtual tVoid getSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure& rNextTestResultStruct, tBool& rStatus){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getSendNextTestResultStatus(rNextTestResultStruct, rStatus);
   }


   virtual tBool sendSaveTestResultMStart(midw_fi_tcl_TestResultList TestResultList){
       //just forward send request
       VD_CLOCK_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendSaveTestResultMStart(TestResultList);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status);

   virtual tVoid onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status);

   // vd_clock_tclClientDiaglogIfDeclarations: user specific code start
   // vd_clock_tclClientDiaglogIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ivd_clock_tclClientDiaglog* _poClientRef;

// vd_clock_tclClientDiaglogIfDeclarationsPart2: user specific code start
 tBool _bServiceAvailable;
public:
 typedef enum
 	{
 		VDCLOCK_EN_TEST_TYPE_MCAN_COMM,
 		VDCLOCK_EN_TEST_TYPE_MUTE_STATE


 	} vdclock_tenTestType;

 	typedef enum
 	{
 		VDCLOCK_EN_MCAN_UNIT_VDCLOCK,
 		VDCLOCK_EN_MCAN_UNIT_STEARING_SW,
 		VDCLOCK_EN_MCAN_UNIT_MAX
 	}vdclock_tenMCANUnit;





   virtual tVoid prepareSaveTestResultData(tU8 message_type , vdclock_mcan_tenTestResult enTestResult);
   virtual tVoid vSetACCInfo(tBool isACCOn);
   virtual tVoid vCheckforITCLog(tU8 u8MCANTroubleCode, tU8 u8MCANCommunicationState, tU8 u8MCANMuteState);

private:

    tBool  _bisACCOn;
	tBool _bCommError;
    tBool _bMuteStateError;
    tBool _bTroubleCodeChange;
    tU8 _u8CommunicationState;
    tU8 _u8MuteState;
    tU8 _u8TroubleCode;
    midw_fi_tcl_TestResult _oCalculateTestResult(tU8 message_type, vdclock_mcan_tenTestResult enTestResult ) const;
    midw_fi_tcl_TestResult _oCalculateTestResultITC(tU8 message_type, vdclock_mcan_tenTestResult enTestResult ) const;
   	tVoid vSetTroublCode(midw_fi_tcl_TestResult &oRetVal, tU8 message_type) const;
   	tVoid vSetTroublCodeITC(midw_fi_tcl_TestResult &oRetVal, tU8 message_type) const;
   	tVoid vSetTestResult(midw_fi_tcl_TestResult &oRetVal,vdclock_mcan_tenTestResult enTestResult) const;
  /* 	tBool bGetCommTestResult( vdclock_tenMCANUnit enUnit, vdclock_mcan_tenTestResult &penTestResult ) const; */
// vd_clock_tclClientDiaglogIfDeclarationsPart2: user specific code end

};

#endif // __vd_clock_ClientDiaglogIf__IF__H_


