
/*****************************************************************************
* FILE:         vd_clock_ClientDiaglogIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: vd_clock
* Template:     ClientIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// vd_clock_tclClientDiaglogIfIncludes: user specific code start
// DiagLog header (trouble codes)
#define VD_DIAGLOG_S_IMPORT_INTERFACE_MSG
#include "vd_diaglog_if.h"

#include "vd_clock_INCAdapter.h"
// vd_clock_tclClientDiaglogIfIncludes: user specific code end

#include "vd_clock_ClientDiaglogIf.h"
#include "Ivd_clock_ClientDiaglog.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_DIAGLOG
#include "trcGenProj/Header/vd_clock_ClientDiaglogIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientDiaglogIf::
*             vd_clock_tclClientDiaglogIf(vd_clock_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientDiaglogIf::vd_clock_tclClientDiaglogIf(vd_clock_tclAppMain* poMainAppl) : 
Ivd_clock_tclClientDiaglogIf(poMainAppl)
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientDiaglogIfConstructor: user specific code start
   _bServiceAvailable = FALSE;
   _bisACCOn = FALSE;
   _bCommError = FALSE;
   _bMuteStateError = FALSE;
   _bTroubleCodeChange = FALSE;
   _u8CommunicationState = 0;
   _u8MuteState = 0;
   _u8TroubleCode = 0;
   // vd_clock_tclClientDiaglogIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: vd_clock_tclClientDiaglogIf::
*             ~vd_clock_tclClientDiaglogIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
vd_clock_tclClientDiaglogIf::~vd_clock_tclClientDiaglogIf(tVoid)
{
   ETG_TRACE_USR4(("~vd_clock_tclClientDiaglogIf() entered."));
   _poClientRef = OSAL_NULL;

   // vd_clock_tclClientDiaglogIfDestructor: user specific code start
   _bServiceAvailable = FALSE;
   _bisACCOn  = FALSE;
   // vd_clock_tclClientDiaglogIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglogIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'vd_clock_ClientDiaglogIf.h':
*     Add forward declaration:
*         class Ivd_clock_tclObject2Get;
*
*     Add declaration of object reference:
*         Ivd_clock_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ivd_clock_tclObject2Get*>(_cpoMain->getHandler("Ivd_clock_tclObject2Get"));
*     DIAGLOG_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglogIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vGetReferences() entered."));

   _poClientRef = dynamic_cast<Ivd_clock_tclClientDiaglog*>(_cpoMain->getHandler("Ivd_clock_tclClientDiaglog"));

   VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);

   _poClientRef->vSetCallbackIf(this);

   //set callback interface

   // vd_clock_tclClientDiaglogIfvGetReferences: user specific code start
   // vd_clock_tclClientDiaglogIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglogIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglogIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vStartCommunication() entered."));
   // vd_clock_tclClientDiaglogIfvStartCommunication: user specific code start
   // vd_clock_tclClientDiaglogIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglogIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   vd_clock_tclBaseIf::TMsg* pMsg
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglogIf::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(vd_clock_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   
   // vd_clock_tclClientDiaglogIfvHandleMessage: user specific code start
   // vd_clock_tclClientDiaglogIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglogIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle trace message.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglogIf::vHandleTraceMessage(const tUChar* puchData)
{
   VD_CLOCK_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // vd_clock_tclClientDiaglogIfvHandleTraceMessage: user specific code start
   // vd_clock_tclClientDiaglogIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglogIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid vd_clock_tclClientDiaglogIf::vTraceInfo()
{
   // vd_clock_tclClientDiaglogIfvTraceInfo: user specific code start
   // vd_clock_tclClientDiaglogIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglogIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid vd_clock_tclClientDiaglogIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::onServiceAvailable() entered."));

   // vd_clock_tclClientDiaglogIfvOnServiceAvailable: user specific code start
   _bServiceAvailable = TRUE;
   // vd_clock_tclClientDiaglogIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid vd_clock_tclClientDiaglogIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid vd_clock_tclClientDiaglogIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::onServiceUnavailable() entered."));

   // vd_clock_tclClientDiaglogIfvOnServiceUnavailable: user specific code start
    _bServiceAvailable = FALSE;
   // vd_clock_tclClientDiaglogIfvOnServiceUnavailable: user specific code end
}

tVoid vd_clock_tclClientDiaglogIf::onSendNextTestResultStatus(midw_fi_tcl_SendNextTestResultStructure NextTestResultStruct, tBool Status) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientDiaglogIf::onSendNextTestResultStatus(): CALLED" ) );

   // onSendNextTestResultStatus: user specific code start
   //Alok++
	VD_CLOCK_NULL_POINTER_CHECK(_cpoMain);
	vd_clock_INCAdapter* _poINCAdapter = dynamic_cast<vd_clock_INCAdapter*>(_cpoMain->getHandler("vd_clock_INCAdapter"));

	if( NULL != _poINCAdapter)
	{
		// Send message for HW version info
		tU8 u8INC_msg_buff = 0;
		u8INC_msg_buff = 0x42; // msg id, for MPDT
		_poINCAdapter->sendMessage((void*)&u8INC_msg_buff, 1);
		ETG_TRACE_USR1( ( "vd_clock_tclClientDiaglogIf::onSendNextTestResultStatus(): CALLED::msg id for MPDT = %d", u8INC_msg_buff) );
	}
	else
	{
		ETG_TRACE_FATAL(("vd_clock_tclClientDiaglogIF::onSendNextTestResultStatus()-> INC Adaptor not yet available !!"));
	}
   //Alok--
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(NextTestResultStruct);
   OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Status);
   // onSendNextTestResultStatus: user specific code end
}

tVoid vd_clock_tclClientDiaglogIf::onSaveTestResultMResult(midw_fi_tcl_e8_MethodResultReply Status) {
   ETG_TRACE_USR1( ( "vd_clock_tclClientDiaglogIf::onSaveTestResultMResult(): CALLED" ) );

   // onSaveTestResultMResult: user specific code start
    OSAL_C_PARAMETER_INTENTIONALLY_UNUSED(Status);
   // onSaveTestResultMResult: user specific code end
}



// vd_clock_tclClientDiaglogIfvd_clock_ClientDiaglogIf: user specific code start
tVoid vd_clock_tclClientDiaglogIf::prepareSaveTestResultData(tU8 message_type , vdclock_mcan_tenTestResult enTestResult )
{
	//VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
	midw_fi_tcl_TestResultList tempTestResult;
	std::vector<midw_fi_tcl_TestResult, std::allocator<midw_fi_tcl_TestResult> > tempTestResultList;

	midw_fi_tcl_TestResult oAVCommResult;
	midw_fi_tcl_TestResult oClusterMeterresult;

	VD_CLOCK_NULL_POINTER_CHECK(_poClientRef);
	
	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::prepareSaveTestResultData() entered"));
	oAVCommResult = _oCalculateTestResult( message_type ,enTestResult );

	if ( midw_fi_tcl_e8_TestResult::FI_EN_NORESULT != oAVCommResult.Result.enType )
		{
			ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::prepareSaveTestResultData():  0x43 inside"));
			tempTestResultList.push_back(oAVCommResult);
			
		}
	_poClientRef->vSaveLocalTestResultList(oAVCommResult);


	oClusterMeterresult = _oCalculateTestResultITC( message_type ,enTestResult );
	if ( midw_fi_tcl_e8_TestResult::FI_EN_NORESULT != oClusterMeterresult.Result.enType )
		{
			ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::prepareSaveTestResultData():  0x43 inside"));
			tempTestResultList.push_back(oClusterMeterresult);

		}
	 _poClientRef->vSaveLocalTestResultList(oClusterMeterresult);

	 tempTestResult.TestResultList = tempTestResultList;
	 sendSaveTestResultMStart(tempTestResult);

}


midw_fi_tcl_TestResult vd_clock_tclClientDiaglogIf::_oCalculateTestResult(tU8 message_type, vdclock_mcan_tenTestResult enTestResult ) const
{
	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResult() entered"));
	midw_fi_tcl_TestResult oRetVal;

	oRetVal.TroubleCode = 0;
	oRetVal.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_NORESULT;

	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResult()_bisACCOn %d ",_bisACCOn));

	if (_bisACCOn )
	{
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResult() inside _bisACCOn"));
		vSetTroublCode(oRetVal,message_type);
	}

	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResult() oRetVal.TroubleCode %d ",oRetVal.TroubleCode));

	if ( 0 != oRetVal.TroubleCode )
	{
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResult() inside oRetVal.TroubleCode"));
		vSetTestResult(oRetVal,enTestResult);

	}

	return oRetVal;
}


midw_fi_tcl_TestResult vd_clock_tclClientDiaglogIf::_oCalculateTestResultITC(tU8 message_type, vdclock_mcan_tenTestResult enTestResult ) const
{
	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResultITCResult() entered"));
	midw_fi_tcl_TestResult oRetVal;

	oRetVal.TroubleCode = 0;
	oRetVal.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_NORESULT;

	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResultITCResult() _bisACCOn %d ",_bisACCOn));

	if (_bisACCOn )
	{
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResultITCResult() inside _bisACCOn"));
		vSetTroublCodeITC(oRetVal,message_type);
	}

	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResult() oRetVal.TroubleCode %d ",oRetVal.TroubleCode));

	if ( 0 != oRetVal.TroubleCode )
	{
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::_oCalculateTestResult() inside oRetVal.TroubleCode"));
		vSetTestResult(oRetVal,enTestResult);

	}

	return oRetVal;
}
//-----------------------------------------------------------------------------
// private helper functions
//-----------------------------------------------------------------------------

tVoid  vd_clock_tclClientDiaglogIf::vSetTroublCode(midw_fi_tcl_TestResult &oRetVal,tU8 message_type) const
{
	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vSetTroublCode() entered "));

	if( message_type == VDCLOCK_EN_TEST_TYPE_MCAN_COMM)
	{
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vSetTroublCode() message_type == 0x43 "));
#ifdef ITC_AIVI_MCAN_METER_SWC_COM_ERR
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vSetTroublCode()message_type == 0x43 :ITC_AIVI_MCAN_METER_SWC_COM_ERR "));
		oRetVal.TroubleCode =ITC_AIVI_MCAN_METER_SWC_COM_ERR;
#endif // VDL_ITC_MCAN_SWC_COM_ERR
	}

	if( message_type == VDCLOCK_EN_TEST_TYPE_MUTE_STATE)
	{
#ifdef ITC_AIVI_MCAN_METER_SWC_MPDT_MUTE_ERR
		oRetVal.TroubleCode = ITC_AIVI_MCAN_METER_SWC_MPDT_MUTE_ERR;
#endif // VDL_ITC_MCAN_SWC_CONF_MUTE_ERRl

	}

}
//-----------------------------------------------------------------------------
// private helper functions
//-----------------------------------------------------------------------------

tVoid vd_clock_tclClientDiaglogIf::vSetTestResult(midw_fi_tcl_TestResult &oRetVal,vdclock_mcan_tenTestResult enTestResult) const
{
	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vSetTestResult() entered "));
	switch ( enTestResult )
	{
	case VDCLOCK_MCAN_EN_TEST_RESULT_PASSED:
	{
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vSetTestResult() VDCLOCK_MCAN_EN_TEST_RESULT_PASSED "));
		oRetVal.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_PASSED;
	}
	break;
	case VDCLOCK_MCAN_EN_TEST_RESULT_FAILED:
	{
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vSetTestResult() VDCLOCK_MCAN_EN_TEST_RESULT_FAILED "));
		oRetVal.Result.enType = midw_fi_tcl_e8_TestResult::FI_EN_FAILED;
	}
	break;
	case VDCLOCK_MCAN_EN_TEST_RESULT_UNKNOWN:
	default:
	{
	}
	break;
	}
}

//-----------------------------------------------------------------------------
// private helper functions
//-----------------------------------------------------------------------------

tVoid  vd_clock_tclClientDiaglogIf::vSetTroublCodeITC(midw_fi_tcl_TestResult &oRetVal,tU8 message_type) const
{
	ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vSetTroublCode() entered "));

	if( message_type == VDCLOCK_EN_TEST_TYPE_MCAN_COMM)
	{
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vSetTroublCode() message_type == 0x43 "));
#ifdef ITC_AIVI_MCAN_METER_SWC_ERROR
		ETG_TRACE_USR4(("vd_clock_tclClientDiaglogIf::vSetTroublCode()message_type == 0x43 :ITC_AIVI_MCAN_METER_SWC_COM_ERR "));
		oRetVal.TroubleCode =ITC_AIVI_MCAN_METER_SWC_ERROR;
#endif // VDL_ITC_MCAN_SWC_COM_ERR
	}

	if( message_type == VDCLOCK_EN_TEST_TYPE_MUTE_STATE)
	{
#ifdef ITC_AIVI_MCAN_METER_SWC_MPDT_MUTE_ERR
		oRetVal.TroubleCode = ITC_AIVI_MCAN_METER_SWC_MPDT_MUTE_ERR;
#endif // VDL_ITC_MCAN_SWC_CONF_MUTE_ERRl

	}

}


/************************************/
tVoid vd_clock_tclClientDiaglogIf::vSetACCInfo(tBool isACCOn)
{
	_bisACCOn = isACCOn;
}

tVoid vd_clock_tclClientDiaglogIf::vCheckforITCLog(tU8 u8MCANTroubleCode, tU8 u8MCANCommunicationState, tU8 u8MCANMuteState)
{
	vdclock_mcan_tenTestResult enTestResult = VDCLOCK_MCAN_EN_TEST_RESULT_UNKNOWN;
	
	if(u8MCANCommunicationState != _u8CommunicationState)
	{
		_u8CommunicationState = u8MCANCommunicationState;
		_bCommError = TRUE;
	}
	if(u8MCANMuteState != _u8MuteState)
	{
		_u8MuteState = u8MCANMuteState;
		_bMuteStateError = TRUE;
	}

	if(u8MCANTroubleCode !=_u8TroubleCode)
	{
		_u8TroubleCode = u8MCANTroubleCode;
		_bTroubleCodeChange = TRUE;
	}


	/* Setting the trouble Code for communication state */

	if(_u8TroubleCode == 0x01 && _u8CommunicationState == 0XC0)
	{
		enTestResult = VDCLOCK_MCAN_EN_TEST_RESULT_FAILED;
		prepareSaveTestResultData(VDCLOCK_EN_TEST_TYPE_MCAN_COMM , enTestResult );
	}
	else if(_u8TroubleCode == 0x00 && _u8CommunicationState == 0X00)
	{
		enTestResult = VDCLOCK_MCAN_EN_TEST_RESULT_PASSED;
		prepareSaveTestResultData(VDCLOCK_EN_TEST_TYPE_MCAN_COMM , enTestResult );
	}
	else if(_u8CommunicationState == 0xFF)
	{
		enTestResult = VDCLOCK_MCAN_EN_TEST_RESULT_UNKNOWN;
	}
	
	/* Setting the trouble Code for Mute state */

	if(_u8TroubleCode == 0x01 && _u8MuteState == 0XC0)
	{
		enTestResult = VDCLOCK_MCAN_EN_TEST_RESULT_FAILED;
		prepareSaveTestResultData(VDCLOCK_EN_TEST_TYPE_MUTE_STATE , enTestResult );
	}
	else if(_u8TroubleCode == 0x00 && _u8MuteState == 0X00)
	{
		enTestResult = VDCLOCK_MCAN_EN_TEST_RESULT_PASSED;
		prepareSaveTestResultData(VDCLOCK_EN_TEST_TYPE_MUTE_STATE , enTestResult );
	}
		
}

// vd_clock_tclClientDiaglogIfvd_clock_ClientDiaglogIf: user specific code end

//EOF
