/*
 * vd_clock_utils.cpp
 *
 *  Created on: Apr 23, 2015
 *      Author: vee4kor
 */

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_UTILS
#include "trcGenProj/Header/vd_clock_utils.cpp.trc.h"
#endif

// linking registry access functions
#define SCD_S_IMPORT_INTERFACE_GENERIC
#include "scd_if.h"

#define VD_CLOCK_S_IMPORT_INTERFACE_GENERIC
#include "vd_clock_If.h"

#include "vd_clock_types.h"
// linking trace macros
#include "vd_clock_AppMain_Trace.h"
#include "vd_clock_AppMain.h"

// linking trace macros
#include "vd_clock_utils.h"

struct  tRegKey
{
   tCString  cszSection;
   tCString  cszKey;
   tU32      u32DefaultValue;
};


static const tRegKey    coRegKey[]
= {  //    section                key               default
   {"SERVICES\\VD_CLOCK", "CLK_DefaultTimeFormat",    1L},
   {"SERVICES\\VD_CLOCK", "CLK_DefaultDateFormat",    1L},
   {"SERVICES\\VD_CLOCK", "CLK_DefaultTimeZoneIndex",31L},  // GMT
   {"SERVICES\\VD_CLOCK", "CLK_DefaultDST_On",        0L},  // GMT
#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_CLOCK_MC
   {"SERVICES\\VD_CLOCK", "CLK_KeyDefaultSyncMode", VDCLK_EN_SyncMode_CAN},
#else
   {"SERVICES\\VD_CLOCK", "CLK_KeyDefaultSyncMode", VDCLK_EN_SyncMode_CanOrManual},
#endif

   {"APP_THREAD",         "CLK_FFSWrite_Prio",      140L},
   {"APP_THREAD",         "CLK_CCANotif_Prio",      136L},
   {"APP_THREAD",         "CLK_RTC_Prio",           130L},
   {"APP_THREAD",         "CLK_CSMRd_Prio",         133L},

   {"APP_THREAD",         "CLK_FFSWrite_Stack",     4096L},
   {"APP_THREAD",         "CLK_CCANotif_Stack",     4096L},
   {"APP_THREAD",         "CLK_RTC_Stack",          4096L},
   {"APP_THREAD",         "CLK_CSMRd_Stack",        4096L}
};


// ****************************************************************************

tU32                             vdclk_u32GetRegistryValue
   (
      VDCLK_TEN_RegKeyIndex  RegKeyIndex,
      const tU16     u16Class,         // Tracing information _CLASS
      const tU32     u32Line           // Tracing information _LINE
   )

{
   (tVoid)u16Class;
   (tVoid)u32Line;

   tU32 u32KeyData = 0L;
   tBool bSuccess;

   bSuccess = scd_bGetAppConfigurationValue
               (
                  CCA_C_U16_APP_VD_CLOCK,             // CCA App ID
                  coRegKey[RegKeyIndex].cszSection,   // section name
                  coRegKey[RegKeyIndex].cszKey,       // key name
                  &u32KeyData                         // location for Value
               );
   if ( bSuccess )
   {
       ETG_TRACE_USR3_DCL((u16Class, "Registry Value: %20s: %d (line %u)",
                           coRegKey[RegKeyIndex].cszKey, u32KeyData, u32Line));
   } else {
      u32KeyData = coRegKey[RegKeyIndex].u32DefaultValue;
      ETG_TRACE_COMP_DCL((u16Class, "Missing Registry Value: %20s; using default:%d (line %u)",
                      coRegKey[RegKeyIndex].cszKey, u32KeyData, u32Line));
   }
   return u32KeyData;
};


void vdclk_vSetBits(tU32 u32Src, tU8 u8StartByte, tU8 u8StartBit, tU8 u8NumBits, tU8* pu8Dest) {
    tU8 u8StartBitLong = u8StartBit + (tU8)(u8StartByte*8);
    tU8 u8BitsLeft=u8NumBits;
    pu8Dest = &pu8Dest[u8StartBitLong >>3];
    u8StartBit %= 8;
    u32Src <<=(32-u8NumBits);
    while (u8BitsLeft){
        tU8 u8Mask=0;
        tU8 u8MaskBit = 0x80;
        int numBits=0;
        tU8 u8EmptyBits= 0;
        for (int i=7;i>=0&& u8BitsLeft;i--) {
            if (i<=u8StartBit && i>=(u8StartBit-(u8BitsLeft+numBits))) {
                u8Mask|=u8MaskBit;
                numBits++;
                u8BitsLeft--;
            } else {
                u8EmptyBits++;
            }
            u8MaskBit>>=1;
        }
        u8StartBit=7;
        *pu8Dest = ((*pu8Dest &~u8Mask)|((tU8)(u32Src>>(u8EmptyBits+24))&u8Mask));
        u32Src<<=numBits;
        pu8Dest++;
        u8EmptyBits=0;
    }
}


tVoid vdclk_vGetBits(tU32 *pu32Dst, tU8 u8StartByte, tU8 u8StartBit, tU8 u8NumBits, tU8* pu8Src) {
    tU32 u32Dst= 0;
    tU8 u8StartBitLong = u8StartBit + (tU8)(u8StartByte*8);
    tU8 u8BitsLeft=u8NumBits;
    pu8Src = &pu8Src[u8StartBitLong >>3];
    u8StartBit %= 8;
    while (u8BitsLeft){
        tU8 u8Mask=0;
        tU8 u8MaskBit = 0x80;
        int numBits=0;
        tU8 u8EmptyBits= 0;
        for (int i=7;i>=0&& u8BitsLeft;i--) {
            if (i<=u8StartBit && i>=(u8StartBit-(u8BitsLeft+numBits))) {
                u8Mask|=u8MaskBit;
                numBits++;
                u8BitsLeft--;
            } else {
                u8EmptyBits++;
            }
            u8MaskBit>>=1;
        }
        u8StartBit=7;
        u32Dst<<=numBits;
        tU8 u8WriteVal = (((*pu8Src & u8Mask)>> (8- (u8EmptyBits+numBits))));
        u32Dst |= u8WriteVal;
        pu8Src++;
        u8EmptyBits=0;
    }
    *pu32Dst = u32Dst;
}
