/*
 * vd_clock_updater.h
 *
 *  Created on: Apr 23, 2015
 *      Author: vee4kor
 */

#ifndef VD_CLOCK_UPDATER_H_
#define VD_CLOCK_UPDATER_H_

#include "vd_clock_AppMain.h"
#include "vd_clock_INCAdapter.h"

class vdclk_tclDataContainer;
class vdclk_ExtSourceListener;
class vdclk_tclEvent;

class vd_clock_tclAppMain;
class vd_clock_INCAdapter;
class Ivd_clock_tclClientSensorIf;



//  Definitions for UpdateTrigger event
const tU32    cu32TrigEventTimer                   = 0x00000001UL;
const tU32    cu32TrigEventCANClockReceived        = 0x00000010UL;
const tU32    cu32TrigEventCANClockTimeOut         = 0x00000020UL;
const tU32    cu32TrigEventCANFormatReceived       = 0x00000040UL;
const tU32    cu32TrigEventCANFormatTimeOut        = 0x00000080UL;
const tU32    cu32CmdEventTerminateUpdaterThread   = 0x20000000UL;

//definitions for MIBE BAP events
const tU32    cu32TrigEventVehicledata_CANClockReceived        = 0x00000100UL;
const tU32    cu32TrigEventVehicledata_CANClockTimeOut         = 0x00000200UL;

// definitions for MIBE CAN events
const tU32    cu32TrigEventEXTClock_BAPClockReceived        = 0x00000400UL;
const tU32    cu32TrigEventExtClock_BAPClockTimeOut         = 0x00000800UL;

const tU32    cu32TerminationTimeOutUpdaterThread  = 200;


class vdclk_tclUpdater:public vd_clock_tclBaseIf
{

public:

	vdclk_tclUpdater( vd_clock_tclAppMain* poMainAppl);   // constructor

      virtual ~vdclk_tclUpdater
			(
				tVoid
			);

      tBool bShutdown
         (
         );

      tVoid vTriggerUpdate
         (
            OSAL_tEventMask         u32TrigEvents
         );


      virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
      virtual tVoid vHandleTraceMessage(const tUChar* puchData);
      virtual tVoid vGetReferences();
      virtual tVoid vStartCommunication();
      virtual tVoid vTraceInfo();
      virtual const tChar* getIfName() const { return "vdclk_tclUpdater"; };
      virtual const tChar* getName() const { return "vdclk_tclUpdater"; };
	  
      tVoid                         vStartUpdaterThread
         (
         );

      tS32 retval;
      tBool _RTCOpenReadStatus;
      tBool _RTCValidOnce;

   private:


      static vdclk_tclUpdater*		_poUpdater;       // self-reference
      vdclk_tclDataContainer*       _poContainer;     // data container
      vdclk_tclEvent*               vdclk_poRunIndicator;
      vdclk_ExtSourceListener*         _poExtSourceListener;     // Can-IF
      OSAL_tTimerHandle             _hTickTimer;      // timer object
      OSAL_tIODescriptor            _hRTC;          // real time clock device
      tS32                          _fdRTC;             // real time clock device
      vdclk_tclEvent*               _poUpdateTrigger;
      tU32                          _u32LocalTimeOnLastTick;
      tBool                         _bBAPAvailable;
      tBool                         _bCANAvailable;
      vd_clock_INCAdapter*          m_poINCAdapter;
	  static Ivd_clock_tclClientSensorIf*   _poClientSensor;     // Client Sensor

	    //   vd_clock_tclAppMain*              _poApp;
	  tBool _bDefaultState;
	  tBool _bDefaultStateDA;
	  tBool _bDefaultStateNAR;

      vdclk_tclUpdater
			(
			);


      static tVoid                  vUpdatingLoopStarter
         (
            tVoid* pvArg
         );


      tVoid                  vUpdatingLoop
         (
         );


      tVoid                         vSetupTickTimer
         (
         );

      tVoid                         vShutdownTickTimer
         (
         );

      static tVoid                  vTickTimerCallback
         (
            tVoid *pArg = NULL
         );

};
#endif /* VD_CLOCK_UPDATER_H_ */
