/*
 * vd_clock_container.h
 *
 *  Created on: Apr 23, 2015
 *      Author: Selvakumar Vee
 */

#ifndef VD_CLOCK_CONTAINER_H_
#define VD_CLOCK_CONTAINER_H_

#define  CSM_C_PROJECT_USERSPACE_SMART_HU
#define CSM_S_IMPORT_INTERFACE_GENERIC_USER

#include "csm_if.h"
//#include "..\..\..\..\..\di_can\modules_swa\csm_stack\src\csm_stack_cbr_ip_smart_hu.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_INCAdapter.h"

#include "vd_clock_types.h"
#include "vd_clock_Event.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_vd_clock_if.h"
#include "dp_generic_if.h"

#include "I_vd_clock_ServiceClock.h"

#include "common_fi_if.h"

#include "vd_clock_updater.h"

class vd_clock_tclAppMain;
class vdclk_tclEvent;
class ail_tclAppInterface;
class CSMInterface;
class Ivd_clock_tclClientSensorIf;



struct rtc_time;


#define VEHICLE_CONFIG_ENTRY_KEY 0xA112

// Defines:
#define KDS_C_U16_MAX_RETRIES             ((tU16) 5)

#define Region_USA  0
#define Region_CAN  1
#define Region_MEX  2
#define Region_UK   3
#define Region_TKY  4
#define Region_RUS  5
#define Region_OTHER_EUR  6
#define Region_PRC  7
#define Region_TWN  8
#define Region_HKG  9
#define Region_GCC  10
#define Region_EGP  11
#define Region_ASNZ  12
#define Region_BRA  13
#define Region_AGT  14
#define Region_OTHER_LAC  15
#define Region_SAF  16
#define Region_THI  17
#define Region_SGP  18
#define Region_MLY  19
#define Region_BRN  20
#define Region_INN  21
#define Region_VNM  22
#define Region_PHL  23
#define Region_IND  24
#define Region_JPN  25
#define Region_KOR  26
#define Region_OTHER_GOM  27

#define INITIALIZE_DEFAULT  0xFF

// ****************************************************************************
// ***						Class   D a t a - C o n t a i n e r						 ***
// ****************************************************************************

class vdclk_tclDataContainer:public vd_clock_tclBaseIf
{

	// =========================================================================
	// ===								I n t e r f a c e									 ===

public:


	vdclk_tclDataContainer( vd_clock_tclAppMain* poMainAppl);

	virtual  ~vdclk_tclDataContainer();

    tVoid vShutdown();

	tVoid SendDateTimeStatusCAN(tU16 u16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minute, tU8 u8Second, tU8 u8WeekDay);
	tVoid SendDateTimeStatusCANVariant(tU16 u16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minute, tU8 u8Second, tU8 u8WeekDay);

    tVoid vOnTickTimerEvent( const  rtc_time& tNewValue, const OSAL_tenRtcTimeState enRTCTimeState);

    /*tVoid vOnClockExtSourceListenerEvent(const OSAL_trTimeDate&rNewValue,
                                              tU8   u8ChangeMask);*/

    tVoid vOnFormatExtSourceListenerEvent(// VDCLK_TEN_TimeFormat enTimeFormat,
                                         // VDCLK_TEN_DateFormat enDateFormat,
    		                              tU32 u32TimeFormat,
    		                              tU32 u32DateFormat,
                                          tBool bFormatMasterAvailable);

    tVoid vUpdateClockSourceStatus( VDCLK_TEN_ClockSourceStatus NewStatus);



    tVoid vSetDefaultSettings(tBool bResetAllUsers);
///////////////////////////////////////////////////////////////////////SMART_CAN/////////////////////////////
	tVoid SetLocalDateTimeSMART( tU8 u8Hour, tU8 u8Minute);
	tVoid SetTimeFormatSMART( tBool bTimeFormat);
	
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    tVoid vGetLocalDateTime(vdclk_tclDateTime* poLocalDateTime);

    tVoid vSetLocalDateTime(vdclk_tclDateTime const * const poNewLocalDateTime);

	 tVoid vSetCANLocalDateTime(vdclk_tclDateTime const * const poNewLocalDateTime);

    tVoid vGetSystemDateTime(vdclk_tclDateTime& poSystemDateTime) const;

	tVoid ReceivedSecondsFromCAN();

    VDCLK_TEN_TimeFormat enGetTimeFormat() const;

    tVoid vSetTimeFormat(VDCLK_TEN_TimeFormat NewFormat);
    tVoid vSetTimeFormatGeneric(VDCLK_TEN_TimeFormat NewFormat);



    VDCLK_TEN_DateFormat enGetDateFormat() const;

    VDCLK_TEN_NewDateFormat enGetNewDateFormat() const;

    tVoid vSetDateFormat(VDCLK_TEN_DateFormat NewFormat);

    tVoid vSetNewDateFormat(VDCLK_TEN_NewDateFormat NewFormat);

      // -------------------------------------------------------

    VDCLK_TEN_ClockSourceStatus enGetClockSourceStatus() const;

      // -------------------------------------------------------

    VDCLK_TEN_FormatSourceStatus enGetFormatSourceStatus() const;

    tBool bGetDaylightSavingTimeOn(tVoid) const;

    tBool bGetDaylightSavingTimeAuto(tVoid) const;

    tVoid vSetDaylightSavingTime ( VDCLK_TEN_DST_Setting const enDST_Setting,
                                     tBool hmi_update);
    tVoid vSetDaylightSavingTimeGeneric( VDCLK_TEN_DST_Setting const enDST_Setting,
            tBool hmi_update);

    VDCLK_TEN_DST_Setting enGetDaylightSavingTimeStatus() const;


    tVoid vSetGPS_AutoSync(tBool bEnabled,
                             tBool bPositionBased=FALSE);
    tVoid vSetGPS_AutoSyncGeneric(tBool bEnabled,
            tBool bPositionBased=FALSE);

     //tVoid vSetGPS_AutoSync (tBool  bEnabled);

    tBool bGetGPS_AutoSync(tVoid) const;
    tBool bGetPositionBased(tVoid) const;

    tBool vGetClockMode() const;
	
	

    unsigned char getGPSType();
    unsigned char getVariantSelection();
    unsigned char getOEMType();

    tVoid  vSetSyncMode (VDCLK_TEN_SyncMode enSyncMode);

    VDCLK_TEN_SyncMode enGetSyncMode(tVoid) const;

      // -------------------------------------------------------
    tU16 u16GetTimeZoneIndex() const;

    tVoid vSetTimeZone(tU16 const u16TimezoneIndex);
    tVoid vSetTimeZoneGeneric(tU16 const u16TimezoneIndex);

 tVoid vSetRegionTimeZone(VDCLK_TEN_TIMEZONE_Setting const enTIMEZONE_Setting);

 tVoid vSetAutoTimeZoneOffset(tS64  offset_hour,
                              tS64 offset_minute);
 tVoid vSetAutoTimeZoneOffsetGeneric(tS64  offset_hour,
                              tS64 offset_minute);

 //tVoid defaultValue();
 //tVoid defaultValueforGPS();
  tVoid vStoreDefaultSystemTime();
  
 // tVoid vFactoryResetValue();
 tVoid defaultDynamicOffset();
 
  tVoid vFactoryReset();
 tVoid vTimeFormatReset();
      // -------------------------------------------------------
	   //CRQI 029
    VDCLK_TEN_GPS_EPOCH enGetGPSEpoch() const;

	tVoid enSetGPSEpoch(VDCLK_TEN_GPS_EPOCH epoch);

      // ----------------------------------

    tS64 s64GetLocalTimeOffset()const;

    VDCLK_TEN_GPSRTCTIMESTATE enGetRtcTimeState()const;

    VDCLK_DSTAutoState enGetDSTAutoState()const;


    tVoid vSetCANAvailability(tBool bAvailable);

    tBool bGetBAPAvailability();
    tBool bGetCANAvailability();

    tVoid vSetLastKnownDSTSettings(tU16 u16AutoSetDST);
    tVoid vSetLastKnownTZSettings(tU16 u16AutoSetTZ);



    tU16 u16GetAutoTZIndex();
    tU16 u16GetAutoDSTState();
    tU16 u16GetAutoTimezoneOffset();

    tVoid vReadfromDatapool();
    tVoid vStoretoDatapool();
	//tVoid vStoretoDP();

    tVoid vSetGPSTime(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minute, tU8 u8Second);
	tVoid vSetCANTime(tS16 u8Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour, tU8 u8Minute, tU8 u8Second);

      // ---   Data storage functions   ---

    tVoid vLoadData(tVoid);

    tVoid vSaveData(tBool bDelayedWriting = FALSE);

    virtual tVoid vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg);
    virtual tVoid vHandleTraceMessage(const tUChar* puchData);
    virtual tVoid vGetReferences();
    virtual tVoid vStartCommunication();
    virtual tVoid vTraceInfo();
    virtual const tChar* getIfName() const { return "vdclk_tclDataContainer"; };
    virtual const tChar* getName() const { return "vdclk_tclDataContainer"; };
    int hour_sign, min_sign;
    tS64 								offset_minute;
    tS64 								offset_hour;
    tVoid SendMCANSettings_Status(tU8 invalid);
    tVoid SendMCANNotification();
    void getRegionBasedSupportedTimeZone(tU8 u8region);
    void getRegionBasedSupportedDateFormat(tU8 u8region);

    bpstl::vector<clock_fi_tclString, bpstl::allocator<clock_fi_tclString> > _supportedTimeZoneList;
    bpstl::vector<tU16, bpstl::allocator<tU16> > _u16IndexeList;
    tVoid vUpdateDSTSensorTime(tS32 _DSTDiff, tS32 _TZDiff);
    tVoid vUpdateTZSensorTime(tS32 _TZDiff);
    //static Ivd_clock_tclClientSensor_pvIf* _poClientSensor;

    tU8 u8Region,u8regioncode, u8OEMType;
	
	tVoid SendMCANSettings_Set();
    tVoid SetMCANTimeFormat(tU8 u8MCANTimeFormat);
    tVoid SetMCANClockMode(tU8 u8MCANSyncMode);
    tU8 SetMCANClock(tU8 Param1, tU8 Param2, tU8 Param3);
    tVoid SetMCANOffsetHourMinute(tU8 u8MCANOffsetHour, tU8 u8MCANOffsetMinute);
    tVoid SetMCANDST(tU8 u8MCANDST);
    tVoid SetMCANTimezone(tU8 u8MCANTimezone);

    tVoid vAppState(tU32 AppState);
    tVoid vDefaultInitialization(tU32 AppState, tBool _bRTCVAlid);

    tVoid vToManualTimeInitialization(tBool bEnabled, tBool bPositionBased);
	tVoid SetCANTimeAvailabity(tBool status);
	tU8 _VariantType;
	tBool _bfirstLocalMinute;
	
	tU16 _TotalMintes;
	tBool _TimeFormat;

	//tU8 _MCANOffsetHr, _MCANOffsetMin, _MCANHour,_MCANMinute;
	tU8 _InvalidParam;
	tBool Flag_TZ;
	VDCLK_TEN_DomainOffset enPrevDomainOffset;

	tVoid SetHUDActivateToCAN(VDCLK_TEN_HUDACTIVATE enHUDActivate);
	tBool vReadHUDDeployment();

private:



      OSAL_tSemHandle                  _hDataUpdateSemaphore;
      vdclk_tclDateTime	               _oSystemTime;
      vdclk_tclDateTime 				_oLocalTime;

      tS64   			               _s64DynOffset[VDCLK_EN_DomainCount];//
      tU16                             _u16TimeZoneIndex;
      tBool                            _bDST_ON;
      tBool                            _bDST_AutoSet;
      tBool                            _isPositionBased;
      tBool                            _isEnabled;
      tBool                            _isDefaultSetting;
      VDCLK_TEN_SyncMode               _enSyncMode;
      VDCLK_TEN_TimeFormat             _enTimeFormat;
      VDCLK_TEN_DateFormat             _enDateFormat;
      VDCLK_TEN_NewDateFormat		   _enNewDateFormat;
      VDCLK_TEN_ClockSourceStatus      _enClockSourceStatus;
      VDCLK_TEN_FormatSourceStatus     _enFormatSourceStatus;
	  VDCLK_TEN_GPS_EPOCH			   _enGPSEpoch;
      VDCLK_TEN_GPSRTCTIMESTATE        _enRTCTimeState;
      tS64                             _s64Offs;
      tBool                            _bIsOffsetValid;
      VDCLK_TEN_DST_Setting            _enDaylightSaving;
      tU8                              _enRegionCode;
      tBool                            _bSummerTimeSET;
      tBool                            _bWinterTimeSET;
      VDCLK_DSTAutoState               _enDSTAutoState;
      tBool                            _bBapAvailable;
      tBool                            _bCanAvailable;

      tU32                             _u32PrevSystemTimeOffset;
      tU32                             _u32DateFormat;
      tU32                             _u32TimeFormat;

      tU16                             _u16AutoSetTZ;
      tU16                             _u16AutoSetDST;
      tU64								_u64AutoTimezoneOffset;

      tBool								_bDefaultSetting;
	  static Ivd_clock_tclServiceClockIf* _poServiceHandler;
	  tBool 							_bGetTimeZoneAvailability;
	  static Ivd_clock_tclClientSensorIf*   _poClientSensor;     // Client Sensor
	  tBool                              _cantimeavailable;

	  //tU8 SensorUpdate_Flag;
	  //tBool bEnabled, bPositionBased;
	  tS64 RTC_ManualOffset;
	  tBool _bSystemTimeSet;

	  tU32 _u32AppState;
	  tBool _bRTCVAlid, _bDefaultSettingFlag;


      /*
   tU8 _CSMHour;
   tU8 _CSMMinute;
   tU8 _CSMSecond;
   tU16 _CSMYear;
   tU8 _CSMMonth;
   tU8 _CSMDay;
   tU8 _CSMWeekDay;
   */
   
  CSMInterface* _poMyCSMInterface;
   
   
    //  vdclk_tclEvent*                   vdclk_poNotificationTrigger;
    //  vdclk_tclEvent*                   vdclk_poRunIndicator;

     // vd_clock_tclAppMain*              _poApp;

      vd_clock_INCAdapter*          _poINCAdapter;
	  vdclk_tclUpdater* _poUpdater;
	  
      //tVoid vUpdateAutomaticTime (tVoid);
      tVoid vUpdateTZAutomaticTime(tVoid);

      tVoid vHandleDSTAutoMEZ(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour);
      tVoid vHandleDSTAutoUSA(tS16 s16Year, tU8 u8Month, tU8 u8Day, tU8 u8Hour);



      tVoid vUpdateSystemTime(vdclk_tclDateTime const * const poMasterDateTime);

      tVoid vStoreOSSystemTime();
      tVoid vStoreLocalTime();
      tVoid ReceiveChangeStatus(tS64 Offset_Hour, tS64 Offset_Minute);

      unsigned char _GPSType;
      

      // ---   Protecting functions   ---

      tVoid vEnterCriticalSection (tCString from);

      tVoid vReleaseCriticalSection (tCString from);


      static tVoid vWriteToFFS (tVoid*  pvArg);

      bpstl::vector <VDCLK_TEN_DateFormat>  _vDateFormat;
      bpstl::vector <VDCLK_TEN_TimeFormat>  _vTimeFormat;
      bpstl::vector <VDCLK_TEN_NewDateFormat>  _vNewDateFormat;




      // KDS related members
     // tU8 data[KDS_MAX_ENTRY_LENGTH];

      // Read KDS data
       tBool ReadKDS();


      // Functions
      // Open OSAL KDS device
      tVoid open( tVoid );

      // Close OSAL KDS device
      tVoid close( tVoid );



      //! structure used to describe KDS entries
      // tsKDSEntry           mEntryData;

      // Members
      //! device descriptor of the KDS driver
      OSAL_tIODescriptor   mDrvHandle;

      // to check if OSAL KDS device is open
      tBool                mIsOpen;


      // dp objects

      dp_tclVDClockDpMasterModeOffset _oDpMasterModeOffset;
      dp_tclVDClockDpAutoModeOffset   _oDpAutoModeOffset;
      dp_tclVDClockDpTimezoneIndex    _oDpTimezoneIndex;
      dp_tclVDClockDpbGPSAutoSync     _oDpbGPSAutoSync;
      dp_tclVDClockDpbAutoEnabled     _oDpAutoEnabled;
      dp_tclVDClockDpbDST             _oDpbDST;
      dp_tclVDClockDpbDSTAutoSet      _oDpbDSTAutoSet;
      dp_tclVDClockDpTimeformat       _oDpTimeformat;
      dp_tclVDClockDpDateformat       _oDpDateformat;
      dp_tclVDClockDpSyncmode         _oDpSyncmode;
      dp_tclVDClockDpbDefaultSetting  _oDpDefaultsetting;
	  
	  dp_tclVDClockDpAutoTZOffset	 _oDpAutoTZOffset; 
	  dp_tclVDClockDpOffset_Minute	_oDpMinuteOffset;
	  dp_tclVDClockDpOffset_Hour	_oDpHourOffset;
	  
	  dp_tclVDClockDpDomain_TZOffset	_oDpTZModeOffset;
	  dp_tclVDClockDpDomain_ManualOffset	_oDpManualModeOffset;
	  dp_tclVDClockDpDomain_AutoOffset	  	_oDpAutomaticModeOffset;

         tU8 ReceiveMCANTimeformatStatus();
         tVoid ReceiveMCANDSTStatus();

         tVoid ReceiveMCANClockModeStatus();
         tVoid ReceiveMCANOffsetHourStatus();
         tVoid ReceiveMCANOffsetMinuteStatus();
         tVoid ReceiveMCANTimezoneStatus();
         tVoid ReceiveMCANClockStatus();

         tU8 ClockInfo_Mode,ClockMode_Disp, ClockInfo_Disp, ClockInfo_Clock,ClockINfo_Hr,ClockInfo_Min,OffsetHr_Sign,OffsetHr_Val,OffsetMin_Sign,OffsetMin_Val,ClockInfo_TZState,ClockInfo_TZVal, ClockDST_State, ClockDST_Value;
};



#endif /* VD_CLOCK_CONTAINER_H_ */
