/*
 * vd_clock_INCAdapter.cpp
 *
 *  Created on: Jul 31, 2015
 *      Author: vee4kor
 */

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_INCADAPTER
#include "trcGenProj/Header/vd_clock_INCAdapter.cpp.trc.h"
#endif
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
//#define _CLASS    ((tU16) TR_CLASS_VD_CLOCK_INCADAPTER)

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "vd_clock_INCAdapter.h"
#include "vd_clock_AppMain.h"
#include "vd_clock_updater.h"
#include <pthread.h>
#include <unistd.h>
#include "inc.h"
#include "inc_ports.h"
#include "vd_clock_ClientDiaglogIf.h"
#include "vd_clock_ServiceClockIf.h"
#include "vd_clock_datacontainer.h"

tBool vd_clock_INCAdapter::terminateReceiverThread = FALSE;
int vd_clock_INCAdapter::INCClockSocket = -1;

 OSAL_trTimeDate vd_clock_INCAdapter::_tMCANTimeDate;

vdclk_tclUpdater* vd_clock_INCAdapter::_poUpdater = NULL;
Ivd_clock_tclClientDiaglogIf* vd_clock_INCAdapter:: _poDiagHandler = NULL;
Ivd_clock_tclServiceClockIf* vd_clock_INCAdapter:: _poServiceHandler = NULL;
vdclk_tclDataContainer*  vd_clock_INCAdapter:: _poContainer = NULL;
vdclk_MeterSettings vd_clock_INCAdapter::_tMeterSettings;

tU8 vd_clock_INCAdapter::_u8ConnectionState=0;
tU8 vd_clock_INCAdapter::_u8CommunicationState=0;
tU8 vd_clock_INCAdapter::_u8MuteState=0;
tU8 vd_clock_INCAdapter::_u8TroubleCode=0;
tBool vd_clock_INCAdapter::_bConnectionStateChange=FALSE;
tBool vd_clock_INCAdapter::_bLogITC=FALSE;
tBool vd_clock_INCAdapter::_isSWCMCANConfigured=FALSE;

vd_clock_INCAdapter::vd_clock_INCAdapter(vd_clock_tclAppMain* poMainAppl):vd_clock_tclBaseIf(poMainAppl)
{
   ETG_TRACE_USR4(("vd_clock_INCAdapter Constructor"));

  // tBool SocketEstablished = FALSE;

   _tMCANTimeDate.s32Year = 2017;
   _tMCANTimeDate.s32Month = 1;
   _tMCANTimeDate.s32Day = 1;
   _tMCANTimeDate.s32Hour = 0;
   _tMCANTimeDate.s32Minute = 0;
   _tMCANTimeDate.s32Second = 0;
   remote = NULL;
   local = NULL;		//Coverity Fix - Not initialized
   vd_clock_INCAdapter::createMessageObserver();
   vd_clock_INCAdapter::createSocket();
   vd_clock_INCAdapter::connectPort();
}

vd_clock_INCAdapter::~vd_clock_INCAdapter()
{
	ETG_TRACE_USR4(("vd_clock_INCAdapter Destructor"));
	terminateReceiverThread = TRUE;

	local = NULL;
	remote = NULL;
	_poUpdater= NULL;
	_poContainer = NULL;
   // wait for end of Receiver thread
   pthread_join(ReceiverThread, NULL);

   close(INCClockSocket);
}


tBool vd_clock_INCAdapter::createMessageObserver()
{
   tBool threadCreatePassed = TRUE;

   if (pthread_create(&ReceiverThread, NULL, &MessageReceiver, NULL) != 0)
   {
	  ETG_TRACE_USR4(("vd_clock_INCAdapter Receiver Thread create FAILED \n"));
      exit (EXIT_FAILURE);
      threadCreatePassed = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }
   else
   {
	   ETG_TRACE_USR4(("vd_clock_INCAdapter Receiver Thread create passed\n"));

   }

   return (threadCreatePassed);
}

tBool vd_clock_INCAdapter::createSocket()
{
   tBool CreatePassed = TRUE;
   //   non blocking socket
   INCClockSocket = socket(AF_BOSCH_INC_AUTOSAR, SOCK_STREAM, 0);

   if (-1 == INCClockSocket)
   {

	  ETG_TRACE_USR4(("vd_clock_INCAdapter socket for INC clock create FAILED!  Socket Id: %d\n", INCClockSocket));

      CreatePassed = FALSE;
      FATAL_M_ASSERT_ALWAYS();
   }
   else
   {
	   ETG_TRACE_USR4(("vd_clock_INCAdapter socket for INC clock is created  Socket Id: %d\n", INCClockSocket));
   }
   return (CreatePassed);
}


tBool vd_clock_INCAdapter::connectPort()
{
   tBool ConnectPassed = TRUE;

   if (-1 == INCClockSocket)
   {
      ConnectPassed = FALSE;
   }
   else
   {
      //get local and remote addresses and ports
      local = gethostbyname("scc-local");
      if ( NULL == local)
      {
    	 ETG_TRACE_USR4(("vd_clock_INCAdapter local host get FAILED: return value: %d\n", local));
         ConnectPassed = FALSE;
      }
      else
      {
         memcpy((char *) &local_addr.sin_addr.s_addr, (char *) local->h_addr, local->h_length);
         local_addr.sin_family = AF_INET;
         local_addr.sin_port = htons(PRJ_COMP_PORT); /* from inc_ports.h *///To be checked This will append LUNID 0x29 for RTC cluster

         // bind socket
         int bindReturn = bind(INCClockSocket, (struct sockaddr *) &local_addr, sizeof(local_addr));
         if (0 != bindReturn)
         {

        	ETG_TRACE_USR4(("vd_clock_INCAdapter binding FAILED: return value: %d\n", bindReturn));

            ConnectPassed = FALSE;

         }
         remote = gethostbyname("scc");
         if (NULL == remote)
         {

        	ETG_TRACE_USR4(("vd_clock_INCAdapter remote host get FAILED: return value: %d\n", remote));

            ConnectPassed = FALSE;

         }
         else
         {
            memcpy((char *) &remote_addr.sin_addr.s_addr, (char *) remote->h_addr, remote->h_length);
            remote_addr.sin_family = AF_INET;
            remote_addr.sin_port = htons(PRJ_COMP_PORT); /* from inc_ports.h */

         }

         // connect to remote adress/port
         if (0 != connect(INCClockSocket, (struct sockaddr *) &remote_addr, sizeof(remote_addr)))
         {

        	ETG_TRACE_USR4(("vd_clock_INCAdapter connect FAILED!\n"));

            ConnectPassed = FALSE;

         }
         else
         {
        	 ETG_TRACE_USR4(("vd_clock_INCAdapter socket connection passed!\n"));

         }
      }
      if ( FALSE == ConnectPassed)
      {
         close(INCClockSocket);
         INCClockSocket = -1;
      }
   }
   return (ConnectPassed);
}


void* vd_clock_INCAdapter::MessageReceiver(void* Data)
{

   ETG_TRACE_USR4 (("vd_clock_INCAdapter :: MessageReceiver Entered :: Data	 %d ", Data));

   tU8 ReceivedBuffer[INC_MESSAGE_RECEIVER_BUFFER_SIZE];
   int NumberOfBytesReceived = 0;

   while (FALSE == terminateReceiverThread)
   {
      NumberOfBytesReceived = recv(INCClockSocket, ReceivedBuffer, sizeof(ReceivedBuffer), 0);

      ETG_TRACE_USR4(("vd_clock_INCAdapter MessageReceiver (ThreadId: %d): no of byte received: %d\n", pthread_self(),NumberOfBytesReceived));


      if (-1 == NumberOfBytesReceived)
      {

      ETG_TRACE_USR4(("vd_clock_INCAdapter MessageReceiver: receive FAILED: %d\n", NumberOfBytesReceived));

		}else if(ReceivedBuffer[0] == 0x31)
		{
/*			if(NumberOfBytesReceived == 6)
			{
				_tMCANTimeDate.s32Hour   = (tS32)ReceivedBuffer[1];
				_tMCANTimeDate.s32Minute = (tS32)ReceivedBuffer[2];
				_tMCANTimeDate.s32Second = (tS32)ReceivedBuffer[3];
				_tMCANTimeDate.s32Day    = (tS32)ReceivedBuffer[4];
				_tMCANTimeDate.s32Month  = (tS32)ReceivedBuffer[5];

				tU16 u16Year = (tU16)ReceivedBuffer[6];

				tU16 u16temp = (tU16)ReceivedBuffer[7];
				u16temp = u16temp << 8;

				u16Year = u16Year | u16temp;

				_tMCANTimeDate.s32Year   = (tS32)u16Year;

				ETG_TRACE_USR4(("vd_clock_INCAdapter Message from INC  _tMCANTimeDate.s32Hour   : %d\n", ReceivedBuffer[1]));
				ETG_TRACE_USR4(("vd_clock_INCAdapter Message from INC  _tMCANTimeDate.s32Minute : %d\n", ReceivedBuffer[2]));
				ETG_TRACE_USR4(("vd_clock_INCAdapter Message from INC  _tMCANTimeDate.s32Second : %d\n", ReceivedBuffer[3]));
				ETG_TRACE_USR4(("vd_clock_INCAdapter Message from INC  _tMCANTimeDate.s32Day    : %d\n", ReceivedBuffer[4]));
				ETG_TRACE_USR4(("vd_clock_INCAdapter Message from INC  _tMCANTimeDate.s32Month  : %d\n", ReceivedBuffer[5]));

				ETG_TRACE_USR4(("vd_clock_INCAdapter Message from INC   ReceivedBuffer[6]  : %d\n", ReceivedBuffer[6]));
				ETG_TRACE_USR4(("vd_clock_INCAdapter Message from INC   ReceivedBuffer[7]  : %d\n", ReceivedBuffer[7]));

				ETG_TRACE_USR4(("vd_clock_INCAdapter Message from INC  _tMCANTimeDate.s32Year   : %d\n", _tMCANTimeDate.s32Year ));


				if(_poUpdater != NULL)
				{
					_poUpdater->vTriggerUpdate(cu32TrigEventCANClockReceived);
				}
				else
				{
					ETG_TRACE_USR4(("_poUpdater is NULL \n"));
				}
			}*/

      }
      else if (ReceivedBuffer[0] == 0x41)
      {

			if(_poServiceHandler != NULL)
			{
				_poServiceHandler->sendResetHistoryMResult();
			}

		}
		else if (ReceivedBuffer[0] == 0x43)
		{
			if(NumberOfBytesReceived == 5)
			{
				tU8 u8ReceivedConnectionState = ReceivedBuffer[1];
				tU8 u8ReceivedCommunicationstate = ReceivedBuffer[2];
				tU8 u8ReceivedMuteState = ReceivedBuffer[3];
				tU8 u8ReceivedTroubleCode = ReceivedBuffer[4];

    	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u8ReceivedCommunicationstate: %d", u8ReceivedCommunicationstate));
    	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u8ReceivedMuteState: %d", u8ReceivedMuteState));
    	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u8ReceivedTroubleCode: %d", u8ReceivedTroubleCode));
    	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u8ReceivedConnectionState: %d", u8ReceivedConnectionState));


    	  vCheckforCommunicationState(u8ReceivedConnectionState,u8ReceivedCommunicationstate,u8ReceivedMuteState,u8ReceivedTroubleCode);
    	  if(_poDiagHandler && _isSWCMCANConfigured)
    	  {
    		 _poDiagHandler-> vCheckforITCLog(_u8TroubleCode,_u8CommunicationState,_u8MuteState);
    		 

				}
				if(_bConnectionStateChange && _poServiceHandler && _isSWCMCANConfigured)
				{
					//Update Connection Property :To do
					clock_fi_tcl_SWC_UnitConnectionStatus tConnectionStatus;
					tConnectionStatus.e8UnitType.enType = clock_fi_tcl_e8_UnitType::FI_EN_SWSC;
					tConnectionStatus.bConnected = TRUE;
					if(_u8ConnectionState !=0x01)
					{
						tConnectionStatus.bConnected=FALSE;
					}
					tConnectionStatus.u8AbsenceState = _u8CommunicationState;
					tConnectionStatus.u8MuteState = _u8MuteState;
					ETG_TRACE_USR4(("vd_clock_INCAdapter ConnectionState Changed"));
					_bConnectionStateChange = FALSE;

					_poServiceHandler->sendConnectionStatus(tConnectionStatus);
				}
			}
		}

      else if(ReceivedBuffer[0] == 0x3D)
      {
    	  ETG_TRACE_USR4(("vd_clock_INCAdapter ClockSettings Set"));
    	  tU8 OEMValue ;

    	  if(_poContainer)
    	  {
    		  OEMValue =  _poContainer->u8OEMType;
    		  ETG_TRACE_USR4(("vd_clock_INCAdapter ClockSettings Set %d ",OEMValue ));
    		 if(OEMValue)
    		 {
				if(NumberOfBytesReceived == 10)
				{
				_tMeterSettings._u8SetTimeFormat = ReceivedBuffer[1];
				_tMeterSettings._u8SetClockMode = ReceivedBuffer[2];
				_tMeterSettings._u8SetClock = ReceivedBuffer[3];
				_tMeterSettings._u8SetClockHour = ReceivedBuffer[4];
				_tMeterSettings._u8SetClockMinute = ReceivedBuffer[5];
				_tMeterSettings._u8SetClockOffsetHour = ReceivedBuffer[6];
				_tMeterSettings._u8SetClockOffsetMinute = ReceivedBuffer[7];
				_tMeterSettings._u8SetDST = ReceivedBuffer[8];
				_tMeterSettings._u8SetTimezone = ReceivedBuffer[9];
				_poContainer->SendMCANSettings_Set();
				}
			}
    	  }

      }
      else if(ReceivedBuffer[0] == 0x3B)
      {
    	  ETG_TRACE_USR4(("vd_clock_INCAdapter ClockSettings Get"));
    	  tU8 OEMValue ;

		  if (_poContainer)
		  {
			  OEMValue =  _poContainer->u8OEMType;
			  ETG_TRACE_USR4(("vd_clock_INCAdapter ClockSettings Set %d ",OEMValue ));
			if(OEMValue)
			 {
				_poContainer->SendMCANSettings_Status(_poContainer->_InvalidParam);
			 }
		  }
      }
     else if(ReceivedBuffer[0] == 0x45)
		{
			if(NumberOfBytesReceived == 4)
                 {
               	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedHWVersionInfo: %d", ReceivedBuffer[0]));

               	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedHWVersionInfo: %d", ReceivedBuffer[1]));
               	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedHWVersionInfo: %d", ReceivedBuffer[2]));
               	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedHWVersionInfo: %d", ReceivedBuffer[3]));

               	tU32 u32ReceivedHWVersionInfo = ((tU32)ReceivedBuffer[1] <<  16) | ((tU32)ReceivedBuffer[2] << 8) | (tU32)ReceivedBuffer[3];
               	ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedHWVersionInfo: %d", u32ReceivedHWVersionInfo));

               	  if(_poServiceHandler)
               	  {
               		  bpstl::vector<clock_fi_tcl_VdClock_UnitVersion, bpstl::allocator<clock_fi_tcl_VdClock_UnitVersion> > oVersionStatus;
               		clock_fi_tcl_VdClock_UnitVersion oVersion;
               		  oVersion.e8UnitType.enType = clock_fi_tcl_e8_MCanUnitType::FI_EN_DIAGNOSTICS;
               		  oVersion.rVersion.u8Upper= ReceivedBuffer[1]; //Upper
               		  oVersion.rVersion.u8Mid=  ReceivedBuffer[2];  //Middle
               		  oVersion.rVersion.u8Lower = ReceivedBuffer[3];  //Lower

               		  oVersionStatus.assign(100,oVersion);
               		  _poServiceHandler ->sendHardwareVersionStatus(oVersionStatus);

               	  }
			}

                 }
                 else if(ReceivedBuffer[0] == 0x47)
		{
			if(NumberOfBytesReceived == 4)
			{
				ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedSWVersionInfo: %d", ReceivedBuffer[0]));

               	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedSWVersionInfo: %d", ReceivedBuffer[1]));
               	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedSWVersionInfo: %d", ReceivedBuffer[2]));
               	  ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedSWVersionInfo: %d", ReceivedBuffer[3]));

               	tU32 u32ReceivedSWVersionInfo = ((tU32)ReceivedBuffer[1] <<  16) | ((tU32)ReceivedBuffer[2] << 8) | (tU32)ReceivedBuffer[3];
               	ETG_TRACE_USR4(("vd_clock :INC_Adapter::u32ReceivedSWVersionInfo: %d", u32ReceivedSWVersionInfo));

               	  if(_poServiceHandler)
               	  {
               		  bpstl::vector<clock_fi_tcl_VdClock_UnitVersion, bpstl::allocator<clock_fi_tcl_VdClock_UnitVersion> > oVersionStatus;
               		clock_fi_tcl_VdClock_UnitVersion oVersion;
               		  oVersion.e8UnitType.enType = clock_fi_tcl_e8_MCanUnitType::FI_EN_DIAGNOSTICS;
               		  oVersion.rVersion.u8Upper= ReceivedBuffer[1]; //Upper
               		  oVersion.rVersion.u8Mid=  ReceivedBuffer[2];  //Middle
               		  oVersion.rVersion.u8Lower = ReceivedBuffer[3];  //Lower

               		  oVersionStatus.assign(100,oVersion);
               		 _poServiceHandler ->sendSoftwareVersionStatus(oVersionStatus);


				}
			}

                 }
      //sleep(100); //This should be removed and not used
   }


   ETG_TRACE_USR4(("vd_clock :INC_Adapter::MessageReceiver: leaving thread now\n"));

   pthread_exit((void *) pthread_self());

   return 0;
}

int vd_clock_INCAdapter::sendMessage(/*int Socket,*/void* Data, size_t DataLength)
{

   int BytesSent = 0;

   BytesSent = write(INCClockSocket, Data, DataLength);

   ETG_TRACE_USR4(("vd_input_INCAdapter::sendMessage: no of bytes sent: %d\n", BytesSent));

   return (0);
//   return write(Socket, Data, DataLength);
}


tVoid vd_clock_INCAdapter::vGetMCANTime(OSAL_trTimeDate &tMCANTimeDate)
{
	ETG_TRACE_USR4(("vGetMCANTime()"));

	tMCANTimeDate.s32Hour = _tMCANTimeDate.s32Minute;
	tMCANTimeDate.s32Minute = _tMCANTimeDate.s32Minute;
	tMCANTimeDate.s32Second = _tMCANTimeDate.s32Second;
	tMCANTimeDate.s32Day = _tMCANTimeDate.s32Day;
	tMCANTimeDate.s32Month = _tMCANTimeDate.s32Month;
	tMCANTimeDate.s32Year = _tMCANTimeDate.s32Year;

}


tVoid vd_clock_INCAdapter::vTestINCReceive(OSAL_trTimeDate &MCANTimeDate)
{
	ETG_TRACE_USR4(("vTestINCReceive()"));
	_tMCANTimeDate = MCANTimeDate;

	ETG_TRACE_USR4(("vd_clock_INCAdapter TestINCReceive _tMCANTimeDate.s32Year    : %d\n", _tMCANTimeDate.s32Year));
	ETG_TRACE_USR4(("vd_clock_INCAdapter TestINCReceive _tMCANTimeDate.s32Month   : %d\n", _tMCANTimeDate.s32Month));
	ETG_TRACE_USR4(("vd_clock_INCAdapter TestINCReceive _tMCANTimeDate.s32Day     : %d\n", _tMCANTimeDate.s32Day));
	ETG_TRACE_USR4(("vd_clock_INCAdapter TestINCReceive _tMCANTimeDate.s32Hour    : %d\n", _tMCANTimeDate.s32Hour));
	ETG_TRACE_USR4(("vd_clock_INCAdapter TestINCReceive _tMCANTimeDate.s32Minute  : %d\n", _tMCANTimeDate.s32Minute));
	ETG_TRACE_USR4(("vd_clock_INCAdapter TestINCReceive _tMCANTimeDate.s32Second  : %d\n", _tMCANTimeDate.s32Second));


	if(_poUpdater != NULL)
	{
		_poUpdater->vTriggerUpdate(cu32TrigEventCANClockReceived);
	}
	else
	{
		ETG_TRACE_USR4(("_poUpdater is NULL \n"));
	}
}

tVoid vd_clock_INCAdapter::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
	(tVoid)pMsg; //to make lint happy
}

tVoid vd_clock_INCAdapter::vStartCommunication()
{
	tU8 u8Temp = 0x00;
	    	  	//! read MCANSWC configuration
	    	  	if ( DP_S32_NO_ERR == DP_s32GetConfigItem("VehicleInformation","SteeringSW",&u8Temp,1) )
	    	  	{
	    	  		( u8Temp == 0x01 ) ? (_isSWCMCANConfigured = TRUE) : (_isSWCMCANConfigured = FALSE);
	    	  	}

	    	  	 ETG_TRACE_USR4(("vd_clock_INCAdapter Message Datapool SteeringSW  : %d\n", u8Temp));

	    	  	if(_poServiceHandler && !_isSWCMCANConfigured)
	    	  	{
	    	  		//Update Connection Property :To do
	    	  		clock_fi_tcl_SWC_UnitConnectionStatus tConnectionStatus;
	    	  		tConnectionStatus.e8UnitType.enType = clock_fi_tcl_e8_UnitType::FI_EN_SWSC;
	    	  		tConnectionStatus.bConnected=FALSE;
	    	  		tConnectionStatus.u8AbsenceState = 0xFF;
	    	  		tConnectionStatus.u8MuteState = 0xFF;


	    	  		_poServiceHandler->sendConnectionStatus(tConnectionStatus);
	    	  	}

}

tVoid vd_clock_INCAdapter::vGetReferences()
{
	_poUpdater = dynamic_cast<vdclk_tclUpdater*>(_cpoMain->getHandler("vdclk_tclUpdater"));
	VD_CLOCK_NULL_POINTER_CHECK(_poUpdater);
	_poDiagHandler = dynamic_cast<vd_clock_tclClientDiaglogIf*>(_cpoMain->getHandler("Ivd_clock_tclClientDiaglogIf"));
		VD_CLOCK_NULL_POINTER_CHECK(_poDiagHandler);
	_poServiceHandler = dynamic_cast<vd_clock_tclServiceClockIf*>(_cpoMain->getHandler("Ivd_clock_tclServiceClockIf"));
	VD_CLOCK_NULL_POINTER_CHECK(_poServiceHandler);

	_poContainer = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));
	VD_CLOCK_NULL_POINTER_CHECK(_poContainer);
}

tVoid vd_clock_INCAdapter::vTraceInfo()
{

}

 tVoid vd_clock_INCAdapter::vHandleTraceMessage(const tUChar* puchData)
{
	 (tVoid)puchData;
}

tVoid vd_clock_INCAdapter::vCheckforCommunicationState(tU8 u8ReceivedConnectionState,tU8 u8ReceivedCommunicationState,tU8 u8ReceivedMuteState,tU8 u8ReceivedTroulbeCode)
{
	if(u8ReceivedConnectionState != _u8ConnectionState)
	{
		_u8ConnectionState = u8ReceivedConnectionState;
		_bConnectionStateChange = TRUE;
	}
	if(u8ReceivedCommunicationState != _u8CommunicationState)
	{
		_u8CommunicationState = u8ReceivedCommunicationState;
		_bConnectionStateChange = TRUE;
	}
	if(u8ReceivedMuteState != vd_clock_INCAdapter::_u8MuteState)
	{
		_u8MuteState = u8ReceivedMuteState;
		_bConnectionStateChange = TRUE;
	}

	if(u8ReceivedTroulbeCode !=_u8TroubleCode)
	{
		_u8TroubleCode = u8ReceivedTroulbeCode;
	}

}


