/*
 * ProfileManager.cpp
 *
 *  Created on: May 5, 2017
 *      Author: nln1kor
 */


#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_VD_CLOCK_CLIENT_PROFILE
#include "trcGenProj/Header/ProfileManager.cpp.trc.h"
#endif

#include "vd_clock_ClientProfileIf.h"
#include "vd_clock_AppMain.h"
#include "ProfileManager.h"
#include "vd_clock_types.h"
#include "../framework/app/vd_clock_AppMain_Trace.h"
#include "../framework/app/vd_clock_AppMain.h"
//#include "vd_clock_datacontainer.h"

#define MAXSIZE 7

profileManager::profileManager(vd_clock_tclAppMain* poMainAppl):vd_clock_tclBaseIf(poMainAppl)
{

	_pDataContainerIf = NULL;
	//u8activeProfile = 0;
	//readDefaultSettingsfromKDS();  			//Reads default values from KDS
	//storeDefaultSettingsinDatapool();		//Stores this default values for all the profiles
}

profileManager::~profileManager()
{

	_pDataContainerIf = NULL;
	//u8activeProfile = 0;
}

tVoid profileManager::vHandleMessage(vd_clock_tclBaseIf::TMsg* pMsg)
{
	(tVoid)pMsg;
}

tVoid profileManager::vStartCommunication()
{
	ETG_TRACE_USR4(("profileManager::vStartCommunication() is entered\n"));
}

tVoid profileManager::vGetReferences()
{
	_pDataContainerIf = dynamic_cast<vdclk_tclDataContainer*>(_cpoMain->getHandler("vdclk_tclDataContainer"));
	VD_CLOCK_NULL_POINTER_CHECK(_pDataContainerIf);

}

tVoid profileManager::vTraceInfo()
{

}

 tVoid profileManager::vHandleTraceMessage(const tUChar* puchData)
{
	 (tVoid)puchData;
	 //Handle Profilechange
	 //Handle
}


tVoid profileManager::HandleProfileChangeTrigger()
{
	ETG_TRACE_USR4(("profileManager::HandleProfileChangeTrigger() is entered\n"));
	//1: Call this fn:tVoid vdclk_tclDataContainer::vReadfromDatapool()
	//2: ->Call this fn tVoid  vdclk_tclDataContainer::vSetDefaultSettings	(tBool bResetAllUsers)
	if(_pDataContainerIf != NULL)
	{
		ETG_TRACE_USR4(("profileManager::HandleProfileChangeTrigger()->vReadfromDatapool() is called\n"));
		_pDataContainerIf->vReadfromDatapool();		  //Perform Datapool Read to get fresh values of new user.
		_pDataContainerIf->vSetDefaultSettings(TRUE); //Updates default/Current values to CCA Clients(HMI) .
	}
}
tVoid profileManager::HandlePrepareTrigger()
{
	ETG_TRACE_USR4(("profileManager::HandlePrepareTrigger() is entered\n"));
	//1: Call this fn : tVoid vdclk_tclDataContainer::vStoretoDatapool();
	if(_pDataContainerIf != NULL)
	{
		ETG_TRACE_USR4(("profileManager::HandleProfileChangeTrigger()->vStoretoDatapool() is called\n"));
		_pDataContainerIf->vStoretoDatapool();
	}

}
tVoid profileManager::HandleResetProfileTrigger()
{
	ETG_TRACE_USR4(("profileManager::HandleResetProfileTrigger() is entered\n"));
	//1: ->Call this fn tVoid  vdclk_tclDataContainer::vSetDefaultSettings	(tBool bResetAllUsers)
	if(_pDataContainerIf != NULL)
	{
		_pDataContainerIf->vFactoryReset();
	}
}

