/************************************************************************
* FILE:           vd_clock_ExtSourceListener.h
* PROJECT:        ALL
* SW-COMPONENT:   vd_clock
*----------------------------------------------------------------------
*
* DESCRIPTION:    Base-Class and dummy-implementation for CAN-Interface
*
*----------------------------------------------------------------------
* COPYRIGHT:      (c) 2007 Blaupunkt Werke GmbH, Hildesheim
*
* HISTORY:
* Date      | Author                | Modification
*----------------------------------------------------------------------
* 16.03.10  | Peter Hassmann        | initial version
************************************************************************/


#ifndef VD_CLOCK_EXTSOURCELISTENER_H_
#define VD_CLOCK_EXTSOURCELISTENER_H_

class vdclk_ExtSourceListener {
 public:
    virtual ~vdclk_ExtSourceListener(){};
    
    
    virtual tVoid vReadCSMDateTime(OSAL_trTimeDate&  rTD,
                           tU8& renChangeMask)
    {
        (tVoid)rTD;
        renChangeMask=0;
    };


    virtual tVoid vReadCSMFormat (//VDCLK_TEN_TimeFormat&  renTimeFormat,
                        //  VDCLK_TEN_DateFormat&  renDateFormat,
    		              tU32& u32TimeFormat,
    		              tU32& u32DateFormat,
                          tBool& rbFormatMasterAvailable)
    {
        //(tVoid)renTimeFormat;
        //(tVoid)renDateFormat;
    	(tVoid)u32TimeFormat;
    	(tVoid)u32DateFormat;
        rbFormatMasterAvailable = FALSE;;
    };

    virtual tVoid vWriteCSMTimeDate(OSAL_trTimeDate TD) {
        (tVoid)TD;
    };

    virtual tVoid vWriteCSMLocalTimeDate(vdclk_tclDateTime &oTD,tBool bLocalTimeAdjusted) {
        (tVoid)oTD;
        (tVoid)bLocalTimeAdjusted;
    }

    virtual tVoid vUpdateCANTime(OSAL_trTimeDate &tCanTimeDate, tBool bCANAvailable)
    {
    	(tVoid)tCanTimeDate;
    	(tVoid)bCANAvailable;
    }

    virtual tVoid vUpdateBAPTime(OSAL_trTimeDate &tBapTimeDate, tBool bBAPAvailable)
    {
    	(tVoid)tBapTimeDate;
    	(tVoid)bBAPAvailable;
    }

    virtual tVoid vGetCANTime(OSAL_trTimeDate &tCanTimeDate)
    {
    	(tVoid)tCanTimeDate;
    }

    virtual tVoid vGetBAPTime(OSAL_trTimeDate &tBapTimeDate)
    {
    	(tVoid)tBapTimeDate;
    }

    virtual tVoid vUpdateCANFormat(tU32 u32timeformat, tU32 u32dateformat)
    {
    	(tVoid)u32dateformat;
    	(tVoid)u32timeformat;
    }
    virtual tVoid vGetCANFormat(tU32 &u32timeformat, tU32 &u32dateformat)
    {
    	(tVoid)u32dateformat;
    	(tVoid)u32timeformat;
    }

};

#endif

