
#ifndef _ipod_Utf8StringComparator_
#define _ipod_Utf8StringComparator_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ipod_Utf8StringBase.h"

//lint -e1411 Warning 1411: prio2: Member with different signature hides virtual member 'tclUtf8StringBase::operator<(const ipod_tclUtf8StringBase &) const' (line 20, file X:\di_middleware_server\components\midw_common\utf8Sort\Utf8StringBase.h

class ipod_tclUtf8StringComparator : public ipod_tclUtf8StringBase
{
public:
   /********************************************************************
   *FUNCTION:     constructor of ipod_tclUtf8StringComparator
   *DESCRIPTION:
                  - creates an object that offers operators for utf8-string-compare
                  - no data copy happens so you need to ensure that the pointer is valid as long the tclUtf8StringComparator is used
   *PARAMETER:
                  - pointer to a string in utf8 or ascii format
                  - size of the string
   *RETURNVALUE:  an object of type tclUtf8StringComparator
   *******************************************************************/
   ipod_tclUtf8StringComparator(tPCU8 pu8String = OSAL_NULL, tU32 u32StringSize = 0) : ipod_tclUtf8StringBase(pu8String,u32StringSize) {};

   /********************************************************************
   *FUNCTION:     constructor of tclUtf8StringComparator
   *DESCRIPTION:  destroys the tclUtf8StringComparator object
   *PARAMETER:    none
   *RETURNVALUE:  none
   *******************************************************************/
   virtual ~ipod_tclUtf8StringComparator() {};

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE if the left one is lower, FLASE if the right one is lower
   *******************************************************************/
   virtual tBool operator<  ( const ipod_tclUtf8StringBase& oOtherString)  const
   {
      return  bThisIsLess(oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE if the right one is lower, FLASE if the left one is lower
   *******************************************************************/
   virtual tBool operator>  ( const ipod_tclUtf8StringBase& oOtherString)  const
   {
      return !bThisIsLess(oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE
   *******************************************************************/
   virtual tBool operator!= ( const ipod_tclUtf8StringBase& oOtherString)  const
   {
      return (*this<oOtherString) || (oOtherString<*this);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  FALSE
   *******************************************************************/
   virtual tBool operator== ( const ipod_tclUtf8StringBase& oOtherString) const
   {
      return bThisIsEqual(oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  FALSE
   *******************************************************************/
   virtual tBool operator>= ( const ipod_tclUtf8StringBase& oOtherString) const
   {
      return (*this > oOtherString)||((*this).operator ==(oOtherString));
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  FALSE
   *******************************************************************/
   virtual tBool operator<= ( const ipod_tclUtf8StringBase& oOtherString) const
   {
      return (*this < oOtherString)||((*this).operator == (oOtherString));
   };

   /********************************************************************
   *FUNCTION:     pcu8GetString
   *DESCRIPTION:  give read access pointer to data
   *PARAMETER:    none
   *RETURNVALUE:  pointer to the data
   *******************************************************************/
   virtual tPCU8 pcu8GetString() const
   {
      return ( (_pu8String != OSAL_NULL) ? _pu8String : (tPU8)"<EMPTY>" );
   };
};


//lint -restore



#endif //_ipod_Utf8StringComparator_
