
#ifndef _ipod_Utf8StringBase_
#define _ipod_Utf8StringBase_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

//lint -e1702 operator 'operator<' is both an ordinary function 'std::operator<(const std::pair<<1>,<2>> &, const std::pair<<1>,<2>> &)' and a member function 'tclUtf8StringBase::operator<(const tclUtf8StringBase &) const'
#define UTF_FOUR_BYTE_BOUNDARY 0xef
#define UTF_THREE_BYTE_BOUNDARY 0xdf
#define UTF_TWO_BYTE_BOUNDARY 0x7f
#define UTF_ARABIC_UPPER_BOUNDARY 0xdc
#define UTF_ARABIC_LOWER_BOUNDARY 0xd8

class ipod_tclUtf8StringBase
{
protected:

   static const tU32 cu32EndOfString  = 0xffffffff;

   tU32 u32GetNextUtf8Value();

   // Return the value corresponding to the number string
   virtual tU32  u32GetNumberValue() const
   {
      return _u32NumberValue;
   };

public:
   // Return True if the input string is less than the internal string
   virtual tBool operator<  ( const ipod_tclUtf8StringBase& oOtherString) const
   {
      return bThisIsLess(oOtherString);
   };
   // Return True if the input string is greater than the internal string
   virtual tBool operator>  ( const ipod_tclUtf8StringBase& oOtherString) const
   {
      return !(*this<oOtherString);
   };
   // Return True if the input string is not equal to the internal string
   virtual tBool operator!= ( const ipod_tclUtf8StringBase& oOtherString) const
   {
      return (this != &oOtherString);
   };
   // Return True if the input string is equal to the internal string
   virtual tBool operator== ( const ipod_tclUtf8StringBase& oOtherString) const
   {
      return (this == &oOtherString);
   };
   tVoid vReverseString(tPU8 pu8StringToBeReversed, tU32 u32StrLen)const;

   /********************************************************************
   *FUNCTION:     pcu8GetString
   *DESCRIPTION:  give read access pointer to data
   *PARAMETER:    none
   *RETURNVALUE:  pointer to the data
   *******************************************************************/
   virtual tPCU8 pcu8GetString() const
   {
      return ( (_pu8String != OSAL_NULL) ? _pu8String : (tPU8)"<EMPTY>" );
   };
protected:
   ipod_tclUtf8StringBase& operator=( const ipod_tclUtf8StringBase& roTheOther);

   ipod_tclUtf8StringBase( const ipod_tclUtf8StringBase& roTheOther);

   ipod_tclUtf8StringBase(tPCU8 pu8String = OSAL_NULL, tU32 u32StringSize = 0, tBool bAlloc = FALSE);
   virtual ~ipod_tclUtf8StringBase();

   static const tU32 cu32MaxUTF8Value        = 0xffff;
   static const tU32 cu32EmptyField          = 0;
   static const tU32 cu32ValidOffset         = 0x1000000;
   static const tU32 cu32BiggestOneByteChar  = 0x7f;
   static const tU32 cu32NumOfDigits         = 9;
   static const tU32 cu32InvalidNumberValue  = 0x3fffffff;
   static const tU32 cu32StringNumberValue   = 0x40000000;

   tBool bThisIsLess ( const ipod_tclUtf8StringBase& oOtherString) const;
   tBool bThisIsEqual ( const ipod_tclUtf8StringBase& oOtherString) const;

   // Return TRUE if the character is a number
   tBool bIsANumber(tU32 u32Char)  const
   {
      return ((u32Char >= '0') && (u32Char <= '9'));
   };
   tU8  u8GetUniqueChar(tU8 u8Char) const;
   tU32 u32ignSplWordAtBegin(tPCU8 pu8String, tU32 u32begIndex) const;
   tU32 u32ignSplCharAtBegin(tPCU8 pu8String, tU32 u32begIndex) const;

   tU32 u32GetUtf8Value(tU32& ru32OffSet, tBool& rbSZOnce) const;

   tU32 u32CalculateNumberValue();
   tU32 u32BinarySearch(tU32 u32Utf8Char)const;

   tU32 u32GetSortValue(tU32 u32Utf8Char) const;
   static tVoid vInitTable();
   static tVoid vSetValue(tU32 u32Pos, tU32 u32Value);
   static tU32  aru32SortValues[cu32MaxUTF8Value];
   static const tU32  u32NumOfEntries = 648;
   static const tU32  u32NumOfEntriesThai = 87;
   static const tU32  u32EntrySize    =  2;
   static const tU32 Table[u32NumOfEntries][u32EntrySize];
   static const tU32 TableThai[u32NumOfEntriesThai][u32EntrySize];

   static tBool bInit;
   tPCU8 _pu8String;
   tPU8  _pu8Data;
   tU32  _u32StringSize;
   tU32  _u32NumberValue;
   tU32  _u32Offset;
   tBool _bSZOnce;
   tBool _bAlloc;


};

//lint -restore




#endif //_ipod_Utf8StringBase_
