
#ifndef _ipod_Utf8String_
#define _ipod_Utf8String_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ipod_Utf8StringBase.h"

class ipod_tclUtf8String : public ipod_tclUtf8StringBase
{
public:
   /********************************************************************
   *FUNCTION:     constructor of ipod_tclUtf8String
   *DESCRIPTION:
                  - creates an object for managing utf8-strings
                  - the given string is copied into this object
   *PARAMETER:
                  - pointer to a string in utf8 or ascii format
                  - size of the string
   *RETURNVALUE:  an object of type tclUtf8String
   *******************************************************************/
   ipod_tclUtf8String(tPCU8 pu8String = OSAL_NULL, tU32 u32StringSize = 0 ) : ipod_tclUtf8StringBase(pu8String,u32StringSize,TRUE) {};
   /********************************************************************
   *FUNCTION:     constructor of tclUtf8String
   *DESCRIPTION:  destroys the tclUtf8String object
   *PARAMETER:    none
   *RETURNVALUE:  none
   *******************************************************************/
   virtual ~ipod_tclUtf8String() {};

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE if the left one is lower, FLASE if the right one is lower
   *******************************************************************/
   virtual tBool operator<  ( const ipod_tclUtf8StringBase& oOtherString)  const
   {
      return  bThisIsLess(oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE if the right one is lower, FLASE if the left one is lower
   *******************************************************************/
   virtual tBool operator>  ( const ipod_tclUtf8StringBase& oOtherString)  const
   {
      return !bThisIsLess(oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE
   *******************************************************************/
   virtual tBool operator!= ( const ipod_tclUtf8StringBase& oOtherString)  const
   {
      return (this != &oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  FALSE
   *******************************************************************/
   virtual tBool operator== ( const ipod_tclUtf8StringBase& oOtherString) const
   {
      return (this == &oOtherString);
   };

   /********************************************************************
   *FUNCTION:     pcu8GetString
   *DESCRIPTION:  give read access pointer to data
   *PARAMETER:    none
   *RETURNVALUE:  pointer to the data
   *******************************************************************/
   virtual tPCU8 pcu8GetString() const
   {
      return ( (_pu8String != OSAL_NULL) ? _pu8String : (tPU8)"<EMPTY>" );
   };
};






#endif //_Utf8StringBase_
