
#ifndef _Utf8StringGroup_
#define _Utf8StringGroup_

#include "Utf8StringGroupsTable.h"

class tclUtf8StringGroup
{
public:
   enum TableType
   {
      enTableRussain,
      enTableLatin,
      enTableGreek,
      enTableArabic,
      enTableThai,
      enTableChinese,
      enTableKorean,
      enTableRussain_ipod,
      enTableLatin_ipod,
      enTableGreek_ipod,
      enTableArabic_ipod,
      enTableThai_ipod,
      enTableChinese_ipod,
      enTableKorean_ipod
   };

   /********************************************************************
   *FUNCTION:     constructor of tclUtf8StringGroup
   *DESCRIPTION:  Create a group table
   *PARAMETER:    TableType type - chooses a context specific table
   *RETURNVALUE:  none
   *******************************************************************/
   tclUtf8StringGroup(TableType type);

   /********************************************************************
   *FUNCTION:     operator[]
   *DESCRIPTION:  returns the utf8 character to the given table position
   *PARAMETER:    index
   *RETURNVALUE:  string - one utf8 character
   *******************************************************************/
   const unsigned char* operator[](int pos);

   /********************************************************************
   *FUNCTION:     s32GetMaxEntries
   *DESCRIPTION:  returns the number of utf8 character in the group table
   *PARAMETER:    none
   *RETURNVALUE:  int - number of table entries
   *******************************************************************/
   virtual int s32GetMaxEntries();

   /********************************************************************
   *FUNCTION:     s32GetMaxEntrySize
   *DESCRIPTION:  returns length of the longest utf8 character in the group table ( in bytes )
   *PARAMETER:    none
   *RETURNVALUE:  int -  length of the longest utf8 character
   *******************************************************************/
   virtual int s32GetMaxEntrySize();

   /********************************************************************
   *FUNCTION:     s32GetBaseIndex
   *DESCRIPTION:  returns the position of the group table where the given utf8 character is mapped to
   *PARAMETER:    some utf8 string
   *RETURNVALUE:  int -  position in the group table which contain a utf8 character that is less or equal to the given one
   *******************************************************************/
   int s32GetBaseIndex(const unsigned char* request);

   /********************************************************************
   *FUNCTION:     bIPODSort
   *DESCRIPTION:  returns true if IPOD specific sort is to be used
   *PARAMETER:    none
   *RETURNVALUE:  bool - true if IPOD specific sort is to be used
   *******************************************************************/
   bool bIPODSort();

protected:
   /********************************************************************
   *FUNCTION:     !protected! tclUtf8StringGroup
   *DESCRIPTION:  default constructor should not be used, use constructor with parameter instead
   *PARAMETER:    none
   *RETURNVALUE:  none
   *******************************************************************/
   tclUtf8StringGroup() :poData(0) {}

   /********************************************************************
   *MEMBER:      !protected! poData
   *DESCRIPTION:  pointer to a group table
   *PARAMETER:    none
   *RETURNVALUE:  none
   *******************************************************************/
   tclUtf8StringGroupTable* poData;
};




#endif //_Utf8StringGroup_
