
#ifndef _Utf8StringComparator_
#define _Utf8StringComparator_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h" //lint !e451 !e537
// Warning 451: Header file '...' repeatedly included but does not have a standard include guard
// Warning 537: Repeated include file '...'

#include "Utf8StringBase.h" //lint !e537 Warning 537: Repeated include file '...'

//lint -e1411 Warning 1411: prio2: Member with different signature hides virtual member 'tclUtf8StringBase::operator<(const tclUtf8StringBase &) const' (line 20, file X:\di_middleware_server\components\midw_common\utf8Sort\Utf8StringBase.h

class tclUtf8StringComparator : public tclUtf8StringBase
{
public:
   /********************************************************************
   *FUNCTION:     constructor of tclUtf8StringComparator
   *DESCRIPTION:
                  - creates an object that offers operators for utf8-string-compare
                  - no data copy happens so you need to ensure that the pointer is valid as long the tclUtf8StringComparator is used
   *PARAMETER:
                  - pointer to a string in utf8 format
                  - size of the string
   *RETURNVALUE:  an object of type tclUtf8StringComparator
   *******************************************************************/
   tclUtf8StringComparator(tPCU8 pu8String = OSAL_NULL, tU32 u32StringSize = 0) : tclUtf8StringBase(pu8String,u32StringSize)
   {
      sort_language = tclUtf8StringBase::currentSortLanguage;
   };

   /********************************************************************
   *FUNCTION:     constructor of tclUtf8StringComparator
   *DESCRIPTION:  destroys the tclUtf8StringComparator object
   *PARAMETER:    none
   *RETURNVALUE:  none
   *******************************************************************/
   virtual ~tclUtf8StringComparator() {};

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE if the left one is lower, FLASE if the right one is lower
   *******************************************************************/
   virtual tBool operator<  ( const tclUtf8StringBase& oOtherString)  const
   {
      return  bThisIsLess(oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE if the right one is lower, FLASE if the left one is lower
   *******************************************************************/
   virtual tBool operator>  ( const tclUtf8StringComparator& oOtherString)  const
   {
      return oOtherString < *this;
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE
   *******************************************************************/
   virtual tBool operator!= ( const tclUtf8StringComparator& oOtherString)  const
   {
      return (*this<oOtherString) || (*this>oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  FALSE
   *******************************************************************/
   virtual tBool operator== ( const tclUtf8StringComparator& oOtherString) const
   {
      return !(*this != oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  FALSE
   *******************************************************************/
   virtual tBool operator>= ( const tclUtf8StringComparator& oOtherString) const
   {
      return !(*this < oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  FALSE
   *******************************************************************/
   virtual tBool operator<= ( const tclUtf8StringComparator& oOtherString) const
   {
      return !(*this > oOtherString);
   };

   /********************************************************************
   *FUNCTION:     pcu8GetString
   *DESCRIPTION:  give read access pointer to data
   *PARAMETER:    none
   *RETURNVALUE:  pointer to the data
   *******************************************************************/
   virtual tPCU8 pcu8GetString() const
   {
      return ( (_pu8String != OSAL_NULL) ? _pu8String : (tPCU8)"<EMPTY>" );
   };

   /********************************************************************
   *FUNCTION:     get_sort_language
   *DESCRIPTION:  return the sorting language to use for THIS sort
   *PARAMETER:    none
   *RETURNVALUE:  enum tenUtf8SortLanguage - sorting language
   *******************************************************************/
   virtual tenUtf8SortLanguage get_sort_language() const
   {
      return sort_language;
   };

private:

   tenUtf8SortLanguage sort_language;
};


//lint -restore



#endif //_Utf8StringComparator_
