
#ifndef _Utf8String_
#define _Utf8String_

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h" //lint !e451 !e537
// Warning 451: Header file '...' repeatedly included but does not have a standard include guard
// Warning 537: Repeated include file '...'

#include "Utf8StringBase.h" //lint !e537 Warning 537: Repeated include file '...'

class tclUtf8String : public tclUtf8StringBase
{
public:
   /********************************************************************
   *FUNCTION:     constructor of tclUtf8String
   *DESCRIPTION:
                  - creates an object for managing utf8-strings
                  - the given string is copied into this object
   *PARAMETER:
                  - pointer to a string in utf8 or ascii format
                  - size of the string
   *RETURNVALUE:  an object of type tclUtf8String
   *******************************************************************/
   tclUtf8String(tPCU8 pu8String = OSAL_NULL, tU32 u32StringSize = 0 ) : tclUtf8StringBase(pu8String,u32StringSize,TRUE) {};
   /********************************************************************
   *FUNCTION:     constructor of tclUtf8String
   *DESCRIPTION:  destroys the tclUtf8String object
   *PARAMETER:    none
   *RETURNVALUE:  none
   *******************************************************************/
   virtual ~tclUtf8String() {};

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE if the left one is lower, FLASE if the right one is lower
   *******************************************************************/
   virtual tBool operator<  ( const tclUtf8StringBase& oOtherString)  const
   {
      return  bThisIsLess(oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE if the right one is lower, FLASE if the left one is lower
   *******************************************************************/
   virtual tBool operator>  ( const tclUtf8StringBase& oOtherString)  const
   {
      return !bThisIsLess(oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  TRUE
   *******************************************************************/
   virtual tBool operator!= ( const tclUtf8StringBase& oOtherString)  const
   {
      return (this != &oOtherString);
   };

   /********************************************************************
   *FUNCTION:     compare operator
   *DESCRIPTION:  compare an object with another
   *PARAMETER:    the other object
   *RETURNVALUE:  FALSE
   *******************************************************************/
   virtual tBool operator== ( const tclUtf8StringBase& oOtherString) const
   {
      return (this == &oOtherString);
   };

   /********************************************************************
   *FUNCTION:     pcu8GetString
   *DESCRIPTION:  give read access pointer to data
   *PARAMETER:    none
   *RETURNVALUE:  pointer to the data
   *******************************************************************/
   virtual tPCU8 pcu8GetString() const
   {
      return ( (_pu8String != OSAL_NULL) ? _pu8String : (tPCU8)"<EMPTY>" );
   };
};






#endif //_Utf8StringBase_
