/************************************************************************
* FILE:         midw_common_trace.h
* PROJECT:      VW_LL_NF
* SW-COMPONENT: DemoServer
*----------------------------------------------------------------------
*
* DESCRIPTION: handle trace outputs efficiently
* This class is used as template for all middleware server to provide
* trace output in an efficient way.
*
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2007 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author                   | Modification
*************************************************************************/
#ifndef MIDW_COMMON_TCLTRACE_H
#define MIDW_COMMON_TCLTRACE_H

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "midw_common_trace_macros.h"

class midw_common_tclTraceInput; // interface for receiving TTFis inputs
/*----------------------------------- trace channel comunication-------------------*/
class midw_common_tclTraceChannel
{
public:
   midw_common_tclTraceChannel(tVoid);
   virtual ~midw_common_tclTraceChannel(tVoid);

   // Receive the data
   static tVoid vTrace_Rx(tPCUChar pcu8Data);

   // at runtime application adds intefaces to the call back interface
   tVoid vRegisterTraceService(midw_common_tenTrcClassName uInputNum, midw_common_tclTraceInput* pclInput);

   // at runtime application activates the trace channel with the right id
   tVoid vRegisterTraceCallBack(TR_tenTraceChan eChan );

   // when closing the applicaiton call back and trace channel are closed with it
   tVoid vUnregisterTraceCallBack(tVoid);

private:
   // channel number is stored to be able to close without second time transmitting
   // the parameter
   TR_tenTraceChan _eChannel;

   // the channel is reentrant however the second instance will have to close
   // the first channel because we have foreseen only one.
   static OSAL_tIODescriptor _fdTrace;

   // trace input interface list
   // used to switch into the different services, clienthandler or main class
   // number is fixed because we know where we want to use it
   static midw_common_tclTraceInput* _paReceiver[midw_common_maxClassNames];

}; // class trace channel


#endif // MIDW_COMMON_TCLTRACE_H


