/*
 * TxSinkItf.h
 *
 *  Created on: 14.10.2014
 *      Author: MOR2HI
 */

#ifndef TXSINKITF_H_
#define TXSINKITF_H_
/**
 * MCANIF need these interfaces for sending data to the sink (whatever the sink is)
 */
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#define MIDW_COMMON_S_IMPORT_INTERFACE_CSM
#include "midw_common_if.h"
typedef unsigned char    BYTE;
typedef unsigned short   WORD;

// ToDo: replace the following defines with something
//#define CSM_C_CONNECTED       0x01   /**< Generic "CONNNECTED" state          */
//#define CSM_C_DISCONNECTED    0x02   /**< Generic "DISCONNECTED" state        */
#define CSM_C_NO_ERROR                       0L
#define CSM_C_CONF_OK             0x00
//#define CSM_C_PTYPE_RN_MPDT_C           ((DWORD) _MPDT_C____)
#define CSM_C_CONNECT CSM_C_CONNECTED


#define CSM_M_GET_HIBYTE(w)  ( (BYTE) (((WORD)(w) >> 8) & 0xFF) )  /* for signed values not all systems add 0-Bits */
#define CSM_M_GET_LOBYTE(w)  ( (BYTE) (((WORD)(w)) &  0xFF) )
#define CSM_M_GET_HIWORD(dw) ( (WORD) (((DWORD)(dw) >> 16) & 0xFFFF))  /* for signed values not all systems add 0-Bits */
#define CSM_M_GET_LOWORD(dw) ( (WORD) (((DWORD)(dw)) &  0xFFFF) )


#define TX_SINK_CONNECTED CSM_C_CONNECTED
#define TX_SINK_CONNECT CSM_C_CONNECT
#define TX_SINK_DISCONNECTED CSM_C_DISCONNECTED
#define TX_SINK_NO_ERROR CSM_C_NO_ERROR
#define TX_SINK_CONF_OK CSM_C_CONF_OK

#define TX_SINK_PTYPE 0x00 //CSM_C_PTYPE_RN_MPDT_C // ToDo: remove once csm is eliminated completly /** Jayashree:commented as it is aivi-relavant **/
#define TX_SINK_BUS_MCAN CSM_C_CAN_BUS_MCAN
#define TX_SINK_PTYPE_RN_MPDT_C 0x00 //CSM_C_PTYPE_RN_MPDT_C /** Jayashree:commented as it is aivi-relavant **/
#define TX_SINK_APPL_ID_DEFAULT CSM_C_APPL_ID_DEFAULT

#define TX_SINK_GET_HIBYTE(w) CSM_M_GET_HIBYTE(w)
#define TX_SINK_GET_LOBYTE(w) CSM_M_GET_LOBYTE(w)
#define TX_SINK_GET_HIWORD(dw) CSM_M_GET_HIWORD(dw)
#define TX_SINK_GET_LOWORD(dw) CSM_M_GET_LOWORD(dw)

#define TX_SINK_OPTYPE_SEND_SET 0x00 // This operation type must be used for messages sent to the V850

#define TX_SINK_OPTYPE_RECEIVED_STATUS 0x0C // This operation type must be used for messages received from the V850. Message is a status
#define TX_SINK_OPTYPE_RECEIVED_INDICATION 0x0D // This operation type must be used for messages received from the V850. Message is a indication.


class TxSinkItf
{
public:
   virtual ~TxSinkItf(){

   }
   virtual tVoid vSendSpeedLimit( tU8 _u8SpeedLimitValue )=0;
   virtual tS32 DataReq(void *pvHandle, tU32 dwProtocolType, const void *pvAddressField, const tU8 *pbData, tU16 wDataLength)=0;
   virtual tS32 ApplCallbackInit(void *pvHandle, tU32 dwProtocolType, void *pvAddressField, void *pvCallBackFkt)=0;
   virtual tS32 CommunicationReq(void *pvHandle, tU8 bBus, tU32 dwProtocolType, const void *pvAddressField, tU8 bAction, tU16 wApplID)=0;
};

#endif /* TXSINKITF_H_ */
