///////////////////////////////////////////////////////////
//  HistoryContainer.h
//  Implementation of the Class HistoryContainer
//  Created on:      12-Sep-2015 13:21:48
//  Original author: MOR2HI
///////////////////////////////////////////////////////////

#if !defined(EA_8A3C0295_D4EF_41a7_B01F_43F9F0CFBD74__INCLUDED_)
#define EA_8A3C0295_D4EF_41a7_B01F_43F9F0CFBD74__INCLUDED_
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#include "ConnectionConfiguratorCallbackInterface.h"
/**
 * This class maintain the history. The variable for the history is stored external and can be accessed from here by the
 * reference which is given along with object initialization.
 */
class HistoryContainer
{

public:
   ConnectionConfiguratorCallbackInterface* _pCallbackInterface;

	HistoryContainer();
	HistoryContainer(ConnectionConfiguratorCallbackInterface* pCallbackInterface);
	virtual ~HistoryContainer();


	/**
	 * history clear means, that the history is been reseted.
	 */
	tVoid clearHistory();
	/**
	 * history set means, that the MCAN channel connection was successful. Now it's been expected to get connected on next startup.
	 */
	tVoid setHistory();
	tVoid setHistory (tBool History);
	tVoid storeHistoryPeristant ();
	tBool isHistorySet();
	/**
	 * set whether history comes into picture or now. It's been granted in case vehicle information availability type is set.
	 * @param granted: use history
	 */
	tVoid grantHistory(tBool granted);
	tBool isHistoryGranted();

private:
	tBool _History;
	tBool _Granted;

};
#endif // !defined(EA_8A3C0295_D4EF_41a7_B01F_43F9F0CFBD74__INCLUDED_)
