///////////////////////////////////////////////////////////
//  HistoryContainer.cpp
//  Implementation of the Class HistoryContainer
//  Created on:      12-Sep-2015 13:21:48
//  Original author: MOR2HI
///////////////////////////////////////////////////////////
#include "../../midw_common_trace.h"

#include "HistoryContainer.h"

//For ETG tracing
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_MIDW_COMMON_AUTO_CONFIGURATION
#include "trcGenProj/Header/HistoryContainer.cpp.trc.h"
#endif

HistoryContainer::HistoryContainer (ConnectionConfiguratorCallbackInterface* pCallbackInterface): _Granted(FALSE), _History(FALSE)
{
   if (NULL != pCallbackInterface)
   {
      _pCallbackInterface = pCallbackInterface;
   }
}

HistoryContainer::HistoryContainer ( ):_pCallbackInterface(NULL), _Granted(FALSE), _History(FALSE)
{

}

HistoryContainer::~HistoryContainer ( )
{

}

/**
 * Clear the history variable. This is done when the configuration need to be cleared.
 */
tVoid HistoryContainer::clearHistory ( )
{
   ETG_TRACE_USR4(("ConnectionConfigurator::clearHistory: enter"));
   _History = FALSE;
   storeHistoryPeristant();
}

/**
 * Set the history variable. This means the channel was connected successfully. This is done for auto configuration only.
 */
tVoid HistoryContainer::setHistory ( )
{
   ETG_TRACE_USR4(("ConnectionConfigurator::setHistory: enter"));
   _History = TRUE;
   storeHistoryPeristant();
}

tVoid HistoryContainer::setHistory (tBool History)
{
   if (TRUE == History)
   {
      setHistory();
   }
   else
   {
      clearHistory();
   }
}


tVoid HistoryContainer::storeHistoryPeristant ()
{
   ETG_TRACE_USR4(("ConnectionConfigurator::storeHistoryPeristant: enter"));
   if (NULL != _pCallbackInterface)
   {
      _pCallbackInterface->CallbackForStoringHistoryPersistant(_History);
   }
   else
   {
      FATAL_M_ASSERT_ALWAYS();
   }
}

/**
 * Read the variable which maintain the history.
 * @return
 */
tBool HistoryContainer::isHistorySet ( )
{
   return (_History);
}
/**
 * the history don't come into picture in any case, true means history is for interest. It must be granted from extern.
 * True means it's granted.
 */
tVoid HistoryContainer::grantHistory ( tBool granted )
{
   ETG_TRACE_USR4(("ConnectionConfigurator::grantHistory: enter: grant history: %d", granted));
   _Granted = granted;
}

/**
 * Check whether history was set before. This means, that the client is interested in history.
 */
tBool HistoryContainer::isHistoryGranted ( )
{
   ETG_TRACE_USR4(("ConnectionConfigurator::isHistoryGranted: %d", _Granted));
   return (_Granted);
}
