/**
 * code_converter.h
 *
 * Contains function definitions for conversion of GB18030 encoded characters to Unicode
 *
 * Note - Current implementation does not support all possible GB18030 codes.
 *
 * component: midw_common\CodeConversion
 *
 * author: Ian Lisney
 *
 ***********************************************************************/

#ifndef __CODECONVERTER_H__
#define __CODECONVERTER_H__

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h" /*lint !e451 !e537 */
/* Warning 451: Header file '...' repeatedly included but does not have a standard include guard */
/* Warning 537: Repeated include file '...' */

#include "language_converter.h" /*lint !e537 */ /* Warning 537: Repeated include file '...' */

/***********************************************************************
 * Converts an array of character codes to an array of unicode
 * character codes.
 * The output array must have the same or greater size than the input array.
 *
 * in  tU32* const*        startCodes    pointer to start of gb18030 chars
 * in  const tU32*         endCodes      pointer to end of gb18030 chars
 * in  tU32* const*        startUnicode  pointer to start of unicode codes
 * in  const tU32*         endUnicode    pointer to end of unicode codes
 * in  tenCodeConvMapping  language      current language
 * out tU32                              number of Unicode codes written
 ***********************************************************************/
tU32 ConvertCodestoUnicode(tU32* const*       startCodes,
                           const tU32*        endCodes,
                           tU32* const*       startUnicode,
                           const tU32*        endUnicode,
                           tenCodeConvMapping language);

/***********************************************************************
 * Converts an array of Unicode character codes to a UTF8 coded string
 *
 * in  tU32* const*  start_unicode_array   pointer to start of unicode codes
 * in  const tU32*   end_unicode_array     pointer to end of unicode codes
 * in  tU8* const*   start_utf8_array      pointer to start of unicode codes
 * in  const tU8*    end_utf8_array        pointer to end of unicode codes
 * out tU32                                number of UTF8 charas written
 ***********************************************************************/
tU32 ConvertUnicodetoUTF8(tU32* const*  start_unicode_array,
                          const tU32*   end_unicode_array,
                          tU8* const*   start_utf8_array,
                          const tU8*    end_utf8_array);

/***********************************************************************
 * Converts an input string to language codes and returns the
 * count of valid codes found.
 *
 * in  tU32*               codes            pointer to output array
 * in  tU32                max_size_output  maximum length of output array
 * in  const tU8*          input_string     input_string
 * in  tU32                string_length    number of characters
 * in  tenCodeConvMapping  language         current language
 * out tS32                                 count of valid codes
 *                                          otherwise -1 if conversion fails
 ***********************************************************************/
tS32 ConvertStringtoLanguageCodes(tU32*               codes,
                                  tU32               max_size_output,
                                  const tU8*         input_string,
                                  tU32               string_length,
                                  tenCodeConvMapping language);

#endif /* __CODECONVERTER_H__ */
