/**********************************************************************
 * CharMapVar.c
 *
 * Converts language to character conversion mapping
 *
 * Component: midw_common\CodeConversion
 *
 * Author: Ian Lisney
 *
 ***********************************************************************/

/***********************************************************************
 * Include Files
 ***********************************************************************/

#include "language_converter.h"
#include "code_converter.h"
#include "CharMapVar.h"

/***********************************************************************
 * Converts current language to character mapping
 *
 * in  tenCodeConvMapping  language  current language
 * out int                           language mapping
 ***********************************************************************/
MapIdEnum CharMap_getLanguageMapping (tenCodeConvMapping language)
{

   /* Check for and handle each language type */
   switch (language)
   {
   case CODECONV_NO_CHANGE:

   /* Latin Alphabet No.1 */
   case CODECONV_WINDOWS_CODEPAGE_28591:
   case CODECONV_ISO8859_01:
      return MAP_ISO_8859_01_V1_TO_UNICODE;

   /* Central European */
   case CODECONV_WINDOWS_CODEPAGE_28592:
   case CODECONV_ISO8859_02:
      return MAP_ISO_8859_02_V1_TO_UNICODE;

   /* South European */
   case CODECONV_WINDOWS_CODEPAGE_28593:
   case CODECONV_ISO8859_03:
      return MAP_ISO_8859_03_V1_TO_UNICODE;

   /*North European */
   case CODECONV_WINDOWS_CODEPAGE_28594:
   case CODECONV_ISO8859_04:
      return MAP_ISO_8859_04_V1_TO_UNICODE;

   /* Cyrillic */
   case CODECONV_WINDOWS_CODEPAGE_28595:
   case CODECONV_ISO8859_05:
      return MAP_ISO_8859_05_V2_TO_UNICODE;

   /* Arabic */
   case CODECONV_WINDOWS_CODEPAGE_28596:
   case CODECONV_ISO8859_06:
      return MAP_ISO_8859_06_V1_TO_UNICODE;

   /* Greek */
   case CODECONV_WINDOWS_CODEPAGE_28597:
   case CODECONV_ISO8859_07:
      return MAP_ISO_8859_07_V1_TO_UNICODE;

   /* Hebrew */
   case CODECONV_WINDOWS_CODEPAGE_28598:
   case CODECONV_ISO8859_08:
      return MAP_ISO_8859_08_V1_TO_UNICODE;

   /* Turkish */
   case CODECONV_WINDOWS_CODEPAGE_28599:
   case CODECONV_ISO8859_09:
      return MAP_ISO_8859_09_V1_TO_UNICODE;

   /* Nordic */
   case CODECONV_WINDOWS_CODEPAGE_28600:
   case CODECONV_ISO8859_10:
      return MAP_ISO_8859_10_V1_TO_UNICODE;

   /* Thai */
   case CODECONV_WINDOWS_CODEPAGE_28601:
   case CODECONV_ISO8859_11:
      return MAP_ISO_8859_11_V1_TO_UNICODE;

   /* Devangari */
   case CODECONV_WINDOWS_CODEPAGE_28602:
   case CODECONV_ISO8859_12:
      return MAP_ISO_8859_12_V1_TO_UNICODE;

   /* Baltic Rim */
   case CODECONV_WINDOWS_CODEPAGE_28603:
   case CODECONV_ISO8859_13:
      return MAP_ISO_8859_13_V1_TO_UNICODE;

   /* Celtic */
   case CODECONV_WINDOWS_CODEPAGE_28604:
   case CODECONV_ISO8859_14:
      return MAP_ISO_8859_14_V1_TO_UNICODE;

   /* Latin - 9 */
   case CODECONV_WINDOWS_CODEPAGE_28605:
   case CODECONV_ISO8859_15:
      return MAP_ISO_8859_15_V1_TO_UNICODE;

   /* South Eastern European */
   case CODECONV_WINDOWS_CODEPAGE_28606:
   case CODECONV_ISO8859_16:
      return MAP_ISO_8859_16_V1_TO_UNICODE;

   /* Chinese Unicode 1.1 */
   case CODECONV_CHINESE_UNICODE_1_1:
      return MAP_CHINESE_UNICODE_1_1_V1_TO_UNICODE;

   /* Windows Code Pages */

   /* Thai */
   case CODECONV_WINDOWS_CODEPAGE_874:
      return MAP_WCP_874_V1_TO_UNICODE;

   /* Japanese Shift-JIS */
   case CODECONV_WINDOWS_CODEPAGE_932:
      return MAP_WCP_932_V1_TO_UNICODE;

   /* Simplified Chinese GBK */
   case CODECONV_WINDOWS_CODEPAGE_936:
      return MAP_WCP_936_V1_TO_UNICODE;

   /* Korean */
   case CODECONV_WINDOWS_CODEPAGE_949:
      return MAP_WCP_949_V1_TO_UNICODE;

   /* Traditional Chinese Big 5 */
   case CODECONV_WINDOWS_CODEPAGE_950:
      return MAP_WCP_950_V1_TO_UNICODE;

   /* Traditional Chinese Big 5 Extensions*/
   case CODECONV_WINDOWS_CODEPAGE_951:
      return MAP_WCP_951_V1_TO_UNICODE;

   /* Central European */
   case CODECONV_WINDOWS_CODEPAGE_1250:
      return MAP_WCP_1250_V1_TO_UNICODE;

   /* Cyrillic */
   case CODECONV_WINDOWS_CODEPAGE_1251:
      return MAP_WCP_1251_V1_TO_UNICODE;

   /* Latin 1 */
   case CODECONV_WINDOWS_CODEPAGE_1252:
      return MAP_WCP_1252_V1_TO_UNICODE;

   /* Latin / Greek */
   case CODECONV_WINDOWS_CODEPAGE_1253:
      return MAP_WCP_1253_V1_TO_UNICODE;

   /* Latin 5 / Turkish */
   case CODECONV_WINDOWS_CODEPAGE_1254:
      return MAP_WCP_1254_V1_TO_UNICODE;

   /* Latin / Hebrew */
   case CODECONV_WINDOWS_CODEPAGE_1255:
      return MAP_WCP_1255_V1_TO_UNICODE;

   /* Latin / Arabic */
   case CODECONV_WINDOWS_CODEPAGE_1256:
      return MAP_WCP_1256_V1_TO_UNICODE;

   /* Latin 7 / Baltic Rim */
   case CODECONV_WINDOWS_CODEPAGE_1257:
      return MAP_WCP_1257_V1_TO_UNICODE;

   /* Vietnam */
   case CODECONV_WINDOWS_CODEPAGE_1258:
      return MAP_WCP_1258_V1_TO_UNICODE;

   case CODECONV_LAST:
   {
      FATAL_M_ASSERT_ALWAYS();
      break;
   }
   default:
   {
      FATAL_M_ASSERT_ALWAYS();
      break;
   }
   }
   return MAP_ISO_8859_01_V1_TO_UNICODE; /* Won't get here - keeping lint happy */
}
