#include "CSMInterfaceSh.h"

#ifdef VARIANT_S_FTR_ENABLE_FEAT_SET_MIDW_COMMON_VAG
   #define CSM_TRACE_CLASS_OFFSET 0x0a
#endif

#ifndef CSM_C_PROC_MESSAGE_QUEUE_NAME
#define CSM_C_PROC_MESSAGE_QUEUE_NAME         "PROC_CSM_MSG_QUEUE"
#endif

tS32 CSMInterface::CSM_s32WaitForCAN(tU32 u32Timeout) {

    tS32 s32Ret       = -1;
    tU32 u32StartTime = OSAL_ClockGetElapsedTime();
    tU32 u32StopTime  = u32StartTime + u32Timeout;

    OSAL_tMQueueHandle _hProcMessageQueueID = OSAL_C_INVALID_HANDLE;
    tS32 s32QueueState = OSAL_s32MessageQueueOpen( CSM_C_PROC_MESSAGE_QUEUE_NAME, OSAL_EN_READWRITE, &_hProcMessageQueueID );
    while ((s32QueueState != OSAL_OK) && (u32StopTime > OSAL_ClockGetElapsedTime())) {
        OSAL_s32ThreadWait(50);
        s32QueueState = OSAL_s32MessageQueueOpen( CSM_C_PROC_MESSAGE_QUEUE_NAME, OSAL_EN_READWRITE, &_hProcMessageQueueID );
    }

    if (s32QueueState == OSAL_OK) {
        OSAL_s32MessageQueueClose( _hProcMessageQueueID );
        s32Ret = OSAL_ClockGetElapsedTime() - u32StartTime;
    }
    return s32Ret;
}

CSMInterface::CSMInterface()
{
   bIsBCThreadRunning = FALSE;

   poCsmAccessUser = OSAL_NEW csm_tclCsmAccessUser();

   if ( poCsmAccessUser )
   {
      poCsmAccessUser->vApplCallbackPreInit(0);
   }
}

CSMInterface::CSMInterface(tU32 u32MsgQueueCount)
{
   bIsBCThreadRunning = FALSE;

   poCsmAccessUser = OSAL_NEW csm_tclCsmAccessUser();

   if ( poCsmAccessUser )
   {
      poCsmAccessUser->vApplCallbackPreInit(u32MsgQueueCount);
   }
}


CSMInterface::~CSMInterface()
{
}


tS32 CSMInterface::CSM_s32Init(CSMThreadConfig *pMyConfig)
{
   tS32 s32RetVal = 0;

   (void) pMyConfig;

   return s32RetVal;
}

// the only valid signature from CSM_ACCESS_USR (CSM proxy system) for the application registration is:
// tS32 csm_tclCsmAccessUser::s32ApplCallbackInit(tU8 u8Bus, tU32 u32ProtocolType, const tVoid* pcvAddressField, const tVoid* pcvCallBackFkt)
// this is an adapter function:
tS32 CSMInterface::CSM_lApplCallbackInit(tU8 u8Bus, tU32 dwProtocolType, void *pvAddressField, void *pvCallBackFkt)
{
  tS32 s32RetVal = -1;

  if (poCsmAccessUser)
  {
    s32RetVal = poCsmAccessUser->s32ApplCallbackInit(u8Bus, dwProtocolType, pvAddressField, pvCallBackFkt);
  }
  return s32RetVal;
}

// the only valid signature from CSM (CSM native system) for the application registration is:
// CSM_API LONG CSM_lApplCallbackInit(void * pvHandle, BYTE bBus, DWORD dwProtocolType, const void * pvAddressField, const void * pvCallBackFkt)
// this is an adapter function:
tS32 CSMInterface::CSM_lApplCallbackInit(void *pvHandle, tU8 u8Bus, tU32 dwProtocolType, void *pvAddressField, void *pvCallBackFkt)
{
  tS32 s32RetVal = -1;
  (void) pvHandle;

  if ( poCsmAccessUser )
  {
    s32RetVal = poCsmAccessUser->s32ApplCallbackInit(u8Bus, dwProtocolType, pvAddressField, pvCallBackFkt);
  }
  return s32RetVal;
}

// this is an adapter function for usage of MCAN applications ONLY !!!
tS32 CSMInterface::CSM_lApplCallbackInit(void *pvHandle, tU32 dwProtocolType, void *pvAddressField, void *pvCallBackFkt)
{
  // if this variant of the ApplCallbackInit is used, we have to check the given protocol type in order
  // to map the call for csm_access_user with a sensible bus parameter !!! 
  tS32 s32RetVal = -1;
  (void) pvHandle;
  tU8 u8Bus = 0;
    
  if (/*(dwProtocolType == CSM_C_PTYPE_RN_MPDT_C) || (dwProtocolType == CSM_C_PTYPE_RN_MPDT_D)*/0x00)/** Jayashree:commented as it is aivi-relavant **/
  {
    // MPDT protocol: bus nr is MCAN !!!
    u8Bus = CSM_C_CAN_BUS_MCAN;    
  } 
  else   
  {
    // all other cases: keep the bus nr. 0 as in the previous version of this function (0 is VCAN) 
    u8Bus = CSM_C_CAN_BUS_VCAN;      
  }
 
  if (poCsmAccessUser)
  {
    s32RetVal = poCsmAccessUser->s32ApplCallbackInit(u8Bus, dwProtocolType, pvAddressField, pvCallBackFkt);
  }
  return s32RetVal;
}

tS32 CSMInterface::CSM_lApplCallbackDeInit( void *pvHandle )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32ApplCallbackDeInit();
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lSignalCallbackInit( void *pvHandle,
                                            tU32 dwSignalId,
                                            SIGNAL_IND_TYPE vPFNCBRSignalInd )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
       s32RetVal = poCsmAccessUser->s32SignalCallbackInit( dwSignalId, vPFNCBRSignalInd );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lSignalCallbackDeInit( void *pvHandle,
                                              tU32 dwSignalId )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32SignalCallbackDeInit( dwSignalId );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lSignalCallbackDeInitAll( void *pvHandle )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32SignalCallbackDeInitAll();
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lBusErrorIndCallbackInit( void *pvHandle,
                                                 tCSM_PFN_BUS_ERROR_IND vPFNBusErrorInd )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32BusErrorIndCallbackInit( vPFNBusErrorInd );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lCommunicationReq( void *pvHandle,
                                          tU8  bBus,
                                          tU32 dwProtocolType,
                                          const void *pvAddressField,
                                          tU8  bAction,
                                          tU16 wApplID )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32CommunicationReq( bBus, dwProtocolType, pvAddressField, bAction, wApplID );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lGetCommunicationState( void *pvHandle,
                                               tU8 bBus,
                                               tU32 dwProtocolType,
                                               const void *pvAddressField,
                                               tU8 *pbConnectState,
                                               tU16 wApplId )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32GetCommunicationState( bBus, dwProtocolType, pvAddressField, pbConnectState, wApplId );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lDataReq( void *pvHandle,
                                 tU32 dwProtocolType,
                                 const void *pvAddressField,
                                 const tU8 *pbData,
                                 tU16  wDataLength )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32DataReq( dwProtocolType, pvAddressField, pbData, wDataLength );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lDataIndProcessed( void *pvHandle,
                                          tU32 dwProtocolType,
                                          const void *pvAddressField )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32DataIndProcessed( dwProtocolType, pvAddressField );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lSignalWrite( void *pvHandle,
                                     tU32  dwSignalId,
                                     void *pvNewSignalData,
                                     tU8   bDataBufferLength,
                                     tU8   bTxType )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32SignalWrite( dwSignalId, pvNewSignalData, bDataBufferLength, bTxType );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lMultipleSignalWrite( void                           *pvHandle,
                                             const tCSM_MultipleSignalWrite *prSignalList,
                                             const tU8                       bNumberOfSignals )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32MultipleSignalWrite( prSignalList, bNumberOfSignals );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lSignalRead( void *pvHandle,
                                    tU32  dwSignalId,
                                    void *pvActSignalData,
                                    tU8   bDataBufferLength,
                                    tU32 *pdwSignalStatus )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32SignalRead( dwSignalId, pvActSignalData, bDataBufferLength, pdwSignalStatus );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lMultipleSignalRead( void                          *pvHandle,
                                            const tCSM_MultipleSignalRead *prSignalList,
                                            const tU8                      bNumberOfSignals )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32MultipleSignalRead( prSignalList, bNumberOfSignals );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lGetAllStateIndicationsAgain()
{
   tS32 s32RetVal = -1;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32GetAllStateIndicationsAgain();
   }

   return s32RetVal;
}

tS32 CSMInterface::CSM_lConTest( void *pvHandle,
                                 tU32 dwProtocolType,
                                 void *pvAddressField,
                                 tU8  bAction )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32ConTest( dwProtocolType, pvAddressField, bAction );
   }

   return s32RetVal;
}


tS32 CSMInterface::CSM_lDataRead( void *pvHandle,
                                  tU32 dwProtocolType,
                                  const void *pvAddressField,
                                  tU8 *pbData,
                                  tU16  wDataLength )
{
   tS32 s32RetVal = -1;

   (void) pvHandle;

   if ( poCsmAccessUser )
   {
      s32RetVal = poCsmAccessUser->s32DataRead( dwProtocolType, pvAddressField, pbData, wDataLength );
   }

   return s32RetVal;
}
