// CodeLine.cpp: implementation of the CCodeLine class.
//
//////////////////////////////////////////////////////////////////////


#include "CSMCommThreads.h"

//demo_tclCSMInterface *demo_tclCSMInterface::poMeMyselfAndI = NULL;

#define MIDW_COMMON_HCSM_DEFAULT_INIT -21
/******************************************************FunctionHeaderBegin******
 * CLASS       : demo_tclCSMInterface
 * FUNCTION    : demo_tclCSMInterface
 * CREATED     : 2005-07-26
 * AUTHOR      :
 * DESCRIPTION :   -
 * SYNTAX      : demo_tclCSMInterface(demo_tclservice *poCCAService)
 * ARGUMENTS   :
 *               tVoid
 * RETURN VALUE:
 *               none
 * NOTES       :  Whoaaaa, a copy constructor!!!
 *******************************************************FunctionHeaderEnd******/
tVoid demo_tclCSMInterface::vInit()
{
    // explicit storage for return values...
    tBool bMoep = FALSE;

    //Registry init removed as described by M. Lucki.

    // open csm
    if (hCSM == MIDW_COMMON_HCSM_DEFAULT_INIT)
    {
    	hCSM = OSAL_IOOpen( (char *)pMyConfig->pOsalDeviceName, OSAL_EN_READWRITE);

    	if (hCSM == OSAL_ERROR)
    	{
        	//The OSAL-Device you provided is trash.
	        NORMAL_M_ASSERT_ALWAYS();
	    }
	    else
	    {
	        // signal takeoff to own thread
	        //1 : Register the task
	        //    Task registered in bInputThreadSetup already
	        bMoep  = bThreadSetup()  ;

	        if (bMoep == FALSE)
	        {
	            // We officially became *beeeeeeeeeep*
	            // Assert happens inside function already

	        }
	        // but in case the thread is in the air, do the 2-step-registration:
	        else
	        {
	        }
	    }
	}
	else
	{
		//you are not supposed to run init again after construction
		NORMAL_M_ASSERT_ALWAYS();
	}
}

demo_tclCSMInterface::demo_tclCSMInterface ( ) // constructor
{
    // store pointer to myself for access in callbacks
    //poMeMyselfAndI = this;

    _hCallbackThreadId = DEMO_CSM_RETURN_JUNK;       // ID of the CAN RX thread

    _bTerminate = FALSE; //if true, threads terminate.

    hCSM = MIDW_COMMON_HCSM_DEFAULT_INIT;

    pMyConfig = NULL;

    //you forgot to deliver thread config. No use of default constructor supposed.
    //NORMAL_M_ASSERT_ALWAYS();
}

/******************************************************FunctionHeaderBegin******
 * CLASS       : demo_tclCSMInterface
 * FUNCTION    : ~demo_tclCSMInterface
 * CREATED     : 2005-07-26
 * AUTHOR      :
 * DESCRIPTION :   -
 * SYNTAX      : ~demo_tclCSMInterface(tVoid)
 * ARGUMENTS   :
 *               tVoid
 * RETURN VALUE:
 *               none
 * NOTES       :   Whoaaaaaaaaaaa, a destructor.
 *******************************************************FunctionHeaderEnd******/
demo_tclCSMInterface::~demo_tclCSMInterface(tVoid)
{
    tS32 s32Moep = DEMO_CSM_JANISCHT;

    _bTerminate = TRUE;

    //if our handle cannot be used
    if (_hCallbackThreadId == OSAL_ERROR)
    {
        //say mayday
        //DEMOERROR( DEMO_TRACE_CLASS_MAIN, ET_EN_T16 _ DEMO_ERROR _ ET_EN_T8 _ 11 _ ET_EN_DONE);
        //and give assert.
        NORMAL_M_ASSERT_ALWAYS();
    }
    else
    {
        s32Moep = OSAL_s32ThreadDelete(_hCallbackThreadId);
        if(s32Moep != OSAL_OK)
        {
            //TRACE_SPM_ERROR;
        }
    }

    if (pMyConfig)
    {
		delete pMyConfig;
	}

	if (hCSM == MIDW_COMMON_HCSM_DEFAULT_INIT)
	{
		//seems like there was nothing opened.
	}
	else
	{
		if (hCSM == OSAL_ERROR)
		{
			//Error while opening, Assert was delivered already
		}
		else
		{
			(void) OSAL_s32IOClose(hCSM);
		}
	}

}

/******************************************************FunctionHeaderBegin******
 * CLASS       : rd_tclClusterCSMInterface
 * FUNCTION    : bThreadSetup
 * CREATED     : 2005-10-26
 * AUTHOR      :
 * DESCRIPTION :   -
 * SYNTAX      : tBool bThreadSetup(tU32 u32Priority,tU32 u32StackSize)
 * ARGUMENTS   :
 *               tU32  u32Priority
 *               tU32  u32StackSize
 * RETURN VALUE:
 *               tBool -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/
tBool demo_tclCSMInterface::bThreadSetup(tVoid)
{
    tBool bRetVal = TRUE;
#if (OSAL_OS==OSAL_NUCLEUS)   //Required changes for LCN2Kai Porting (SYA2HI)
    OSAL_trThreadAttribute  rAttr;
    //give 8 char Threadname for nucleus

    if (pMyConfig)
    {
        tU32 u32MyPrio = pMyConfig->u32BroadcastPrio;
        tU32 u32MyStack = pMyConfig->u32BroadcastStack;


       /* Here we can start the thread with the read values */
        rAttr.szName        = pMyConfig->pRegBroadcastThreadName;
        rAttr.s32StackSize  = (tS32) u32MyStack;
        rAttr.u32Priority   = u32MyPrio; //OSAL_C_U32_THREAD_PRIORITY_NORMAL;
        rAttr.pfEntry       = (OSAL_tpfThreadEntry)vCSM_CallbackThread;
        rAttr.pvArg         = (tPVoid)this;
        // Here we spawn our thread ... muahahahaha
        _hCallbackThreadId = OSAL_ThreadSpawn(&rAttr);

        //if our handle cannot be used
        if (_hCallbackThreadId == OSAL_ERROR)
        {
            //say mayday
            //DEMOERROR( DEMO_TRACE_CLASS_MAIN, ET_EN_T16 _ DEMO_ERROR _ ET_EN_T8 _ 11 _ ET_EN_DONE);
            //and give assert.
            NORMAL_M_ASSERT_ALWAYS();
            //for release give return value false
            bRetVal = FALSE;
        }
    }
    else
    {
        //My COnfig Pointer is NULL ???
        NORMAL_M_ASSERT_ALWAYS();
        //for release give return value false
        bRetVal = FALSE;
    }
#endif   //Required changes for LCN2Kai Porting (SYA2HI)
    //keep in mind : TRUE means the task runs properly, false means some POS.
    return bRetVal;
}

#if (OSAL_OS==OSAL_NUCLEUS)    //Required changes for LCN2Kai Porting (SYA2HI)

/******************************************************FunctionHeaderBegin******
 * CLASS       : rd_tclClusterCSMInterface
 * FUNCTION    : vTX_RX_Thread
 * CREATED     : 2005-10-26
 * AUTHOR      :
 * DESCRIPTION :   -
 * SYNTAX      : OSAL_tpfThreadEntry vTX_RX_Thread(tVoid* pvArg)
 * ARGUMENTS   :
 *               tVoid*  pvArg
 * RETURN VALUE:
 *               OSAL_tpfThreadEntry -
 * NOTES       :   -
 *******************************************************FunctionHeaderEnd******/

tVoid demo_tclCSMInterface::vCSM_CallbackThread(const tVoid *pvArg)
{
   //This buffer is for usage of DRV_CSM
   tU8 u8MyBuffer[DEMO_MAX_CSM_BUFFERELEMENTS];
   //ReturnValue for dealing with OSAL-Functions
   tS32 s32Ret = DEMO_CSM_RETURN_JUNK;
   //DRV-CSM structure for Events.
   OSAL_trIOCtrl_RetrieveEvents rRetrieveEvents;

   demo_tclCSMInterface *poMeMyselfAndI = (demo_tclCSMInterface *)pvArg;

   //
   rRetrieveEvents.u32DataBufferLength = sizeof(u8MyBuffer);
   rRetrieveEvents.pvNotifyData = u8MyBuffer;
   rRetrieveEvents.u32Timeout = OSAL_C_TIMEOUT_FOREVER;

   if (pvArg == NULL)
   {
       //r:\jn82hi_DI_PROJECTS_FORD_HSRNS_6.0V18\di_middleware_server\components\fc_ClimateCtrl\DEMO_CSMInterface.cpp(3506) : Info 715: Symbol 'pvArg' (line 3480) not referenced
   }

   //DEMOTRACE( DEMO_TRACE_CLASS_MAIN, ET_EN_T16 _ DEMO_TRCL_IOTHREAD _ ET_EN_T8 _ 3 _ ET_EN_DONE);

   //This is my endless loop. DRV_CSM is offering all the service for me.
   if (poMeMyselfAndI->hCSM == OSAL_ERROR)
   {
       //supposed to be unreachable --> mem writer?
       NORMAL_M_ASSERT_ALWAYS();
   }
   else
   {
       if (poMeMyselfAndI->hCSM == MIDW_COMMON_HCSM_DEFAULT_INIT)
       {
           //supposed to be unreachable --> mem writer?
           NORMAL_M_ASSERT_ALWAYS();
       }
       else
       {
           //hCSM seems ok --> engage!
           s32Ret = OSAL_s32IOControl(poMeMyselfAndI->hCSM, OSAL_C_S32_IOCTRL_NOTIFICATION_TASK, (tS32) &rRetrieveEvents);
           if (s32Ret != OSAL_OK)
           {
               //some error is there
               //DEMOERROR( DEMO_TRACE_CLASS_MAIN, ET_EN_T16 _ DEMO_ERROR _ ET_EN_T8 _ 3 _ ET_EN_DONE);
               NORMAL_M_ASSERT_ALWAYS();
           }
       }
   }
   //DEMOTRACE( DEMO_TRACE_CLASS_MAIN, ET_EN_T16 _ 0x0002 _ ET_EN_T8 _ 1 _ ET_EN_DONE);
   OSAL_vThreadExit();
}

/******************************************************FunctionHeaderBegin******
 * CLASS       : demo_tclCSMInterface
 * FUNCTION    : demo_tclCSMInterface
 * CREATED     : 2005-07-26
 * AUTHOR      :
 * DESCRIPTION :   -
 * SYNTAX      : demo_tclCSMInterface(fc_climate_tclservice *poCCAService)
 * ARGUMENTS   :
 *               tVoid
 * RETURN VALUE:
 *               none
 * NOTES       :  Whoaaaa, a copy constructor!!!
 *******************************************************FunctionHeaderEnd******/

tVoid demo_tclCSMInterface::vSetConfig (CSMThreadConfig *ptmpConfig) // constructor
{
	if (pMyConfig == NULL)
	{
	    pMyConfig = new CSMThreadConfig();
	    if (pMyConfig)
	    {
	        *pMyConfig = *ptmpConfig;
	    }
	    else
	    {
	        //You ran out of memory. Inform the system architect.
	        NORMAL_M_ASSERT_ALWAYS();
	    }
	}
	else
	{
		//You already set the config
		NORMAL_M_ASSERT_ALWAYS();
	}
}
#endif  //Required changes for LCN2Kai Porting (SYA2HI)
