// CSMCommObjectList.h: interface for the CSMCommObjectList class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DEMO_CSM_COMM_OBJECT_IF__H_IF_DONE
#define DEMO_CSM_COMM_OBJECT_IF__H_IF_DONE

//for getting Datatypes
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define DEMO_MAX_CSM_BUFFERELEMENTS 1024

// CSM TX RX thread config
#define DEMO_REG_DEMO_IO_DEFAULT_PRIO          133
#define DEMO_REG_DEMO_IO_DEFAULT_STACK_SIZE   4096
#define DEMO_REG_DEMO_KEY_NAME "FC_BAPDEMO"
#define DEMO_REGVALUE_THREAD_NAME "Demo_IO"
#define DEMO_REGVALUE_IO_STACK_NAME "BCSTACK"
#define DEMO_REGVALUE_IO_PRIO_NAME "BCPRIO"
#define DEMO_REGVALUE_CLEANER_STACK_NAME "BAPSTACK"
#define DEMO_REGVALUE_CLEANER_PRIO_NAME "BAPPRIO"
#define DEMO_REGPATH_THREAD_DATA "APP_THREAD"
#define DEMO_REL_INCREASED_PRIO  ( DEMO_REG_DEMO_IO_DEFAULT_PRIO - 4 )

#define EVENT_DEMO_CLEAN_NAME "LIFE_SUCKS"
#define DEMO_BROADCAST_THREAD_NAME "DEMO_BC"

class CSMThreadConfig
{
/*
private:
    tU32 u32BroadcastDefaultPrio;
    tU32 u32BroadcastDefaultStack;
    tU8 *pRegBroadcastKeyName;
    tU8 *pRegBroadcastStackName;
    tU8 *pRegBroadcastPrioName;
    tU8 *pRegBroadcastThreadName;
    tU8 *pRegBAPKeyName;
    tU8 *pRegBAPStackName;
    tU8 *pRegBAPPrioName;
    tU8 *pRegBAPThreadName;
    tBool bUsesBAP;
    tBool bUsesBC;
    tU8 *pBapEventName;
    tU8 *pBapSemName; */
public:
    tU32  u32BroadcastPrio;
    tU32  u32BroadcastStack;
    tC8   pRegBroadcastThreadName[32];
    tBool bUsesBAP;
    tBool bUsesBC;
    tC8   pOsalDeviceName[32];
#ifdef MIDW_COMMON_CSMIF_MULTITHREAD
    tC8   pBapEventName[32];
    tC8   pBapSemName[32];
    tU32  u32BAPPrio;
    tU32  u32BAPStack;
    tC8   pRegBAPThreadName[32];
#endif
    CSMThreadConfig();
    virtual ~CSMThreadConfig();

    CSMThreadConfig &operator=(const CSMThreadConfig &source);
    bool operator==(const CSMThreadConfig &source) const;
};

#endif
