#include "CSMCommObjects.h"

CSMThreadConfig::CSMThreadConfig()
{
	u32BroadcastPrio = DEMO_REG_DEMO_IO_DEFAULT_PRIO;  
	u32BroadcastStack= DEMO_REG_DEMO_IO_DEFAULT_STACK_SIZE; 
	bUsesBAP= FALSE;                
	bUsesBC=FALSE;                 
	strcpy (pOsalDeviceName , "NOT INITIALIZED");
	strcpy (pRegBroadcastThreadName , "NOT INITIALIZED");
}

CSMThreadConfig::~CSMThreadConfig()
{
}

CSMThreadConfig &CSMThreadConfig::operator=(const CSMThreadConfig &source)
{

	if( &source == this || source == *this)
	{
		//Self assignment!
	}
	else
	{
        bUsesBAP = source.bUsesBAP;
    	bUsesBC = source.bUsesBC;
        u32BroadcastPrio  = source.u32BroadcastPrio;   
        u32BroadcastStack = source.u32BroadcastStack;  
        strcpy( (char *)pRegBroadcastThreadName , (const char *)source.pRegBroadcastThreadName );

		//OSAL-Device name should be given anyway.
		strcpy( (char *)pOsalDeviceName , (const char *)source.pOsalDeviceName );
	}

	return *this;
}

bool CSMThreadConfig::operator==(const CSMThreadConfig &source) const
{
	bool bRet;
	bRet = true;

	if (strcmp (source.pOsalDeviceName,pOsalDeviceName))
	{
		bRet = false;
	}

	return bRet;
}
