/****************************************************************************
/*****************************************************************************
* FILE 			: IntercomNanoMessageClientHandler.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	:
*
* DESCRIPTION 	:
*
*
* AUTHOR 		: Monojit Chatterjee (CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 02/02/2020     Initial version
*
****************************************************************************/
#ifndef _INTERCOM_GSTREAMER_H_
#define _INTERCOM_GSTREAMER_H_

#include<gst/gst.h>
#include <dlt/dlt.h>
#include <queue>
#include <thread>
#include <memory>
#include <mutex>
#include <condition_variable>
#include <thread>
#include <functional>
#include "IntercomService.h"

using namespace std;

using namespace IntercomApp;
// This class will be used for intercom gstreamer audio processing
class InterComAudioProcessing
{
public :

    typedef enum ePipelinetype
    {
        SENDER_PIPELINE,

        RECEIVER_PIPELINE

    }  pipelinetype ;

    typedef enum ePORT
    {
        RECEIVER_PORT = 5883,

        SENDER_PORT   = 5884

    }  portNumber ;


    typedef enum eProgressStatus
    {
        PIPELINE_INITIATED,

        RECEIVE_PIPELINE_CLEARED,

        SEND_PIPELINE_CLEARED,

        PIPELINE_UNDEFINED

    }  ProgressStatus ;



    // Reading the and recorsing the gstreamer pipeline for RTP streaming
    void sendRTPAudio( void   );

    static InterComAudioProcessing* createInstance ( );

    /* Process messages from GStreamer for Receiving pipeline*/
    static gboolean handle_message_ReceiveRTPAudio (GstBus *bus, GstMessage *msg, void *data);

    /* Process messages from GStreamer for Sending pipeline*/
    static gboolean handle_message_sendRTPAudio (GstBus *bus, GstMessage *msg, void *data);

    // playback operation of gstreamer playback
    void ReceiveRTPAudio( void);

    // stop rtp audio
    bool stopRTPAudio(  );

    // This is to initialize gstreamer
    bool launchPipeline();

    bool cleanPipeline ( pipelinetype pipelinetype_ , guint bus_watch_id );

    void setPipeline   ( pipelinetype pipelinetype_, GstElement* pipeline )
    {
        if ( pipelinetype_ == SENDER_PIPELINE )
            pipesend = pipeline ;
        else
            piperecv = pipeline;
    }

    guint createWatcherBus ( pipelinetype pipelinetype_ , GstBusFunc busfunc );

    void setMainLoop   ( pipelinetype pipelinetype_, GMainLoop* mainloop )
    {
        if ( pipelinetype_ == SENDER_PIPELINE )
            loopsend =  mainloop;
        else
            looprecv = mainloop ;
    }



    GstElement* getPipeline ( pipelinetype pipelinetype_  )
    {
        return  ( pipelinetype_ == SENDER_PIPELINE ? pipesend : piperecv );
    }

    GMainLoop* getMainLoop ( pipelinetype pipelinetype_  )
    {
        return  ( pipelinetype_ == SENDER_PIPELINE ? loopsend : looprecv );
    }

    int getPort ( pipelinetype pipelinetype_ )
    {
        return  ( pipelinetype_ == SENDER_PIPELINE ? senderport : receiverport );
    }

    string getAudioDevice ( pipelinetype pipelinetype_ )
    {
        return  ( pipelinetype_ == SENDER_PIPELINE ? "AdevMicro12AmpRef" : "AdevVoiceOut" );
    }
	
	void init()
	{
		gst_init (NULL, NULL);
	}


	
    static mutex                  sync_ ;

    static condition_variable     cv_ ;

    typedef unique_lock < mutex > ScopedLock ;

private :


   //check and clear pipeline 
   
    bool CheckAndUnrefPipeline ( GstElement* pipeline )
	{
		if ( pipeline != nullptr ) 
		{
			gst_object_unref (GST_OBJECT ( pipeline ) );
			return true;
		}
		else
		{
			return false ;
		}
	}
	
	// check and clear mainloop
	bool CheckAndUnrefMainLoop ( GMainLoop* mainloop )
	{
		if ( mainloop != nullptr ) 
		{
			g_main_loop_unref ( mainloop );
			return true;
		}
		else
		{
			return false ;
		}
	}
	
	
    // This is the hostname and will be changed based on need
    char *hostname;

    // This is the default alsa device for audio processing and intended for change

    char *alsadevicename;

    // This is the Hardcoded portnumber for audio processing and intended for change
    int senderport  =  SENDER_PORT ;

    int receiverport = RECEIVER_PORT;

    // constructor
    InterComAudioProcessing ();

    thread    rtpReceiver_ , rtpSender_ ;


    static InterComAudioProcessing* mInterComAudioProcessing;

    std::string getPipelineTypetoString ( pipelinetype pipelinetype_ )
    {
        return ( pipelinetype_ == SENDER_PIPELINE ? "CMC->CMA pipeline" : "CMA->CMC pipeline" );
    }





    GMainLoop *loopsend = nullptr;
    GMainLoop *looprecv = nullptr;

    GstElement* pipesend     = nullptr;
    GstElement* piperecv = nullptr;

    function <void(void)>  senderthread;//   = bind ( &InterComAudioProcessing::sendRTPAudio, this ) ;
    function <void(void)>  receiverThread;// = bind ( &InterComAudioProcessing::ReceiveRTPAudio, this );
	

    guint bus_watch_id;

    // static pthread_t threadrec, threadplay;

    // typedef void* (*THREADFUNCPTR)(void *);


    IntercomService* mIntercomService = nullptr;
	
	static volatile ProgressStatus mProgressStatus;


};

#endif




