
/****************************************************************************
/*****************************************************************************
* FILE 			: IntercomNanoMessageClientHandler.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	:
*
* DESCRIPTION 	:
*
*
* AUTHOR 		: Monojit Chatterjee (CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 30/06/2020    draft version
*
****************************************************************************/
#include <gst/gst.h>
#include <iostream>
#include <string>
#include "intercom_gstreamer_app.hpp"
#include <IntercomNanoMessageClientHandler.h>


using namespace IntercomApp;
#define GST_STATE_CHANGE_NO_WAIT (GST_STATE_CHANGE_ASYNC | GST_STATE_CHANGE_SUCCESS)


InterComAudioProcessing* InterComAudioProcessing::mInterComAudioProcessing = nullptr;



condition_variable    InterComAudioProcessing::cv_ ;

mutex                 InterComAudioProcessing::sync_ ;

volatile InterComAudioProcessing::ProgressStatus InterComAudioProcessing::mProgressStatus = InterComAudioProcessing::PIPELINE_UNDEFINED;





DLT_IMPORT_CONTEXT( INTERCOM_RTP );
InterComAudioProcessing::InterComAudioProcessing()
{
    senderthread   = bind ( &InterComAudioProcessing::sendRTPAudio, this ) ;
    receiverThread = bind ( &InterComAudioProcessing::ReceiveRTPAudio, this );
    mIntercomService = IntercomService::createInstance();
}

InterComAudioProcessing* InterComAudioProcessing::createInstance()
{

    if ( mInterComAudioProcessing == nullptr )
    {
        mInterComAudioProcessing = new InterComAudioProcessing();
        DLT_LOG(INTERCOM_RTP, DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing : createInstance  singleton created"));
    }

    return mInterComAudioProcessing;
}
void InterComAudioProcessing::sendRTPAudio( )
{






    GMainLoop* mainloop = NULL ;
	
	
	GMainContext *thread1_sendRTP = g_main_context_new ();
	
	DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]GMainContext new "));
	
	g_main_context_push_thread_default (thread1_sendRTP);
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]GMainContext thread default "));
    mainloop = g_main_loop_new ( thread1_sendRTP , FALSE );
    InterComAudioProcessing::createInstance ( )->setMainLoop ( SENDER_PIPELINE, mainloop );
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]g_main_loop_new for recording pipeline "));


    GstElement* pipeline = NULL;
    GstElement *source = NULL;
    //GstElement *caps = NULL;
    GstElement *pay = NULL;
    GstElement *conv = NULL;
    GstElement *sink = NULL;




    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]g_main_loop_new for recording pipeline before  setPipeline"));
    pipeline = gst_pipeline_new ("CMC->CMA");
    InterComAudioProcessing::createInstance ( )->setPipeline ( SENDER_PIPELINE, pipeline );
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]g_main_loop_new for recording pipeline after  setPipeline"));
    source   = gst_element_factory_make ("alsasrc",       NULL);
    pay  = gst_element_factory_make ("rtpL16pay",      NULL);
    conv    = gst_element_factory_make ("audioconvert",  NULL);
    sink     = gst_element_factory_make ("udpsink", NULL);
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_element_factory_make success "));

    if ( !mainloop || !pipeline || !source  || !pay || !conv || !sink  )
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING(" pipeline failure in CMC->CMA and sending error"));
       /*if (  CheckAndUnrefPipeline ( pipeline )  && CheckAndUnrefMainLoop ( mainloop ) )
	   {
		    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is valid object "));
	   }
	   else
	   {
		   DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is null "));
	   }*/

        mIntercomService->sendRTPError ( RTP_FACTORY_FAILURE_ERROR ) ;
        
     
		return ;
       
    }

    /*  GstCaps* caps_first =  gst_caps_new_simple("audio/x-raw-int",
    "rate", G_TYPE_INT, 48000,
    "channels", G_TYPE_INT, 1,
    "width",G_TYPE_INT,16,"depth",G_TYPE_INT,16,"endianness",G_TYPE_INT,4321, "signed",G_TYPE_BOOLEAN,true,NULL);*/

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_caps_from_string "));
    GstCaps* caps = gst_caps_from_string ("audio/x-raw-int, rate=48000, channels=1,  width=16,depth=16,endianness=4321, signed=true");
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_caps_from_string success "));


    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]gst_caps_new_simple"));


    /* we add all elements into the pipeline */

    g_object_set(G_OBJECT (source), "device", InterComAudioProcessing::createInstance ( )->getAudioDevice( SENDER_PIPELINE ).c_str() , NULL);

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] g_object_set AdevMicro12AmpRef success "));


    g_object_set(G_OBJECT(sink), "host",IntercomNanoMessageClientHandler::createInstance()->getAmpIpAddress ().c_str() , NULL);
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] g_object_set getAmpIpAddress success "));
    g_object_set(G_OBJECT(sink), "port",InterComAudioProcessing::createInstance ( )-> getPort ( SENDER_PIPELINE ), NULL);
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] g_object_set sink success "));
    gst_bin_add_many (GST_BIN ( pipeline ),
                      source,  conv, pay, sink, NULL);
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_bin_add_many  success "));




    if(!gst_element_link (source, conv))
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]source->conv link error"));
 
      if (  CheckAndUnrefPipeline ( pipeline )  && CheckAndUnrefMainLoop ( mainloop ) )
	   {
		    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is valid object "));
	   }
	   else
	   {
		   DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is null "));
	   }

        mIntercomService->sendRTPError ( RTP_SEND_PIPELINE_ELEMENT_LINK_ERROR ) ;
        //  g_source_remove (bus_watch_id);

       
	   
		return;
        // pthread_exit ( NULL );
    }

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_element_link souce->conv  success "));
    gboolean link_ok = gst_element_link_filtered ( conv , pay,   caps );
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_element_link_filtered conv->pay->caps  success "));
    gst_caps_unref ( caps );

    if (! link_ok )
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]recordingpipeline failed due to link failure2"));
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING(" pipeline failure in CMC->CMA"));
        mIntercomService->sendRTPError ( RTP_SEND_PIPELINE_ELEMENT_LINK_ERROR ) ;
       if (  CheckAndUnrefPipeline ( pipeline )  && CheckAndUnrefMainLoop ( mainloop ))
	   {
		    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is valid object "));
	   }
	   else
	   {
		   DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is null "));
	   }
		return;
        // pthread_exit ( NULL );
    }

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_element_link_filtered conv->pay->caps link_ok  success "));

    if (! gst_element_link_many (pay, sink, NULL ))
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]pay->sink link error"));
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING(" pipeline failure in CMC->CMA"));
        mIntercomService->sendRTPError ( RTP_SEND_PIPELINE_ELEMENT_LINK_ERROR ) ;
       if (  CheckAndUnrefPipeline ( pipeline )  && CheckAndUnrefMainLoop ( mainloop ))
	   {
		    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is valid object "));
	   }
	   else
	   {
		   DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is null "));
	   }
        //  pthread_exit ( NULL );
    }

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_element_link_many pay->sink link_ok  success "));
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]gst_element_link established "));

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] GST_STATE_PLAYING before "));
    GstStateChangeReturn ret = gst_element_set_state ( pipeline, GST_STATE_PLAYING );
    if (ret == GST_STATE_CHANGE_FAILURE)
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] playback failed "));
       if (  CheckAndUnrefPipeline ( pipeline )  && CheckAndUnrefMainLoop ( mainloop ))
	   {
		    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is valid object "));
	   }
	   else
	   {
		   DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] pipeline or mainloop any of it is null "));
	   }
        mIntercomService->sendRTPError ( RTP_SEND_PIPELINE_STATE_CHANGE_ERROR ) ;
		return;
        // pthread_exit ( NULL );
    }

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] GST_STATE_PLAYING after "));

    //gst_element_set_state ( piperec, GST_STATE_PLAYING);
    //gst_pipeline_set_auto_flush_bus ( piperec, false );

    guint watcherId = InterComAudioProcessing::createInstance ( )-> createWatcherBus( SENDER_PIPELINE , (GstBusFunc) &InterComAudioProcessing::handle_message_sendRTPAudio );

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_bus_add_watch established "));


    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]gst_element_set_state GST_STATE_PLAYING looprec"));

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio]g_main_loop_run looprec"));
    // gst_object_unref ( InterComAudioProcessing::busrec );
    mIntercomService->sendRTPError ( No_ERROR_RTP );
    g_main_loop_run ( mainloop );
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] g_source_remove clear"));

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] gst_element_set_state NULL"));
    if ( InterComAudioProcessing::createInstance ( )-> cleanPipeline ( SENDER_PIPELINE , watcherId ) )
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] cleanPipeline success and cleanup maincontext entry "));
		
		  g_main_context_pop_thread_default (thread1_sendRTP);
          g_main_context_unref (thread1_sendRTP);
		  DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] cleanPipeline success and cleanup maincontext exit "));


    }
    else
    {
        mIntercomService->sendRTPError ( RTP_CLEAR_PIPELINE_ERROR ) ;
    }
		InterComAudioProcessing::mProgressStatus = InterComAudioProcessing::SEND_PIPELINE_CLEARED ;
		cv_. notify_one () ;
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[sendRTPAudio] g_main_loop_unref looprec unref"));
    return;


}
/* Process messages from GStreamer */
gboolean InterComAudioProcessing::handle_message_ReceiveRTPAudio (GstBus *bus, GstMessage *msg, void *data)
{
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: handle_message_ReceiveRTPAudio"));
    GError *err;
    gchar *debug_info;
    GstElement* pipeline = InterComAudioProcessing::createInstance ( )->getPipeline ( RECEIVER_PIPELINE );

    switch (GST_MESSAGE_TYPE (msg))
    {
    case GST_MESSAGE_ERROR:
        gst_message_parse_error (msg, &err, &debug_info);
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: handle_message_ReceiveRTPAudio [ CMA->CMC ] ERROR [ errors ] :"),  DLT_CSTRING ( err->message ), DLT_CSTRING( "[ debug: ] : "), DLT_CSTRING( debug_info ) );
        g_clear_error (&err);
        g_free (debug_info);
        IntercomService::createInstance()->sendRTPError ( RTP_RECEIVE_PIPELINE_PARSE_ERROR ) ;


        g_main_loop_quit ( InterComAudioProcessing::createInstance ( )->getMainLoop ( RECEIVER_PIPELINE ));
        break;
    case GST_MESSAGE_EOS:
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: handle_message_ReceiveRTPAudio GST_MESSAGE_EOS"));
        //gst_element_set_state(pipeline.get(), GST_STATE_NULL);
        g_main_loop_quit (InterComAudioProcessing::createInstance ( )->getMainLoop ( RECEIVER_PIPELINE ));
        IntercomService::createInstance()->sendRTPError ( RTP_RECEIVE_PIPELINE_EOS_ERROR ) ;
        break;
    case GST_MESSAGE_STATE_CHANGED:
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: handle_message_ReceiveRTPAudio GST_MESSAGE_STATE_CHANGED"));
        GstState old_state, new_state, pending_state;
        gst_message_parse_state_changed (msg, &old_state, &new_state, &pending_state);
        if (GST_MESSAGE_SRC (msg) == GST_OBJECT (pipeline))
        {
            if (new_state == GST_STATE_PLAYING)
            {
                DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: handle_message_ReceiveRTPAudio [ CMA->CMC ] pipeline PLAYING"));
            }
            else if ( new_state == GST_STATE_PAUSED )
            {
                DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: handle_message_ReceiveRTPAudio [ CMA->CMC ] pipeline PAUSED"));
            }
            else if ( new_state == GST_STATE_READY )
            {
                DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: handle_message_ReceiveRTPAudio [ CMA->CMC ] pipeline READY"));
            }
            else if ( new_state == GST_STATE_NULL )
            {
                DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: handle_message_ReceiveRTPAudio [ CMA->CMC ] pipeline READY"));
            }


        }
    }
    break;
    default :
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: handle_message_ReceiveRTPAudio [ CMA->CMC ] default case handled"));
    }

    /* We want to keep receiving messages */
    return TRUE;
}



gboolean InterComAudioProcessing::handle_message_sendRTPAudio (GstBus *bus, GstMessage *msg, void *data)
{
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing::handle_message_sendRTPAudio handle_message"));
    GError *err;
    gchar *debug_info;
    GstElement *pipeline = InterComAudioProcessing::createInstance ( )->getPipeline ( SENDER_PIPELINE );
    switch (GST_MESSAGE_TYPE (msg))
    {
    case GST_MESSAGE_ERROR:

        gst_message_parse_error (msg, &err, &debug_info);
		DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing::handle_message_sendRTPAudio [ CMC->CMA ] ERROR [ errors ] :"),  DLT_CSTRING ( err->message ), DLT_CSTRING( "[ debug: ] : "), DLT_CSTRING( debug_info ) );
        g_clear_error (&err);
        g_free (debug_info);

        g_main_loop_quit (InterComAudioProcessing::createInstance ( )->getMainLoop ( SENDER_PIPELINE ));
        IntercomService::createInstance()->sendRTPError ( RTP_SEND_PIPELINE_PARSE_ERROR ) ;
        break;
    case GST_MESSAGE_EOS:
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing::handle_message_sendRTPAudio [ CMC->CMA ] EOS"));
        g_main_loop_quit (InterComAudioProcessing::createInstance ( )->getMainLoop ( SENDER_PIPELINE ));
        IntercomService::createInstance()->sendRTPError ( RTP_SEND_PIPELINE_EOS_ERROR ) ;
        break;
    case GST_MESSAGE_STATE_CHANGED:
    {

        //g_print("test handle_message MESSAGE_STATE_CHANGED \n");
        GstState old_state, new_state, pending_state;
        gst_message_parse_state_changed (msg, &old_state, &new_state, &pending_state);
        if (GST_MESSAGE_SRC (msg) == GST_OBJECT (pipeline))
        {
            if (new_state == GST_STATE_PLAYING)
            {
                DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing::handle_message_sendRTPAudio [ CMC->CMA ] pipeline PLAYING"));
            }
            else if ( new_state == GST_STATE_PAUSED )
            {
                DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing::handle_message_sendRTPAudio [ CMC->CMA ] pipeline PAUSED"));
            }
            else if ( new_state == GST_STATE_READY )
            {
                DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing::handle_message_sendRTPAudio [ CMC->CMA ] pipeline READY"));
            }
            else if ( new_state == GST_STATE_NULL )
            {
                DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing::handle_message_sendRTPAudio [ CMA->CMC ] pipeline READY"));
            }
        }
    }
    break;

    default :
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing::handle_message_sendRTPAudio [ CMC->CMA ] default case handled"));


    }

    /* We want to keep receiving messages */
    return TRUE;
}



void InterComAudioProcessing::ReceiveRTPAudio(  )
{
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio]InterComAudioProcessing:: ReceiveRTPAudio"));

    GMainLoop* mainloop = NULL;
	
	GMainContext *thread2_ReceiveRTP = g_main_context_new ();
	
	DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio]GMainContext new "));
	
	g_main_context_push_thread_default (thread2_ReceiveRTP);
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio]GMainContext thread default "));
    mainloop = g_main_loop_new ( thread2_ReceiveRTP , FALSE );
    GstElement* pipeline = NULL;
    GstElement *source = NULL;
    GstElement *caps = NULL;
    GstElement *depay = NULL;
    GstElement *conv = NULL;
    GstElement *sink = NULL;


    InterComAudioProcessing::createInstance ( )->setMainLoop ( RECEIVER_PIPELINE, mainloop );


    pipeline = gst_pipeline_new ("CMA->CMC");

    InterComAudioProcessing::createInstance ( )->setPipeline ( RECEIVER_PIPELINE, pipeline );

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] gst_pipeline_new success"));
    source   = gst_element_factory_make ("udpsrc",       NULL);
    caps   = gst_element_factory_make ("capsfilter",       NULL);


    depay  = gst_element_factory_make ("rtpL16depay",      NULL);

    conv     = gst_element_factory_make ("audioconvert",  NULL);

    sink     = gst_element_factory_make ("alsasink", NULL);

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] gst_element_factory_make success"));

    if ( !mainloop || !pipeline || !source  || !caps || !depay || !conv || !sink  )
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING(" pipeline failure in CMA->CMC"));
      /* if (  CheckAndUnrefPipeline ( pipeline )  && CheckAndUnrefMainLoop ( mainloop ))
	   {
		    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] pipeline or mainloop any of it is valid object "));
	   }
	   else
	   {
		   DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] pipeline or mainloop any of it is null "));
	   }*/
        mIntercomService->sendRTPError ( RTP_FACTORY_FAILURE_ERROR ) ;

        return;
    }

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio]!InterComAudioProcessing::looplay || !pipeline || !source  || !caps || !depay || !conv || !sink "));





    g_object_set(source, "caps", gst_caps_new_simple("application/x-rtp",
                 "media", G_TYPE_STRING, "audio",
                 "clock-rate", G_TYPE_INT, 48000,
                 "payload",G_TYPE_INT,96,NULL), NULL);


    g_object_set(G_OBJECT (sink), "device", InterComAudioProcessing::createInstance ( )->getAudioDevice( RECEIVER_PIPELINE ).c_str(), NULL);

    g_object_set(G_OBJECT(source), "port",InterComAudioProcessing::createInstance ( )-> getPort ( RECEIVER_PIPELINE ), NULL);

    /* we add all elements into the pipeline */

    gst_bin_add_many (GST_BIN ( pipeline ),
                      source, depay, conv, sink, NULL);

    if ( !gst_element_link_many (source, depay,conv, sink, NULL))
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING(" [ReceiveRTPAudio] pipeline failure in CMA->CMC"));
       if (  CheckAndUnrefPipeline ( pipeline )  && CheckAndUnrefMainLoop ( mainloop ))
	   {
		    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] pipeline or mainloop any of it is valid object "));
	   }
	   else
	   {
		   DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] pipeline or mainloop any of it is null "));
	   }
        mIntercomService->sendRTPError ( RTP_RECEIVE_PIPELINE_ELEMENT_LINK_ERROR ) ;

        // pthread_exit ( NULL );
		return;
    }


    //gst_pipeline_set_auto_flush_bus ( pipeline, false );
    GstStateChangeReturn ret = gst_element_set_state ( pipeline, (GstState)(GST_STATE_PLAYING  | GST_STATE_CHANGE_NO_WAIT));
    if (ret == GST_STATE_CHANGE_FAILURE)
    {
       if (  CheckAndUnrefPipeline ( pipeline )  && CheckAndUnrefMainLoop ( mainloop ))
	   {
		    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] pipeline or mainloop any of it is valid object "));
	   }
	   else
	   {
		   DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] pipeline or mainloop any of it is null "));
	   }
        mIntercomService->sendRTPError ( RTP_RECEIVE_PIPELINE_STATE_CHANGE_ERROR ) ;
        //  pthread_exit ( NULL );
        // return nullptr;
		return;
    }



    guint watcherId = InterComAudioProcessing::createInstance ( )-> createWatcherBus( RECEIVER_PIPELINE , ( GstBusFunc ) &InterComAudioProcessing::handle_message_ReceiveRTPAudio );
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] busplay addwatch started"));


    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] g_main_loop_run for looplay"));
    mIntercomService->sendRTPError ( No_ERROR_RTP );
    g_main_loop_run ( mainloop );



    if ( InterComAudioProcessing::createInstance ( )-> cleanPipeline ( RECEIVER_PIPELINE , watcherId ) )
    {
               DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] cleanPipeline success and cleanup maincontext entry "));
		
		  g_main_context_pop_thread_default (thread2_ReceiveRTP);
          g_main_context_unref (thread2_ReceiveRTP);
		  DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("[ReceiveRTPAudio] cleanPipeline success and cleanup maincontext exit "));

    }
    else
    {
        mIntercomService->sendRTPError ( RTP_CLEAR_PIPELINE_ERROR ) ;
    }
	
	InterComAudioProcessing::mProgressStatus = InterComAudioProcessing::RECEIVE_PIPELINE_CLEARED ;
	cv_. notify_one () ;


    //pthread_exit ( NULL );

    return;
}



bool InterComAudioProcessing::stopRTPAudio()
{
    //ScopedLock lock ( sync_ ) ;
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: stopRTPAudio start "));

    if (nullptr != InterComAudioProcessing::createInstance ( )->getMainLoop ( RECEIVER_PIPELINE) )
    {
        if (g_main_loop_is_running( InterComAudioProcessing::createInstance ( )->getMainLoop ( RECEIVER_PIPELINE) ) )
        {
            DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("g_main_loop_is_running quit for playback , cv.wait started"));
            g_main_loop_quit( InterComAudioProcessing::createInstance ( )->getMainLoop ( RECEIVER_PIPELINE) );
			ScopedLock lock ( sync_ ) ;
            while ( InterComAudioProcessing::mProgressStatus != InterComAudioProcessing::RECEIVE_PIPELINE_CLEARED  )    cv_. wait ( lock ) ;
			DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("g_main_loop_is_running RECEIVE_PIPELINE_CLEARED cv.wait done"));
        }
    }

    else
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("g_main_loop_is_running not running reciever pipeline"));
    }

    if (nullptr != InterComAudioProcessing::createInstance ( )->getMainLoop ( SENDER_PIPELINE) )
    {
        if (g_main_loop_is_running( InterComAudioProcessing::createInstance ( )->getMainLoop ( SENDER_PIPELINE)  ) )
        {
            DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("g_main_loop_is_running quit for recording cv.wait started" ));
            g_main_loop_quit( InterComAudioProcessing::createInstance ( )->getMainLoop ( SENDER_PIPELINE ) );
			ScopedLock lock ( sync_ ) ;
            while ( InterComAudioProcessing::mProgressStatus != InterComAudioProcessing::SEND_PIPELINE_CLEARED )    cv_. wait ( lock ) ;
			DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("g_main_loop_is_running SEND_PIPELINE_CLEARED cv.wait done"));
        }
    }
    else
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("g_main_loop_is_running not running sender pipeline"));
    }
	
	InterComAudioProcessing::mProgressStatus = InterComAudioProcessing::PIPELINE_UNDEFINED ;
	InterComAudioProcessing::createInstance ( )->setMainLoop ( SENDER_PIPELINE, nullptr );
	InterComAudioProcessing::createInstance ( )->setMainLoop ( RECEIVER_PIPELINE, nullptr );

    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: stopRTPAudio end"));

	
    return true;

}

bool InterComAudioProcessing::cleanPipeline ( pipelinetype pipelinetype_, guint bus_watch_id  )
{
    ScopedLock lock ( sync_ ) ;
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO,  DLT_CSTRING(" cleanPipeline"));
    if ( InterComAudioProcessing::createInstance ( )->getPipeline ( pipelinetype_ ) != nullptr
            || InterComAudioProcessing::createInstance ( )->getMainLoop ( pipelinetype_) != nullptr )
    {

        gst_element_set_state ( InterComAudioProcessing::createInstance ( )->getPipeline ( pipelinetype_ ), GST_STATE_NULL);
        gst_object_unref (GST_OBJECT ( InterComAudioProcessing::createInstance ( )->getPipeline ( pipelinetype_ ) ) );
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING ( InterComAudioProcessing::createInstance ( )->getPipelineTypetoString ( pipelinetype_ ).c_str() ), DLT_CSTRING(" g_main_loop_unref for pipeline"));
        g_source_remove (bus_watch_id);
        g_main_loop_unref ( InterComAudioProcessing::createInstance ( )->getMainLoop ( pipelinetype_) );
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING ( InterComAudioProcessing::createInstance ( )->getPipelineTypetoString ( pipelinetype_ ).c_str() ), DLT_CSTRING("g_main_loop_unref for looplay"));
        return true;
    }

    return false;
}


guint InterComAudioProcessing::createWatcherBus ( pipelinetype pipelinetype_ , GstBusFunc busfunc )
{

    //ScopedLock lock ( sync_ ) ;

    
    if ( InterComAudioProcessing::createInstance ( )->getPipeline ( pipelinetype_ ) != nullptr
            || InterComAudioProcessing::createInstance ( )->getMainLoop ( pipelinetype_) != nullptr )
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING ( InterComAudioProcessing::createInstance ( )->getPipelineTypetoString ( pipelinetype_ ).c_str() ), DLT_CSTRING("createWatcherBus started "));
        GstBus* busplay = gst_element_get_bus ( InterComAudioProcessing::createInstance ( )->getPipeline ( pipelinetype_ ) );
        guint bus_watch_id = gst_bus_add_watch ( busplay, busfunc , InterComAudioProcessing::createInstance ( )->getPipeline ( pipelinetype_ ) );
        gst_object_unref ( busplay );


    }
    DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING ( InterComAudioProcessing::createInstance ( )->getPipelineTypetoString ( pipelinetype_ ).c_str() ), DLT_CSTRING("createWatcherBus success"));
    return  bus_watch_id ;
}

bool InterComAudioProcessing::launchPipeline()
{
    //ScopedLock lock ( sync_ ) ;

    if ( senderthread != nullptr && receiverThread != nullptr )
    {

        rtpSender_ = thread (    senderthread    ) ;

        rtpReceiver_ = thread (    receiverThread  ) ;
		
		InterComAudioProcessing::mProgressStatus = InterComAudioProcessing::PIPELINE_INITIATED ;

        rtpSender_.detach();
        rtpReceiver_.detach();

        return true ;
    }
    else
    {
        DLT_LOG(INTERCOM_RTP , DLT_LOG_INFO, DLT_CSTRING("InterComAudioProcessing:: launchPipeline threadcreation failed"));
        mIntercomService->sendRTPError ( RTP_THREAD_FAILURE_ERROR ) ;
        return false;
    }



}






