/*****************************************************************************
* FILE 			: IntercomNanoMessageClientHandler.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	: VDVoice
*
* DESCRIPTION 	: This class provides the initialization
*                 and external interface of VDVoice subcomponent.
*
* AUTHOR 		: Monojit Chatterjee (CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 24/04/2020     Initial version
*
* Version       : 1.0
*
****************************************************************************/
#if !defined(INTERCOM_CLIENT_HANDLER_NN_MSG_H)
#define INTERCOM_CLIENT_HANDLER_NN_MSG_H

#include <algorithm>
#include <sys/types.h>
#include <stdlib.h>
#include <fcntl.h>

#include "bosch/cm/di/NanoMsgIntercomInterfaceProxy.h"
#include "bosch/cm/di/NanoMsgIntercomInterface.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceDBus.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceJson.h"
#include "bosch/cm/di/NanoMsgIntercomInterfaceClientBase.h"
#include <unordered_map>
#include "IntercomService.h"
#include "IntercomConstantTypes.h"
#include "asf/core/BaseComponent.h"
#include "AVRoutingParser.h"





class XMLReader;

namespace IntercomApp
{

using namespace asf::core;
using namespace ::bosch::cm::di::NanoMsgIntercomInterface;
class IntercomService;

class IntercomNanoMessageClientHandler
    :   public EventAcceptHUCallCallbackIF,
        public EventCancelHUCallCallbackIF,
        public EventHUCallCallbackIF,
        public ReqGetVersionCallbackIF,
        public ReqGetVolumeCallbackIF,
        public ReqPhoneStatusCallbackIF,
        public ReqSetVolumeCallbackIF,
        public ReqSetVolumeDownCallbackIF,
        public ReqSetVolumeUpCallbackIF,
        public ReqGetIntercomAvailableCallbackIF,
        public Sig_EventAcceptIntercomCallCallbackIF,
        public Sig_EventCancelIntercomCallCallbackIF,
        public Sig_EventIntercomCallCallbackIF,
        public Sig_EventPhoneStatusChangedCallbackIF,
        public Sig_EventSetVolumeCallbackIF,
        public Sig_RspGetVersionCallbackIF,
        public Sig_RspGetVolumeCallbackIF,
        public Sig_RspPhoneStatusCallbackIF,
        public Sig_EventIntercomAvailableCallbackIF,
        public Sig_RspGetIntercomAvailableCallbackIF,
        public BaseComponent,
        public ServiceAvailableIF


{
public :

    static IntercomNanoMessageClientHandler* createInstance ( );

    // static IntercomNanoMessageClientHandler* getInstance ()           {  return               this ;                }

    IntercomNanoMessageClientHandler();

    virtual ~IntercomNanoMessageClientHandler();

    virtual void onAvailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ServiceStateChange& stateChange) ;
    virtual void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy, const ServiceStateChange& stateChange) ;

    virtual void onEventAcceptHUCallError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< EventAcceptHUCallError >& error) ;

    virtual void onEventAcceptHUCallResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< EventAcceptHUCallResponse >& response) ;




    virtual void onEventCancelHUCallError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< EventCancelHUCallError >& error) ;

    virtual void onEventCancelHUCallResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< EventCancelHUCallResponse >& response) ;




    virtual void onEventHUCallError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< EventHUCallError >& error) ;

    virtual void onEventHUCallResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< EventHUCallResponse >& response) ;



    virtual void onReqGetVersionError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVersionError >& error) ;

    virtual void onReqGetVersionResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVersionResponse >& response) ;




    virtual void onReqGetVolumeError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVolumeError >& error) ;

    virtual void onReqGetVolumeResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetVolumeResponse >& response) ;



    virtual void onReqPhoneStatusError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqPhoneStatusError >& error);

    virtual void onReqPhoneStatusResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqPhoneStatusResponse >& response) ;




    virtual void onReqSetVolumeError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetVolumeError >& error) ;

    virtual void onReqSetVolumeResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetVolumeResponse >& response);




    virtual void onReqSetVolumeDownError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetVolumeDownError >& error) ;

    virtual void onReqSetVolumeDownResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetVolumeDownResponse >& response) ;




    virtual void onReqSetVolumeUpError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetVolumeUpError >& error) ;

    virtual void onReqSetVolumeUpResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqSetVolumeUpResponse >& response) ;


    virtual void onReqGetIntercomAvailableError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetIntercomAvailableError >& error) ;

    virtual void onReqGetIntercomAvailableResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqGetIntercomAvailableResponse >& response);





    virtual void onSig_EventAcceptIntercomCallError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventAcceptIntercomCallError >& error) ;

    virtual void onSig_EventAcceptIntercomCallSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventAcceptIntercomCallSignal >& signal) ;




    virtual void onSig_EventCancelIntercomCallError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventCancelIntercomCallError >& error) ;

    virtual void onSig_EventCancelIntercomCallSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventCancelIntercomCallSignal >& signal) ;



    virtual void onSig_EventIntercomCallError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventIntercomCallError >& error) ;

    virtual void onSig_EventIntercomCallSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventIntercomCallSignal >& signal) ;







    virtual void onSig_EventPhoneStatusChangedError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventPhoneStatusChangedError >& error) ;

    virtual void onSig_EventPhoneStatusChangedSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventPhoneStatusChangedSignal >& signal) ;




    virtual void onSig_EventSetVolumeError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventSetVolumeError >& error) ;

    virtual void onSig_EventSetVolumeSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventSetVolumeSignal >& signal) ;




    virtual void onSig_RspGetVersionError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetVersionError >& error) ;

    virtual void onSig_RspGetVersionSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetVersionSignal >& signal);




    virtual void onSig_RspGetVolumeError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetVolumeError >& error) ;

    virtual void onSig_RspGetVolumeSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetVolumeSignal >& signal) ;




    virtual void onSig_RspPhoneStatusError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspPhoneStatusError >& error) ;

    virtual void onSig_RspPhoneStatusSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspPhoneStatusSignal >& signal);

    virtual void onSig_RspGetIntercomAvailableError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetIntercomAvailableError >& error) ;

    virtual void onSig_RspGetIntercomAvailableSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_RspGetIntercomAvailableSignal >& signal) ;


    virtual void onSig_EventIntercomAvailableError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventIntercomAvailableError >& error) ;

    virtual void onSig_EventIntercomAvailableSignal(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< Sig_EventIntercomAvailableSignal >& signal) ;


    //  virtual void onReqPhoneStatusResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqPhoneStatusResponse >& response);

    //virtual void onReqACKEventHandshakeError(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqACKEventHandshakeError >& error) ;

    // virtual void onReqACKEventHandshakeResponse(const ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy >& proxy, const ::boost::shared_ptr< ReqACKEventHandshakeResponse >& response);

    bool makeOutGoingCall  ( int32_t PhoneNo );

    bool CallAction  ( eCallAction Action );

    bool getAvailabilityStatus ();

    std::string getAmpIpAddress ()
    {
        return     AmpIpAddress      ;
    }

    void setPhoneNumber (  int32_t PhoneNo_ )
    {
        CurrentPhoneNo = PhoneNo_;
    }

    int32_t getPhoneNumber ()
    {
        return CurrentPhoneNo;
    }

    //request to get the phonestatus
    bool getPhoneStatus ();

    std::string getVersionInfo ()
    {
        return version_info;
    }

    bool writeToErrorMemory ( const std::string& error );

private :

    int32_t CurrentPhoneNo = 0;

    tclEntityInfo *m_pEntityInfo;

    bool     m_bParseState;

    void registerInterested ();

    bool initializeXMLParser ();

    std::string AmpIpAddress = "";

    std::string version_info = "";

    bool setVersionInfo ( std::string version_info_ )
    {
        version_info = version_info_;
        return true;
    }


    ::boost::shared_ptr< NanoMsgIntercomInterfaceProxy > nanoMsgIntercomInterfaceProxy_;

    static IntercomNanoMessageClientHandler* mIntercomNanoMessageClientHandler;

    bool checkStBit (  unsigned char byte, int index   )
    {
        return ( ( byte &  (  1 << ( index  ) ) ) != 0 );
    }

    uint8_t getOutGoingPhoneNo ()
    {
        return outGoingPhoneNo;
    }

    void setOutGoingPhoneNo ( uint8_t PhoneNo )
    {
        outGoingPhoneNo = PhoneNo;
    }



    IntercomService* mIntercomService = nullptr;

    uint8_t outGoingPhoneNo = 0;

};

}


#endif // INTERCOM_CLIENT_HANDLER_NN_MSG_H
