/****************************************************************************
* Copyright (C) Robert Bosch Car Multimedia GmbH, 2017
* This software is property of Robert Bosch GmbH. Unauthorized
* duplication and disclosure to third parties is prohibited.
*
* FILE                  : IntercomComponent.h
* COMPONENT Name        : Intercom
* DESCRIPTION           : DBus Server for Intercom Audio Services.
* AUTHOR                : Dhanya Elza
* Date                  : 24.07.2018
* Revision History      : 0.1
* Date 23.08.2017       : Initial version
****************************************************************************/



/*****************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------*/

/*****************************************************************
| includes
|----------------------------------------------------------------*/
#if !defined(INTERCOM_COMPONENT_H)
#define INTERCOM_COMPONENT_H

#include "asf/core/BaseComponent.h"
#include "SPM_CORE_FIProxy.h"
#include "Trace/IntercomApp_Trace.h"
#include "IntercomService.h"
#include "IntercomAudioClientHandler.h"
#include "midw_streamrouter_fi.h"
#include "midw_streamrouter_fiProxy.h"
#include "lcmdbusclient_main_fiProxy.h"
#include "IntercomConstantTypes.h"





using namespace ::asf::core;

//using namespace SPM_CORE_FI;

namespace IntercomApp {

//class IntercomNanoMessageClientHandler;

class IntercomComponent : public BaseComponent , ServiceAvailableIF,  SPM_CORE_FI::OnOffTriggerCallbackIF,::lcmdbusclient_main_fi::SubsystemerrorStatusCallbackIF
{
public:
   //Constructor
   IntercomComponent ( );

   //Destructor
   virtual ~IntercomComponent ( );

   IntercomAudioClientHandler* m_pIntercomAudioClientHandler;
   
   static IntercomComponent* getInstance ()
   {
	   return m_pIntercomComponent;
   }
   
   InterComAudioProcessing* m_InterComAudioProcessing;
   IntercomService* m_pIntercomService;
   //IntercomNanoMessageClientHandler* m_IntercomNanoMessageClientHandler;
   
   void onAvailable ( const ::boost::shared_ptr< ::asf::core::Proxy >& proxy , const ServiceStateChange& stateChange );
   
   void startNanoMessageServer();
   
   void onUnavailable(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy,
   const ServiceStateChange& stateChange);
   
   
     void onOnOffTriggerError(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SPM_CORE_FI::OnOffTriggerError >& /*error*/) {}
		 
      void onOnOffTriggerResult(const ::boost::shared_ptr< SPM_CORE_FI::SPM_CORE_FIProxy >& /*proxy*/, const ::boost::shared_ptr< SPM_CORE_FI::OnOffTriggerResult >& /*result*/) {}
	  
	  void onSubsystemerrorStatusError(const ::boost::shared_ptr< ::lcmdbusclient_main_fi::Lcmdbusclient_main_fiProxy >& proxy, const ::boost::shared_ptr< ::lcmdbusclient_main_fi::SubsystemerrorStatusError >& error);
	  
      void onSubsystemerrorStatusStatus(const ::boost::shared_ptr< ::lcmdbusclient_main_fi::Lcmdbusclient_main_fiProxy >& proxy, const ::boost::shared_ptr< ::lcmdbusclient_main_fi::SubsystemerrorStatusStatus >& status);
   
   
   	void onOffTriggerRequest ( bool status );
	
	void setLowVoltageErrorStatus ( bool status )
	{
		bLowVoltageErrorStatus = status;
	}
	
	bool getLowVoltageErrorStatus ()
	{
		return bLowVoltageErrorStatus;
	}
	
	bool CheckVoltErrorStatus ( uint16_t errorBits, eVoltageError VoltageError  );
	
	 inline bool isMyLCMDBusClientProxy(const ::boost::shared_ptr< ::asf::core::Proxy >& proxy) const
      {
         return (((NULL != _lcmDBusClientProxy.get()) && (_lcmDBusClientProxy == proxy)) ? true : false);
      }

    

private:

          ::boost::shared_ptr< Midw_streamrouter_fiProxy > mStreamRouterProxy ;
		  ::boost::shared_ptr< ::SPM_CORE_FI::SPM_CORE_FIProxy > _spmProxy;
		  ::boost::shared_ptr< ::lcmdbusclient_main_fi::Lcmdbusclient_main_fiProxy > _lcmDBusClientProxy;
		  act_t _regIdSubsystemerrorStatusUpdate;
		  static IntercomComponent* m_pIntercomComponent ;
		  bool bLowVoltageErrorStatus = false;

};
}

#endif // INTERCOM_COMPONENT_H
