/****************************************************************************
/*****************************************************************************
* FILE 			: IntercomNanoMessageClientHandler.h
*
* BRIEF			: Hand-crafted code
*
* SW-COMPONENT 	:
*
* DESCRIPTION 	:
*
*
* AUTHOR 		: Monojit Chatterjee (CM/ECG5)
*
* COPYRIGHT 	: (c) Robert Bosch Car Multimedia GmbH
*
* HISTORY 		: 02/02/2020     Initial version
*
****************************************************************************/
#include <IntercomComponent.h>
#include "AudioRouting.h"
#include "ARLService/AhlApp.h"
#include "IntercomAudioClientHandler.h"
#include "Trace/IntercomApp_Trace.h"


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS 		  TR_CLASS_INTERCOM_ARL
#define ETG_I_TRACE_CHANNEL               TR_TTFIS_INTERCOM
#define ETG_I_TTFIS_CMD_PREFIX            "INTERCOM_ARL_"
#define ETG_I_FILE_PREFIX 				  IntercomApp::AudioRouting::
#include "trcGenProj/Header/AudioRouting.cpp.trc.h"
#endif

#define RTP_RECEIVE_CAPS

DLT_IMPORT_CONTEXT (INTERCOM_AUDIO_HANDLER);
namespace IntercomApp
{

AudioRouting* AudioRouting::m_poAudioRouting = NULL;


/*!
 *
 * \brief   Constructor
 *
 * \author  Xunjin Su (CM/ESW21-CN)
 *
 * \date    2016/04/27
 */
AudioRouting::AudioRouting(ahl_tclBaseOneThreadApp* ahlApp): arl_tclISource_ASF(ahlApp), m_InterComAudioProcessing(NULL)
{
    ETG_I_REGISTER_FILE();
    ETG_TRACE_USR4(("AudioRouting::AudioRouting() entered."));
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("Constructor of AudioRouting"));
    DLT_REGISTER_INJECTION_CALLBACK(INTERCOM_AUDIO_HANDLER, 4098 , AudioRouting::injection_callback );

    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bSetSourceAvailability"));

    m_InterComAudioProcessing = InterComAudioProcessing::createInstance();

    mIntercomService = IntercomService::createInstance();

    //ETG_I_REGISTER_FILE();

    m_poAudioRouting = this;
    _bChannelBlocked = false;
    _bAudioChannelStatus = false;
    m_isChannelClosedByWrapper = false;
    mIntercomService = NULL;



}

/*!
 *
 * \brief   Destructor
 *
 * \author  Xunjin Su (CM/ESW21-CN)
 *
 * \date    2016/04/27
 */
AudioRouting::~AudioRouting()
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("Destructor of AudioRouting"));

    m_poAudioRouting = NULL;
    mIntercomService = NULL;
    m_isChannelClosedByWrapper = false;
}

/*!
*
* \brief   Get the instance of AudioRouting.
*
* \retval  AudioRouting*: The pointer of the AudioRouting.
*
* \author  Xunjin Su (CM/ESW21-CN)
*
* \date    2016/04/27
*/
AudioRouting* AudioRouting::poGetAudioRoutingInstance()
{
    return m_poAudioRouting;
}

/*!
*
* \brief   Initial the DBUS service pointer for communicating with external third party navigation.
*
* \param   [pDbusService]       : (IN)  The pointer of ThirdPartyNavigationExtService.
*
* \retval  tVoid: None
*
* \author  Xunjin Su (CM/ESW21-CN)
*
* \date    14/6/2016
*/
void AudioRouting::vInitDBUSServicePointer(IntercomService* pDbusService)
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("vInitDBUSServicePointer"));
    mIntercomService = pDbusService;

    //


}

//tBool bSetSourceAvailability(arl_tenSrcAvailability srcAvailability, arl_tenAvailabilityReason availabilityReason, arl_tenSource enSource, tU16 u16SubSource )
//{
//DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bSetSourceAvailability entered"));
//}

int AudioRouting::injection_callback(uint32_t service_id, void *data, uint32_t length)
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("injection_callback of vSetIntercomRouteRequest"));
    bool* info = (bool*)  data;
    ETG_TRACE_USR4(("AudioRouting::injection_callback() entered: "));
    AudioRouting *poAudioRoutingTest = AudioRouting::poGetAudioRoutingInstance();

    InterComAudioProcessing* m_InterComAudioProcessing_test = InterComAudioProcessing::createInstance();
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("injection_callback") , DLT_BOOL (*info) );

    if ( service_id == 4098 )
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("service id intercom audioHandler") );

    if ( *info == true )
    {
        ETG_TRACE_USR4(("AudioRouting::injection_callback() setAudioRouteRequest: data audioprocessing startrtp audio"));
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("AudioRouting::injection_callback() sending Incoming singnal to HMI") );
        IntercomService::createInstance()->sendIncomingCall ( 3 );

    }
    else
    {
        ETG_TRACE_USR4(("AudioRouting::injection_callback() setAudioRouteRequest: data audioprocessing stoprtp audio"));
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("AudioRouting::injection_callback() setAudioRouteRequest: data audioprocessing stoprtp audio") );


        m_InterComAudioProcessing_test->stopRTPAudio();
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("AudioRouting::injection_callback() setAudioRouteRequest: data audioprocessing stoprtp audio 11") );

    }
	
	return 0;

}

/*!
*
* \brief   Requests a new audio route for navigation announcement as
*          long as there is no currently open.(without timer)
*
* \param   [bOpenChannel]:    (IN)  Indicates if channel should be opened.
* \param   [TTSText] :        (IN)  Navigation voice text.
*
* \retval  tVoid: None
*
* \author  Xunjin Su (CM/ESW21-CN)
*
* \date    2016/08/29
*/
void AudioRouting::vSetIntercomRouteRequest(bool bOpenChannel)
{
    ETG_TRACE_USR4(("AudioRouting::vSetIntercomRouteRequest() entered"));
    //bSetAudioRouteRequest(ARL_SRC_INTERCOM, ARL_EN_ISRC_ACT_ON);
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("AudioRouting of vSetIntercomRouteRequest"));

}

/*!
* \brief   CALLED BY AUDIO-ROUTING-LIB:
*          Application specific function on Source Activity start.
*
* \param   enSrcNum:  (I) Source Number.
* \param   SubSource: (I) Sub source ID (deviceID)
* \param   rfcoSrcActivity: (I) Source Activity
*
* \retval  tBool: TRUE, if source activity was successful, FALSE otherwise
*
* \date    2016/04/27
*
* \author  Su Xunjin(CM/ESW21)
*/
tBool AudioRouting::bOnSrcActivity(arl_tenSource enSrcNum,  tU16 /*SubSource*/, const arl_tSrcActivity& rfcoSrcActivity)
{
    ETG_TRACE_USR4(("AudioRouting::bOnSrcActivity() entered: enSrcNum=%u.", enSrcNum));
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bOnSrcActivity"));

    if ( ARL_SRC_INTERCOM == enSrcNum )
    {
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bOnSrcActivity ARL_SRC_INTERCOM"));
        if (  rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_ON ) 
        {

            vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_ON);
			
			DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("vSourceActivityResult ARL_EN_ISRC_ACT_ON "));
			
			if ( !this->getAudioChannelStatus () )
			{
				
				if ( m_InterComAudioProcessing->launchPipeline() )
					DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("vSourceActivityResult and launching pipelines success"));

				this->setAudioChannelStatus ( true ) ;

				DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("Sending AudioAllocation Status ON to HMI"));
				IntercomService::createInstance()->sendEventAudioAllocationStatusSignal ( (uint8 )this->getAudioChannelStatus () );
			}





        }
        else
        {
            m_InterComAudioProcessing->stopRTPAudio();
			DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("vSourceActivityResult ARL_EN_ISRC_ACT_OFF "));
            vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_OFF);
            this->setAudioChannelStatus ( false ) ;
            
			IntercomComponent::getInstance()->onOffTriggerRequest( false );
	        
			DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("Sending AudioAllocation Status OFF to HMI"));
			IntercomService::createInstance()->sendEventAudioAllocationStatusSignal ( (uint8 )getAudioChannelStatus () );
            IntercomNanoMessageClientHandler::createInstance ( )->setPhoneNumber ( 0 );



            DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("stopRTPAudio and clearing gstreamer pipeline"));
        }
    }

    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("Constructor of InterComAudioProcessing"));




    return true;
}

/*!
* \brief   CALLED BY AUDIO-ROUTING-LIB:
*          Application specific function after Allocate is processed.
*
* \param   [enSrcNum]:  (I) Source Number.
* \param   [rfcoAllocRoute]: (I) Reference to Allocate route result
*
* \retval  tBool: TRUE, if Application performed operations successfully,
*          FALSE otherwise
*
* \date    2016/04/27
*
* \author  Su Xunjin(CM/ESW21)
*/
tBool AudioRouting::bOnAllocate(arl_tenSource enSrcNum/*enSrcNum*/, const arl_tAllocRouteResult& vAllocRouteResult/*rfcoAllocRoute*/)
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bOnAllocate"));
    //ETG_TRACE_USR4(("AudioRouting::bOnAllocate():enter."));

    if ( ARL_SRC_INTERCOM == enSrcNum )
    {
        DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bOnAllocated for ARL_SRC_INTERCOM"));
    }

    return TRUE;
}

/*!
* \brief   CALLED BY AUDIO-ROUTING-LIB:
*          Application specific function after DeAllocate is processed.
*
* \param   enSrcNum:  (I) Source Number.
*
* \retval  tBool: TRUE, if Application performed operations successfully,
*                 FALSE otherwise
*
* \date    2016/04/27
*
* \author  Su Xunjin(CM/ESW21)
*/
tBool AudioRouting::bOnDeAllocate(arl_tenSource /*enSrcNum*/)
{
//	ETG_TRACE_USR4(("AudioRouting::bOnDeAllocate():enter."));
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bOnDeAllocate"));

    return TRUE;
}

/*!
* \brief   CALLED BY AUDIO-ROUTING-LIB:
*          Application specific function on mute start.
*
* \param   [enSrcNum]:   (I) Source Number.
* \param   [muteState]:  (I) Source Number.
*
* \retval  tBool: TRUE, if Application performed operations successfully,
*                 FALSE otherwise
*
* \date    2016/04/27
*
* \author  Su Xunjin(CM/ESW21)
*/
tBool AudioRouting::bOnMuteState(arl_tenSource /*enSrcNum*/, arl_tenMuteState muteState)
{
    //ETG_TRACE_USR4(("AudioRouting::bOnMuteState():muteState=%u.", muteState));
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bOnMuteState"));

    switch (muteState)
    {
    case ARL_EN_MUTESTATE_DEMUTE:
    {
        //	ETG_TRACE_USR4(("bOnMuteState():ARL_EN_MUTESTATE_DEMUTE"));
        break;
    }
    case ARL_EN_MUTESTATE_MUTE:
    {
        //	ETG_TRACE_USR4(("bOnMuteState():ARL_EN_MUTESTATE_MUTE"));
        break;
    }
    case ARL_EN_MUTESTATE_DEMUTE_RUNNING:
    {
        //ETG_TRACE_USR4(("bOnMuteState():ARL_EN_MUTESTATE_DEMUTE_RUNNING"));
        break;
    }
    default:
        //ETG_TRACE_USR4(("bOnMuteState():Invalid mute state"));
        break;
    }

    return TRUE;
}

void AudioRouting::vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState)
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("vOnNewAppStateNotify"), DLT_UINT(u32OldAppState), DLT_UINT(u32AppState));
    //	DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("Constructor of InterComAudioProcessing "));
    vSetSrcAvailable(true);
    mIntercomService->sendConfigError ( No_ERROR_CONFIG );
    mIntercomService->sendNanoMessageError ( No_ERROR_NANOMESSAGE ) ;
    IntercomService::createInstance()->sendIntercomServiceAvailabilitySignal();

    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("sendIntercomServiceAvailabilitySignal  sent to HMI "));


}

/*!
*
* \brief   This method is used to inform the navigation voice result.
*
* \param   [u8NaviVoiceStatus] : (IN)  u8NaviVoiceStatus
*
* \retval  tVoid: None
*
* \author  Xunjin Su (CM/ESW21-CN)
*
* \date    14/6/2016
*/
void AudioRouting::InformIntercomRouteStatus(const uint8 u8IntercomRouteStatus)
{
//	ETG_TRACE_USR4(("InformIntercomRouteStatus: u8IntercomRouteStatus=%u.", u8IntercomRouteStatus));
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("InformIntercomRouteStatus"));

    if (NULL != mIntercomService)
    {
        mIntercomService->vUpdateIntercomRouteStatus(u8IntercomRouteStatus);
    }
    else
    {
        //ETG_TRACE_USR4(("InformIntercomRouteStatus: m_poIntercomService is NULL."));
    }
}

/*!
*
* \brief   This method is used to notify the activity off result to ARL.
*
* \param   [None] : (IN)  None
*
* \retval  tVoid: None
*
* \author  Xunjin Su (CM/ESW21-CN)
*
* \date    24/5/2017
*/
void AudioRouting::vNotifyActivityOffResult()
{
    DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("vNotifyActivityOffResult"));
    vSourceActivityResult(ARL_SRC_NAVI, ARL_EN_ISRC_ACT_OFF);
}

/*!
*
* \brief   Request a new audio route for navigation announcement via TTFis command.
*
* \param   [bOpenChannel] : (IN)Indicates if channel should be opened.
*
* \retval  tVoid: None
*
* \author  Xunjin Su (CM/ESW21-CN)
*
* \date    2016/5/13
*/
//ETG_I_CMD_DEFINE((TraceCmd_SetIntercomRouteRequest, "TraceCmd_SetNaviSpeechRequest %u", bool))
void AudioRouting::TraceCmd_SetIntercomRouteRequest(bool bOpenChannel)
{
    // ETG_TRACE_USR4(("TraceCmd_SetIntercomRouteRequest: = %u", bOpenChannel));

    AudioRouting *poAudioRoutingTest = AudioRouting::poGetAudioRoutingInstance();
    if (NULL == poAudioRoutingTest)
    {
        //	ETG_TRACE_USR4(("poAudioRoutingTest = NULL."));
        return;
    }

    if (1 == bOpenChannel)
    {
        poAudioRoutingTest->vSetIntercomRouteRequest(true);
    }
    else if (0 == bOpenChannel)
    {
        poAudioRoutingTest->vSetIntercomRouteRequest(false);
    }
    else
    {
        //ETG_TRACE_USR4(("TraceCmd_SetIntercomRouteRequest: do nothing."));
    }
}

tBool AudioRouting::bOnAudioRouteRequestReject(arl_tenSource enSource, tU16 SubSource)
{
	tBool status = false;
	if ( ARL_SRC_INTERCOM == enSource )
    {
		this->setAudioChannelStatus ( false ) ;
		DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("bOnAudioRouteRequestReject"));
		DLT_LOG(INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING("Sending AudioAllocation status false "));
		IntercomComponent::getInstance()->onOffTriggerRequest( false );
	    DLT_LOG( INTERCOM_AUDIO_HANDLER, DLT_LOG_INFO, DLT_CSTRING(" onOffTriggerRequest SWITCH OFF request "));
		IntercomService::createInstance()->sendEventAudioAllocationStatusSignal ( (uint8 )getAudioChannelStatus () );	
		status = true;
		
	}
	
	return status;
	
}

}
