/**************************************************************************//**
                                                                            * \file     clServerMethod.h
                                                                            *
                                                                            *           See .cpp file for description.
                                                                            *
                                                                            * \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
                                                                            ******************************************************************************/
#ifndef clMethodServer_h
#define clMethodServer_h


#include "clFunction.h"
#include <vector>

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "fi_msgfw_if.h"


class clServerMethodObserver;


class clServerMethod: public clFunction
{
public:
    virtual ~clServerMethod();
    clServerMethod(tU16 u16FunctionID, ahl_tclBaseOneThreadService* poCCAhandler);
    virtual tVoid vHandleMessage(amt_tclServiceData* poInMsg);
    tVoid vRegisterObserver(clServerMethodObserver* poObserver);
    tVoid vSendMethodResult(fi_tclTypeBase& oOutData);
    tVoid vSendErrMessage(tU16 u16ErrorCode);
    tU16 u16GetCmdCtr() const;

protected:
    virtual tVoid vMethodStart(amt_tclServiceData* poInMsg) = 0;
    tVoid vSendMethodResult();
    tVoid vNotifyObservers();

private:
    tU16 m_u16DestAppID;
    tU16 m_u16RegisterID;
    tU16 m_u16CmdCtr;
    tVoid vSaveResponseParameters(amt_tclServiceData* poInMessage);

    std::vector<clServerMethodObserver*> m_observers;
};


#endif
