/**************************************************************************//**
* \file     clServerMethod.cpp
*
*           Base class for SDS server method implementations.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "clServerMethod.h"
#include "clServerMethodObserver.h"
//#include "SdsHmi_Trace.h"

/*#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define //ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCA_FW
#include "trcGenProj/Header/clServerMethod.cpp.trc.h"
#endif*/


/**************************************************************************//**
* Destructor
******************************************************************************/
clServerMethod::~clServerMethod()
{
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clServerMethod::clServerMethod(tU16 u16FunctionID, ahl_tclBaseOneThreadService* poCCAhandler)
   : clFunction(u16FunctionID, poCCAhandler)
   , m_u16DestAppID(0)
   , m_u16RegisterID(0)
   , m_u16CmdCtr(0)
{
}


/**************************************************************************//**
* Performs opcode check for incoming message. Delegates message handling to
* derived class.
******************************************************************************/
tVoid clServerMethod::vHandleMessage(amt_tclServiceData* poInMsg)
{
   //ETG_TRACE_USR1(("rx appid=%04x function=%04x regid=%d opcode=%d cmdctr=%d ", poInMsg->u16GetSourceAppID(), poInMsg->u16GetFunctionID(), poInMsg->u16GetRegisterID(), poInMsg->u8GetOpCode(), poInMsg->u16GetCmdCounter()));
   switch (poInMsg->u8GetOpCode())
   {
      case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
         vSaveResponseParameters(poInMsg);
         vMethodStart(poInMsg);
         break;

      default:
         break;
   }
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerMethod::vSaveResponseParameters(amt_tclServiceData* poInMessage)
{
   m_u16DestAppID = poInMessage->u16GetSourceAppID();
   m_u16RegisterID = poInMessage->u16GetRegisterID();
   m_u16CmdCtr = poInMessage->u16GetCmdCounter();
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerMethod::vSendMethodResult()
{
   vSendEmptyMessage(
      m_u16DestAppID,
      m_u16CmdCtr,
      m_u16RegisterID,
      u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerMethod::vSendMethodResult(fi_tclTypeBase& oOutData)
{
   vSendMessage(
      m_u16DestAppID,
      m_u16CmdCtr,
      m_u16RegisterID,
      oOutData,
      u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_METHODRESULT);
}


/***********************************************************************//**
*
***************************************************************************/
tVoid clServerMethod::vSendErrMessage(tU16 u16ErrorCode)
{
   clFunction::vSendErrorMessage(
      m_u16DestAppID,
      m_u16CmdCtr,
      m_u16RegisterID,
      u16ErrorCode);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerMethod::vRegisterObserver(clServerMethodObserver* poObserver)
{
   if (poObserver != NULL)
   {
      m_observers.push_back(poObserver);
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clServerMethod::vNotifyObservers()
{
   std::vector<clServerMethodObserver*>::iterator iter = m_observers.begin();
   while (iter != m_observers.end())
   {
      if (*iter != NULL)
      {
         (*iter)->vMethodStart(u16GetFunctionID());
      }
      iter++;
   }
}


/**************************************************************************//**
*
******************************************************************************/
tU16 clServerMethod::u16GetCmdCtr() const
{
   return m_u16CmdCtr;
}
