/**************************************************************************//**
* \file     clFunction.cpp
*
*           Base class for CCA functions.
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#include "clFunction.h"
//#include "SdsAdapter_Trace.h"

#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#include "fi_msgfw_if.h"

#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_CCA_FW
#include "trcGenProj/Header/clFunction.cpp.trc.h"
#endif


/**************************************************************************//**
* Destructor
******************************************************************************/
clFunction::~clFunction()
{
   m_poCCAhandler = NULL;
}


/**************************************************************************//**
* Constructor
******************************************************************************/
clFunction::clFunction(tU16 u16FunctionID, ahl_tclBaseOneThreadService* poCCAhandler)
   :  m_poCCAhandler(poCCAhandler),
      m_u16FunctionID(u16FunctionID)
{
}


/**************************************************************************//**
*
******************************************************************************/
tU16 clFunction::u16GetFunctionID(tVoid)
{
   return m_u16FunctionID;
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clFunction::vSendMessage(tU16 u16DestAppID,
                               tU16 u16CmdCtr,
                               tU16 u16RegisterId,
                               fi_tclTypeBase& oOutData,
                               tU16 u16Fid,
                               tU8 u8OpCode)
{
   fi_tclVisitorMessage oOutVisitorMsg(oOutData, getMajorVersion());

   /* Set the CCA message information */
   oOutVisitorMsg.vInitServiceData(
      m_poCCAhandler->u16GetAppID(),     /* Source app-ID */
      u16DestAppID,                      /* Dest. app-ID */
      AMT_C_U8_CCAMSG_STREAMTYPE_NODATA, /* stream type*/
      0,                                 /* stream counter*/
      u16RegisterId,                     /* Registry ID */
      u16CmdCtr,                         /* Command counter */
      m_poCCAhandler->u16GetServiceID(),
      u16Fid,                            /* Function-ID */
      u8OpCode,                          /* OpCode */
      0,                                 /* ACT */
      0,                                 /* Source sub-ID */
      0);                                /* Dest. sub-ID */

   //ETG_TRACE_USR1(("tx appid=%04x function=%04x regid=%d opcode=%d cmdctr=%d ", u16DestAppID, u16Fid, u16RegisterId, u8OpCode, u16CmdCtr));

   m_poCCAhandler->ePostMessage(&oOutVisitorMsg);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clFunction::vSendEmptyMessage(tU16 u16DestAppID,
                                    tU16 u16CmdCtr,
                                    tU16 u16RegisterID,
                                    tU16 u16Fid,
                                    tU8 u8Opcode)
{
   gm_tclEmptyMessage oOutMessage(
      m_poCCAhandler->u16GetAppID(),
      u16DestAppID,
      u16RegisterID,
      u16CmdCtr,
      m_poCCAhandler->u16GetServiceID(),
      u16Fid,
      u8Opcode);

   //ETG_TRACE_USR1(("tx appid=%04x function=%04x regid=%d opcode=%d cmdctr=%d ", u16DestAppID, u16Fid, u16RegisterID, u8Opcode, u16CmdCtr));
   m_poCCAhandler->ePostMessage(&oOutMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clFunction::vGetDataFromAmt(amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData)
{
   fi_tclVisitorMessage oInVisitorMsg(poFIMsg);
   if (oInVisitorMsg.s32GetData(oFIData, getMajorVersion()) == OSAL_ERROR)
   {
      //ETG_TRACE_ERR(("Error in clFunction::vGetDataFromAmt() for service 0x%x, function 0x%x", m_poCCAhandler->u16GetServiceID(), poFIMsg->u16GetFunctionID()));
   }
}


/**************************************************************************//**
*
******************************************************************************/
tVoid clFunction::vSendErrorMessage(tU16 u16DestAppID,
                                    tU16 u16CmdCtr,
                                    tU16 u16RegisterID,
                                    tU16 u16ErrorCode)
{
   gm_tclU16Message  oSendErrorMessage(
      m_poCCAhandler->u16GetAppID(),       // source app id
      u16DestAppID,
      u16RegisterID,
      u16CmdCtr,
      m_poCCAhandler->u16GetServiceID(),
      u16GetFunctionID(),
      AMT_C_U8_CCAMSG_OPCODE_ERROR);
   oSendErrorMessage.vSetWord(u16ErrorCode);
   m_poCCAhandler->ePostMessage(&oSendErrorMessage);
}


/**************************************************************************//**
*
******************************************************************************/
tU16 clFunction::getMajorVersion()
{
   tU16 major = 0;
   tU16 minor = 0;
   tU16 patch = 0;
   m_poCCAhandler->bGetServiceVersion(m_poCCAhandler->u16GetServiceID(), major, minor, patch);
   return major;
}
