/*!
*******************************************************************************
* \file              ihl_tclDevHandler.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library
*  - DESCRIPTION:    Device Handler - Exception safe Device handler
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 06.12.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IHL_TCLDEVHANDLER_H_
#define IHL_TCLDEVHANDLER_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#include "ihl_tclDirHandler.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace io {

/*! 
 * \class ihl_tclDevHandler 
 * \brief Exception safe device handler for performing device operations.
 *
 * This is based on design pattern \ref RAII "RAII"
 */

class ihl_tclDevHandler : public ihl_tclDirHandler
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/
 
   /***************************************************************************
   ** FUNCTION:  ihl_tclDevHandler::ihl_tclDevHandler(tCString szDevice)
   ***************************************************************************/
   /*!
    * \brief   Parameterized Constructor
    * \param   [szDevice]:  (->I) Device name (inclusive of root path)
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   explicit ihl_tclDevHandler(tCString szDevice);

   /***************************************************************************
   ** FUNCTION:  virtual ihl_tclDevHandler::~ihl_tclDevHandler()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ihl_tclDevHandler();
   
   /***************************************************************************
   ** FUNCTION:  virtual tU32 ihl_tclDevHandler::u32GetFreeSize()
   ***************************************************************************/
   /*!
    * \brief   Get the free size of the device.
    * \param   NONE
    * \retval  [tU32]: Available free size in the device.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tU32 u32GetFreeSize();

   /***************************************************************************
   ** FUNCTION:  virtual tU32 ihl_tclDevHandler::u32GetTotalSize()
   ***************************************************************************/
   /*!
    * \brief   Get the total size of the device.
    * \param   NONE
    * \retval  [tU32]: Available total size in the device.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tU32 u32GetTotalSize();

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:
   
   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclDevHandler::ihl_tclDevHandler()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \note    Default constructor is declared protected to disable default 
    *          construction.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclDevHandler();

   /***************************************************************************
   ** FUNCTION:  ihl_tclDevHandler::ihl_tclDevHandler(const ihl_tclDevHandler.)
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoDevHandler]: (I) Const reference to object to be copied
    * \retval  NONE
    * \note    Default copy constructor is declared protected to disable it. So 
    *          that any attempt to copy will be caught by the compiler.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclDevHandler(const ihl_tclDevHandler &rfcoDevHandler);

   /***************************************************************************
   ** FUNCTION:  ihl_tclDevHandler& ihl_tclDevHandler::operator=(const ..)
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoDevHandler]: (I) Const reference to object to be copied
    * \retval  [ihl_tclDevHandler&]: Reference to this pointer.
    * \note    Assignment operator is declared protected to disable it. So 
    *          that any attempt for assignment will be caught by the compiler.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclDevHandler& operator=(const ihl_tclDevHandler &rfcoDevHandler);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/
}; // class ihl_tclDevHandler : public ihl_tclDirHandler


/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/*! 
 * \typedef ihl_tclDevHandler ihl_tDevHandler
 * \brief Exception safe Device handler
 *
 * The objects of this type will be registered for stack unwinding.
 * 
 * \note If you leave a function by exception, only destructors of registered 
 * stack objects will be called. That is contrary to C++ exception handling 
 * where the destructors will be called automatically by a mechanism called 
 * stack unwinding.
 *
 * Ref: Howto Using the Blaupunkt STL, v1.0, by Wiedemann Frank(CM-AI/PJ-CF15)
 * 
 */

typedef ihl_tclDevHandler ihl_tDevHandler;

   }  // namespace io
}  // namespace ihl

#endif   // #ifndef IHL_TCLDEVHANDLER_H_

// <EOF>
