/*!
********************************************************************************
* \file              ihl_Trace.h
********************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library 
*  - DESCRIPTION:    Trace defines
*  - COPYRIGHT:      &copy; 2010 Robert Bosch GmbH, Hildesheim
********************************************************************************
* \date 16.11.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
*******************************************************************************/

#ifndef IHL_TRACE_H_
#define IHL_TRACE_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include <etrace_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

#define TR_COMP_IHL                 (TR_COMP_AUDIOPLAYER + 20)

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/*! 
 * \enum ihl_tenTraceClass
 * Trace Class Enumeration.
 */

typedef enum 
{
   TR_CLASS_IHL_LOOPBACK            =  TR_COMP_IHL + 0   ///< Enum value for trace command/input channel trace
   , TR_CLASS_IHL_TASK              =  TR_COMP_IHL + 1   ///< Enum value for Playback notification trace
   , TR_CLASS_IHL_FI_HELPER         =  TR_COMP_IHL + 2   ///< Enum value for FI helper trace 
   , TR_CLASS_IHL_FILTERGRAPH       =  TR_COMP_IHL + 3   ///< Enum value for FI helper trace 
   , TR_CLASS_IHL_XML_DB            =  TR_COMP_IHL + 4  ///< Enum value for XML Parser trace 
} ihl_tenTraceClass;

/*! 
 * \enum ihl_tenSuccess
 * Enumeration which defines success or failure. ;-)
 */
typedef enum
{
   IHL_EN_FAILURE     =  0
   , IHL_EN_SUCCESS   =  1
} ihl_tenSuccess;

#endif   // #ifndef IHL_TRACE_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
