/*!
*******************************************************************************
* \file              ihl_tclFIVisitorMsgExtractor.cpp
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library
*  - DESCRIPTION:    Interface Class - Performs Message extraction
*                    Service Data -> FI Visitor Message -> Fi Type Base (FI Msg)
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 15.09.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - New function to check the validity of the extracted message.
*
* \date 17.11.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

/******************************************************************************
| includes:
| 1)system- and project- includes
| 2)needed interfaces from external components
| 3)internal and external interfaces from this component
|----------------------------------------------------------------------------*/

#include "ihl_tclFIVisitorMsgExtractor.h"
#include "ihl_Trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_IHL_FI_HELPER
#include "trcGenProj/Header/ihl_tclFIVisitorMsgExtractor.cpp.trc.h"
#endif

/******************************************************************************
| defines and macros (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| variable definition (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function prototype (scope: module-local)
|----------------------------------------------------------------------------*/

/******************************************************************************
| function implementation (scope: external-interfaces)
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace fi_helpers {

/******************************************************************************
** FUNCTION:  ihl_tclFIVisitorMsgExtractor::ihl_tclFIVisitorMsgEx..
******************************************************************************/

ihl_tclFIVisitorMsgExtractor::ihl_tclFIVisitorMsgExtractor():m_bValid(FALSE)
{} // ihl_tclFIVisitorMsgExtractor::ihl_tclFIVisitorMsgExtractor()

/******************************************************************************
** FUNCTION:  ihl_tclFIVisitorMsgExtractor::~ihl_tclFIVisitorMsg..
******************************************************************************/

/*virtual*/
ihl_tclFIVisitorMsgExtractor::~ihl_tclFIVisitorMsgExtractor()
{} // ihl_tclFIVisitorMsgExtractor::~ihl_tclFIVisitorMsgExtractor()

/******************************************************************************
** FUNCTION:  tVoid ihl_tclFIVisitorMsgExtractor::vExtractVisitorMsg(..)
******************************************************************************/

tVoid ihl_tclFIVisitorMsgExtractor::vExtractVisitorMsg
(
   amt_tclServiceData &rfoServData
   , fi_tclTypeBase &rfoTypeBase
   , tU16 u16FiMajVer
)
{
   // Create Visitor message object for incoming message
   fi_tclVisitorMessage oInVisitorMsg(&rfoServData);

   ETG_TRACE_USR1(("Extracting msg - FID:%u, RegID:%u, ServiceId:%u, SrcAppId:%u, TargAppId:%u, FI Ver:%u"
                   , ETG_ENUM(ihl_FID, rfoServData.u16GetFunctionID())
                   , rfoServData.u16GetRegisterID(), rfoServData.u16GetServiceID()
                   , rfoServData.u16GetSourceAppID()
                   , rfoServData.u16GetTargetAppID(), u16FiMajVer));

   // Extract the data in FI class from Vistor class
   if (OSAL_ERROR == oInVisitorMsg.s32GetData(rfoTypeBase, u16FiMajVer))
   {
      // Error message.
      ETG_TRACE_ERR(("Failed to extract data from incoming message."));
   }  // if (OSAL_ERROR == oInVisitorMsg.s32GetData(rfoTypeBase, u16FiMajVer..
   else
   {
      m_bValid =  TRUE;
   }

}  // tVoid ihl_tclFIVisitorMsgExtractor::vExtractVisitorMsg(amt_tclServ..

/******************************************************************************
** FUNCTION:  tBool ihl_tclFIVisitorMsgExtractor::bIsValid() const
******************************************************************************/

tBool ihl_tclFIVisitorMsgExtractor::bIsValid() const
{
   return m_bValid;
}  // tBool ihl_tclFIVisitorMsgExtractor::bIsValid() const

   }  // namespace fi_helpers
}  // namespace ihl

///////////////////////////////////////////////////////////////////////////////

// <EOF>
