/*!
*******************************************************************************
* \file              ihl_tclXFiObjHandler.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library
*  - DESCRIPTION:    Template library for eXtended Fi (X-Fi) Object Handling
*                    Internally uses the concept of Executing around sequences.
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 17.11.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IHL_TCLXFIOBJHANDLER_H_
#define IHL_TCLXFIOBJHANDLER_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#include "ihl_tclFiObjHandler.h"
#include "ihl_tclFIVisitorMsgExtractor.h"

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace fi_helpers {

/*! 
 * \brief Template library for Fi Object Handling using Execute around seqs.
 *
 * C++ Pattern - Executing Around Sequences.
 * Pre- and Post-Sequence Actions - 
 * - Paired actions where a function is called before some statement sequence 
 * and a corresponding function afterwards are commonly associated with resource
 * acquisition and release
 * - Pre- and post-sequence actions are a common feature of block-scoped 
 * resource management e.g. allocate memory, use it, deallocate it and this 
 * programming cliche can be found time and time again across many programs.
 *
 * References:
 * - The Design and Evolution of C++, by Bjarne Stroustrup, Addison-Wesley
 * - Wrapping C++ Member Function Calls, by Bjarne Stroustrup, AT&T Labs - 
 * Research, Florham Park, New Jersey, USA
 * - Exceptional C++, by Herb Sutter, Addison-Wesley
 */

template <class ihl_tclGenericClass>
class ihl_tclXFiObjHandler : public ihl_tclFiObjHandler<ihl_tclGenericClass>
   , public ihl_tclFIVisitorMsgExtractor
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclXFiObjHandler::ihl_tclXFiObjHandler(amt_tc..)
   ***************************************************************************/
   /*!
    * \brief   Constructor
    * \param   [rfoServData]: (I) Reference to service data
    * \param   [u16FiMajVer]: (I) FI Major Version
    * \retval  NONE
    * \date 17.11.2010 \author  Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclXFiObjHandler(amt_tclServiceData &rfoServData
      , tU16 u16FiMajVer FI_DEFAULT_VERSION)
      : ihl_tclFiObjHandler<ihl_tclGenericClass>(), ihl_tclFIVisitorMsgExtractor()
   {
      // Extract the Fi visitor message.
      vExtractVisitorMsg(rfoServData, *this, u16FiMajVer);
   }  // ihl_tclXFiObjHandler(amt_tclServiceData &rfoServData)

   /***************************************************************************
   ** FUNCTION:  ihl_tclXFiObjHandler::~ihl_tclXFiObjHandler()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 17.11.2010 \author  Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ihl_tclXFiObjHandler(){};
   
   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:
   
   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclXFiObjHandler::ihl_tclXFiObjHandler()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \note    Default constructor is declared protected to disable default 
    *          construction.
    * \date 17.11.2010 \author  Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclXFiObjHandler();  // No definition exists.

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/
}; // class ihl_tclXFiObjHandler : public ihl_tclFiObjHandler<ipoda..

   }  // namespace fi_helpers
}  // namespace ihl

#endif   // #ifndef IHL_TCLXFIOBJHANDLER_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
