/*!
*******************************************************************************
* \file              ihl_tclFiString.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library 
*  - DESCRIPTION:    Extended Fi string class, with extended deep copy 
*                    capabilities.
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 06.12.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IHL_TCLFISTRING_H_
#define IHL_TCLFISTRING_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

#define MIDW_FI_S_IMPORT_INTERFACE_FI_TYPES
#include <midw_fi_if.h>

#define MOST_FI_S_IMPORT_INTERFACE_FI_TYPES
#include <most_fi_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace fi_helpers {


      namespace midw_fi {

/*! 
 * \brief Extended Fi class, Derived from FI class - midw_fi_tclString with 
 * extended capabilities like -
 * - Deep Copy FI strings
 * - Self destruction capabilities on going out of scope
 */

class ihl_tclFiString : public midw_fi_tclString
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /// Using the "Name injection" to enable the compiler's overload resolution 
   /// algorithm to see the base class methods.
   using midw_fi_tclString::operator!= ;
   using midw_fi_tclString::operator[] ;

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::ihl_tclFiString()
   ***************************************************************************/
   /*!
    * \brief   Constructor
    * \param   NONE
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString();

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::~ihl_tclFiString()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ihl_tclFiString();

   /***************************************************************************
   ***************************DEEP COPY INTERFACES*****************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::ihl_tclFiString(const ihl_tclFiString &c..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoFiString]: (I) Const reference to XFi object to be copied.
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString(const ihl_tclFiString &rfcoFiString);

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::ihl_tclFiString(const midw_fi_tclString &c..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoFiString]: (I) Const reference to FI object to be copied.
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   explicit ihl_tclFiString(const midw_fi_tclString &rfcoFiString);

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::ihl_tclFiString(tCString coszString)
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [coszString]: (->I) Reference to tCString object to be copied.
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   explicit ihl_tclFiString(tCString coszString);
   
   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator=(const ihl_tclF..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoFiString]: (->I) Const reference to XFi object to be copied.
    * \retval  [ihl_tclFiString&]: Reference to this pointer.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString& operator=(const ihl_tclFiString &rfcoFiString); 

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(const ihl_tc..
   ***************************************************************************/
   /*!
    * \brief   Assignment by Addition Operator
    * \param   [rfcoFiString]: (->I) Reference to Fi object to be concatenated.
    * \retval  [ihl_tclFiString&]: Reference to this pointer.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString& operator +=(const ihl_tclFiString &rfcoFiString);

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(const midw_tc..
   ***************************************************************************/
   /*!
    * \brief   Assignment by Addition Operator
    * \param   [rfcoFiString]: (->I) Reference to Fi object to be concatenated.
    * \retval  [ihl_tclFiString&]: Reference to this pointer.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString& operator +=(const midw_fi_tclString &rfcoFiString);

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(tCString coszS..
   ***************************************************************************/
   /*!
    * \brief   Assignment by Addition Operator
    * \param   [coszString]: (->I) Reference to const string to be concatenated.
    * \retval  [ihl_tclFiString&]: Reference to this pointer.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString& operator +=(tCString coszString);

   /***************************************************************************
   ** FUNCTION: tVoid ihl_tclFiString::vClone(midw_fi_tclString &rfoString..
   ***************************************************************************/
   /*!
    * \brief   Interface to extract string using Deep copy mechanism
    * \param   [rfoString]: (I) Reference to Fi String object to copy.
    * \retval  [NONE]
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vClone(midw_fi_tclString &rfoString) const;

   /***************************************************************************
   ** FUNCTION: tVoid ihl_tclFiString::vClone(tString szString) const
   ***************************************************************************/
   /*!
    * \brief   Interface to extract string using Deep copy mechanism
    * \param   [rfszString]: (I) Reference to String object to copy.
    * \retval  [NONE]
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vClone(tString &rfszString) const;

   /***************************************************************************
   ** FUNCTION: tVoid ihl_tclFiString::vClone(tCString szString) const
   ***************************************************************************/
   /*!
    * \brief   Interface to extract string using Deep copy mechanism
    * \param   [rfszString]: (I) Reference to String object to copy.
    * \retval  [NONE]
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vClone(tCString &rfszString) const;

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  tVoid ihl_tclFiString::vStringConCat(tCString coszString)
   ***************************************************************************/
   /*!
    * \brief   Interface to concatenate strings.
    * \param   [coszString]: (->I) Reference to tCString object to be 
    *          concatenated.
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vStringConCat(tCString coszString);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /// Using the "Name injection" to enable the compiler's overload resolution 
   /// algorithm to see the base class methods and making it private to control
   /// the scope.
   using midw_fi_tclString::operator+;
   using midw_fi_tclString::operator= ;

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/

}; // class ihl_tclFiString : public ihl_tclFiObjHandler<midw_fi_tclString>


/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/*! 
 * \typedef EXH_REG(ihl_tclFiString) ihl_tFiString
 * \brief Exception safe Fi String
 *
 * The objects of this type will be registered for stack unwinding.
 * 
 * \note If you leave a function by exception, only destructors of registered 
 * stack objects will be called. That is contrary to C++ exception handling 
 * where the destructors will be called automatically by a mechanism called 
 * stack unwinding.
 *
 * Ref: Howto Using the Blaupunkt STL, v1.0, by Wiedemann Frank(CM-AI/PJ-CF15)
 * 
 */

//typedef EXH_REG(ihl_tclFiString) ihl_tFiString;
typedef ihl_tclFiString ihl_tFileHandler;


      }  // namespace midw_fi

      namespace most_fi {

/*! 
 * \brief Extended Fi class, Derived from FI class - most_fi_tcl_String with 
 * extended capabilities like -
 * - Deep Copy FI strings
 * - Self destruction capabilities on going out of scope
 */

class ihl_tclFiString : public most_fi_tcl_String
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::ihl_tclFiString()
   ***************************************************************************/
   /*!
    * \brief   Constructor
    * \param   NONE
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString();

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::~ihl_tclFiString()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ihl_tclFiString();

   /***************************************************************************
   ***************************DEEP COPY INTERFACES*****************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::ihl_tclFiString(const ihl_tclFiString &c..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoFiString]: (I) Const reference to XFi object to be copied.
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString(const ihl_tclFiString &rfcoFiString);

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::ihl_tclFiString(const most_fi_tcl_String &c..
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [rfcoFiString]: (I) Const reference to FI object to be copied.
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   explicit ihl_tclFiString(const most_fi_tcl_String &rfcoFiString);

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString::ihl_tclFiString(tCString coszString)
   ***************************************************************************/
   /*!
    * \brief   Copy Constructor
    * \param   [coszString]: (->I) Reference to tCString object to be copied.
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   explicit ihl_tclFiString(tCString coszString);
   
   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator=(const ihl_tclF..
   ***************************************************************************/
   /*!
    * \brief   Assignment Operator
    * \param   [rfcoFiString]: (->I) Const reference to XFi object to be copied.
    * \retval  [ihl_tclFiString&]: Reference to this pointer.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString& operator=(const ihl_tclFiString &rfcoFiString); 

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(const ihl_tc..
   ***************************************************************************/
   /*!
    * \brief   Assignment by Addition Operator
    * \param   [rfcoFiString]: (->I) Reference to Fi object to be concatenated.
    * \retval  [ihl_tclFiString&]: Reference to this pointer.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString& operator +=(const ihl_tclFiString &rfcoFiString);

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(const midw_tc..
   ***************************************************************************/
   /*!
    * \brief   Assignment by Addition Operator
    * \param   [rfcoFiString]: (->I) Reference to Fi object to be concatenated.
    * \retval  [ihl_tclFiString&]: Reference to this pointer.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString& operator +=(const most_fi_tcl_String &rfcoFiString);

   /***************************************************************************
   ** FUNCTION:  ihl_tclFiString& ihl_tclFiString::operator +=(tCString coszS..
   ***************************************************************************/
   /*!
    * \brief   Assignment by Addition Operator
    * \param   [coszString]: (->I) Reference to const string to be concatenated.
    * \retval  [ihl_tclFiString&]: Reference to this pointer.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFiString& operator +=(tCString coszString);

   /***************************************************************************
   ** FUNCTION:  tBool ihl_tclFiString::operator !=(const most_fi_tcl_String ..
   ***************************************************************************/
   /*!
    * \brief   "Not Equal to" operator
    * \param   [rfcoFiString]: (I) Reference to const string to be compared.
    * \retval  [tBool]: TRUE, if  not equal. FALSE otherwise.
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tBool operator !=(const most_fi_tcl_String &rfcoFiString) const;

   /***************************************************************************
   ** FUNCTION: tVoid ihl_tclFiString::vClone(most_fi_tcl_String &rfoString..
   ***************************************************************************/
   /*!
    * \brief   Interface to extract string using Deep copy mechanism
    * \param   [rfoString]: (I) Reference to Fi String object to copy.
    * \retval  [NONE]
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vClone(most_fi_tcl_String &rfoString) const;

   /***************************************************************************
   ** FUNCTION: tVoid ihl_tclFiString::vClone(tString szString) const
   ***************************************************************************/
   /*!
    * \brief   Interface to extract string using Deep copy mechanism
    * \param   [rfszString]: (I) Reference to String object to copy.
    * \retval  [NONE]
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vClone(tString &rfszString) const;

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  tVoid ihl_tclFiString::vStringConCat(tCString coszString)
   ***************************************************************************/
   /*!
    * \brief   Interface to concatenate strings.
    * \param   [coszString]: (->I) Reference to tCString object to be 
    *          concatenated.
    * \retval  NONE
    * \date 06.12.2010 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual tVoid vStringConCat(tCString coszString);

   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/

   /// Using the "Name injection" to enable the compiler's overload resolution 
   /// algorithm to see the base class methods and making it private to control
   /// the scope.
   using most_fi_tcl_String::operator= ;

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/

}; // class ihl_tclFiString : public ihl_tclFiObjHandler<most_fi_tcl_String>


/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

/*! 
 * \typedef EXH_REG(ihl_tclFiString) ihl_tFiString
 * \brief Exception safe Fi String
 *
 * The objects of this type will be registered for stack unwinding.
 * 
 * \note If you leave a function by exception, only destructors of registered 
 * stack objects will be called. That is contrary to C++ exception handling 
 * where the destructors will be called automatically by a mechanism called 
 * stack unwinding.
 *
 * Ref: Howto Using the Blaupunkt STL, v1.0, by Wiedemann Frank(CM-AI/PJ-CF15)
 * 
 */

//typedef EXH_REG(ihl_tclFiString) ihl_tFiString;
typedef ihl_tclFiString ihl_tFileHandler;

      }  // namespace most_fi

   }  // namespace fi_helpers
}  // namespace ihl

#endif   // #ifndef ihl_TCLFISTRING_H_

// <EOF>
