/*!
*******************************************************************************
* \file              ihl_tclFIVisitorMsgExtractor.h
*******************************************************************************
*  - PROJECT:        GM Gen2
*  - SW-COMPONENT:   Infotainment Helper Library 
*  - DESCRIPTION:    Interface Class - Performs Message extraction
*                    Service Data -> FI Visitor Message -> Fi Type Base (FI Msg)
*  - COPYRIGHT:      &copy; 2010 Robert Bosch Car Multimedia Gmbh
*******************************************************************************
* \date 15.09.2011 \version 1.1 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* - New function to check the validity of the extracted message.
*
* \date 17.11.2010 \version 1.0 \author Pradeep Chand (CM-AI/PJ-GM55 RBEI)
* \bug No known bugs
******************************************************************************/

#ifndef IHL_TCLFIVISITORMSGEXTRACTOR_H_
#define IHL_TCLFIVISITORMSGEXTRACTOR_H_

/******************************************************************************
| includes of component-internal interfaces, if necessary
| (scope: component-local)
|----------------------------------------------------------------------------*/

// Includes to utilize the OSAL Interface
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include <osal_if.h>

// Includes to utilize the AMT Interfaces
#define AMT_S_IMPORT_INTERFACE_GENERIC
#include <amt_if.h>

// Includes for Fi Visitor Messages
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE  
#include <common_fi_if.h>

/******************************************************************************
| defines and macros (scope: global)
|----------------------------------------------------------------------------*/

/******************************************************************************
| typedefs (scope: global)
|----------------------------------------------------------------------------*/

namespace ihl {
   namespace fi_helpers {

/*! 
 * \brief Interface Class - Performs Message extraction
 * This is an interface class simialr to a Java Interface. Interface to 
 * extract incoming messages to appropriate FI message types.
 * This interface has to be derived for use in the derived class. 
 */

class ihl_tclFIVisitorMsgExtractor
{
public:

   /***************************************************************************
   *********************************PUBLIC*************************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  ihl_tclFIVisitorMsgExtractor::ihl_tclFIVisitorMsgExtractor()
   ***************************************************************************/
   /*!
    * \brief   Default Constructor
    * \param   NONE
    * \retval  NONE
    * \date 17.11.2010 \author  Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   ihl_tclFIVisitorMsgExtractor();

   /***************************************************************************
   ** FUNCTION:  ihl_tclFIVisitorMsgExtractor::~ihl_tclFIVisitorMsgExtractor()
   ***************************************************************************/
   /*!
    * \brief   Destructor
    * \param   NONE
    * \retval  NONE
    * \date 17.11.2010 \author  Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   virtual ~ihl_tclFIVisitorMsgExtractor();
 
   /***************************************************************************
   ***************************EXTERNAL INTERFACES here*************************
   ***************************************************************************/

   /***************************************************************************
   ** FUNCTION:  tVoid ihl_tclFIVisitorMsgExtractor::vExtractVisitorMsg(..)const
   ***************************************************************************/
   /*!
    * \brief   Interface to extract the visitor message
    * \param   [rfoServiceData]: (I) Reference to service data
    * \param   [rfoTypeBase]: (O) Reference to Fi Message type.
    * \param   [u16FiMajVer]: (I)   Fi Major Version
    * \retval  NONE
    * \date 17.11.2010 \author  Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tVoid vExtractVisitorMsg
   (
      amt_tclServiceData &rfoServiceData
      , fi_tclTypeBase &rfoTypeBase
      , tU16 u16FiMajVer FI_DEFAULT_VERSION
   );

   /***************************************************************************
   ** FUNCTION:  tBool ihl_tclFIVisitorMsgExtractor::bIsValid() const
   ***************************************************************************/
   /*!
    * \brief   Interface to check validity of the message.
    * \param   NONE
    * \retval  tBool, TRUE is message is valid, FALSE otherwise.
    * \date 15.09.2011 \author  Pradeep Chand (CM-AI/PJ-GM55 RBEI)
    **************************************************************************/
   tBool bIsValid() const;

   /***************************************************************************
   ****************************END OF PUBLIC***********************************
   ***************************************************************************/

protected:

   /***************************************************************************
   *******************************PROTECTED************************************
   ***************************************************************************/
   
   /***************************************************************************
   ****************************END OF PROTECTED********************************
   ***************************************************************************/

private:

   /***************************************************************************
   *********************************PRIVATE************************************
   ***************************************************************************/
   
   /// Message validity flag.
   tBool m_bValid;

   /***************************************************************************
   ****************************END OF PRIVATE**********************************
   ***************************************************************************/
}; // class ihl_tclFIVisitorMsgExtractor

   }  // namespace fi_helpers
}  // namespace ihl

#endif   // #ifndef IHL_TCLFIVISITORMSGEXTRACTOR_H_

////////////////////////////////////////////////////////////////////////////////
// <EOF>
