/************************************************************************
* FILE:         fc_mcan_tcu_datapool.h
* PROJECT:      
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION: datapool defines (NISSAN's ...)
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2014 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author              | Modification
* 17.04.15  | gjd5kor RBEI/ECV1   | initial version
*************************************************************************/

#ifndef _FC_USB_TCU_DP_H_
#define _FC_USB_TCU_DP_H_

struct TDatetime
{
	tU8     u8Hour;
    tU8     u8Minute;
    tU8     u8Seconds;
	tU8     u8Day;
    tU8     u8Month;
    tU8     u8Year;
	tS8 	s8TimeZone;
};
struct TDate
{
	tBool bIsValid;
	tU8     u8Day;
    tU8     u8Month;
    tU8     u8Year;
};

struct TNaviAbsolutePosition
{
	tS32 s32Lattitude;
	tS32 s32longitude;
};
struct TDPMonthlyProbeData
{
  TDate   TStartDate;
  TDate	TEndDate;
  tU32	u32FuelInjectionQty;
  tU16 	u16MileageCovered;
  tU16	u16FrequencyOf4000RPMCrossed;
  tU16	u16FrequencyOf6000RPMCrossed;
    
};

struct TDPLifeTimeProbeData
{
	tU32 u32DrivingTime;
	tU32 u32AmountOfFuel;
	tU32 u32MeleageCovered;
};

struct TDPTripData
{
	tU32 _u32FuelinjectionQuantity;
	tU32 _u32MileageCovered;
	tU16 _u16ImmidiateAccelarationTime;
	tU16 _u16WarmUpTime;
	TDatetime _TStartDateofTrip;
	TDatetime _TStopDateofTrip;
	TNaviAbsolutePosition _TStartPostionOfTrip;
	TNaviAbsolutePosition _TStopPositionOfTrip;
};
struct TRemoteSendingSize
{
	tU8 u8Tracking;
	tU8 u8Calculated;
};
struct TConfigurationHeader
{
	tU8  u8AnalysisCode;
	tU16 u16ConfigurationVersion;
	tU8 u8FunctionCode;
	TRemoteSendingSize _TRemoteSendingSize;
	tU16 u16MatsushitaCompression;
};
struct TNaviInformation
{
	tU8 u8Label;
	tU8 u8RemoteSendingFlag;
	tU8 u8StoreTrigger;
	tU8 u8StoreInterval;
	tU8 u8DataThinning;
	tU8 u8DataInterval;
};
struct TThreshold
{
	tU8 u8Type;
	tU8 u8Data;
};
struct TCalculatedInformation
{
	tU8 u8Label;
	tU8 u8RemoteSendingFlag;
	tU8 u8Threshold;
	TThreshold _Threshold1;
	TThreshold _Threshold2;
	TThreshold _Threshold3;
};
#endif // _FC_MCAN_TCU_DP_H_

