

/*****************************************************************************
* FILE:         speaud_ServiceSpeaudIf.cpp
* PROJECT:      G3G project
* SW-COMPONENT: fc_speech_audio
* Template:     ServiceIf.cpp.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  
*               Generated file
*               Do here service handler specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/



// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#define ET_TRACE_INFO_ON
#include "etrace_if.h"

// speaud_tclServiceSpeaudIfIncludes: user specific code start
// speaud_tclServiceSpeaudIfIncludes: user specific code end

#include "speaud_ServiceSpeaudIf.h"
#include "I_speaud_ServiceSpeaud.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SPEECH_AUDIO_SERVER_SPEAUD
#include "trcGenProj/Header/speaud_ServiceSpeaudIf.cpp.trc.h"
#endif

/******************************************************************************/
/*                                                                            */
/* METHODS                                                                    */
/*                                                                            */
/******************************************************************************/

/*******************************************************************************
*
* FUNCTION: speaud_tclServiceSpeaudIf::
*             speaud_tclServiceSpeaudIf(speaud_tclAppMain* poMainAppl)
*
* DESCRIPTION: Constructor.
*
*              Create an object of the base class
*              ahl_tclBaseOneThreadClientHandler with a pointer to this
*              application, the to be used service identifier and the service
*              version as parameters.
*
* PARAMETER: [IN] poMainAppl = Pointer to the object of this application.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclServiceSpeaudIf::speaud_tclServiceSpeaudIf(speaud_tclAppMain* poMainAppl) : 
Ispeaud_tclServiceSpeaudIf(poMainAppl)
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaudIf() entered."));
   _poServerRef = OSAL_NULL;

   // speaud_tclServiceSpeaudIfConstructor: user specific code start
   // speaud_tclServiceSpeaudIfConstructor: user specific code end

   //__PRPPERTY_PARAM_INIT__
}

/*******************************************************************************
*
* FUNCTION: speaud_tclServiceSpeaudIf::
*             ~speaud_tclServiceSpeaudIf(tVoid)
*
* DESCRIPTION: Destructor.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
speaud_tclServiceSpeaudIf::~speaud_tclServiceSpeaudIf(tVoid)
{
   ETG_TRACE_USR4(("~speaud_tclServiceSpeaudIf() entered."));
   _poServerRef = OSAL_NULL;
   
   // speaud_tclServiceSpeaudIfDestructor: user specific code start
   // speaud_tclServiceSpeaudIfDestructor: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaudIf::vGetReferences(tVoid)
*
* DESCRIPTION: Function to get all reference needed by this class.
* A reference should always be the Interface class of the object
* 
* Example how to get a reference:
*  Declaration in 'speaud_ServiceSpeaudIf.h':
*     Add forward declaration:
*         class Ifc_speech_audio_tclObject2Get;
*
*     Add declaration of object reference:
*         Ifc_speech_audio_tclObject2Get*  pIObjRef;  
*        
*  Add this snippet to the vGetReferences() method:
*     pIObjRef = dynamic_cast<Ifc_speech_audio_tclObject2Get*>(_cpoMain->getHandler("Ifc_speech_audio_tclObject2Get"));
*     SPEAUD_NULL_POINTER_CHECK(pIObjRef);
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaudIf::vGetReferences(tVoid)
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaudIf::vGetReferences() entered."));

   _poServerRef = dynamic_cast<Ispeaud_tclServiceSpeaud*>(_cpoMain->getHandler("Ispeaud_tclServiceSpeaud"));

   SPEAUD_NULL_POINTER_CHECK(_poServerRef);

   _poServerRef->vSetCallbackIf(this);

   //set callback interface

   // speaud_tclServiceSpeaudIfvGetReferences: user specific code start
   // speaud_tclServiceSpeaudIfvGetReferences: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaudIf::vStartCommunication(tVoid)
*
* DESCRIPTION: Function to start all dynamic objects e.g. threads, ...
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaudIf::vStartCommunication(tVoid)
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaudIf::vStartCommunication() entered."));
   // speaud_tclServiceSpeaudIfvStartCommunication: user specific code start
   // speaud_tclServiceSpeaudIfvStartCommunication: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaudIf::vHandleMessage(TMsg* pMsg)
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaudIf::vHandleMessage(speaud_tclBaseIf::TMsg* pMsg)
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaudIf::vHandleMessage() entered %u -> data: %d.", ETG_CENUM(speaud_tclBaseIf::ECmdTypes , (tU32)pMsg->eCmd), pMsg->u.u32Data));
   // speaud_tclServiceSpeaudIfvHandleMessage: user specific code start
   // speaud_tclServiceSpeaudIfvHandleMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaudIf::vHandleTraceMessage()
*
* DESCRIPTION: Handle worker events.
*
* PARAMETER:   const tUChar* puchData
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaudIf::vHandleTraceMessage(const tUChar* puchData)
{
   SPEAUD_NULL_POINTER_CHECK(puchData);
   
   tU32 u32MsgCode = ((puchData[1]<<8) | puchData[2]);
   ETG_TRACE_USR4(("speaud_tclServiceSpeaudIf::vHandleTraceMessage(): trace command %d", u32MsgCode ));

   // speaud_tclServiceSpeaudIfvHandleTraceMessage: user specific code start
   // speaud_tclServiceSpeaudIfvHandleTraceMessage: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaudIf::vTraceInfo()
*
* DESCRIPTION: Trace information
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
*******************************************************************************/
tVoid speaud_tclServiceSpeaudIf::vTraceInfo()
{
   // speaud_tclServiceSpeaudIfvTraceInfo: user specific code start
   // speaud_tclServiceSpeaudIfvTraceInfo: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaudIf::vOnServiceAvailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become available.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceAvailable().
*******************************************************************************/
tVoid speaud_tclServiceSpeaudIf::onServiceAvailable()
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaudIf::onServiceAvailable() entered."));

   // speaud_tclServiceSpeaudIfvOnServiceAvailable: user specific code start
   // speaud_tclServiceSpeaudIfvOnServiceAvailable: user specific code end
}

/*******************************************************************************
*
* FUNCTION: tVoid speaud_tclServiceSpeaudIf::vOnServiceUnavailable()
*
* DESCRIPTION: This function is called by the CCA framework when the service
*              this client-handler has registered for has become unavailable.
*
* PARAMETER: None.
*
* RETURNVALUE: None.
*
********************************************************************************
* Overrides method ahl_tclBaseOneThreadClientHandler::vOnServiceUnavailable().
*******************************************************************************/
tVoid speaud_tclServiceSpeaudIf::onServiceUnavailable()
{
   ETG_TRACE_USR4(("speaud_tclServiceSpeaudIf::onServiceUnavailable() entered."));

   // speaud_tclServiceSpeaudIfvOnServiceUnavailable: user specific code start
   // speaud_tclServiceSpeaudIfvOnServiceUnavailable: user specific code end
}



tVoid speaud_tclServiceSpeaudIf::sendInternMsgStatus(speaud_fi_tcl_e8_SPEAUD_TEST eTest) {
    //just forward send request
    SPEAUD_NULL_POINTER_CHECK(_poServerRef);
    _poServerRef->sendInternMsgStatus(eTest);
}







// speaud_tclServiceSpeaudIfspeaud_ServiceSpeaudIf: user specific code start

// speaud_tclServiceSpeaudIfspeaud_ServiceSpeaudIf: user specific code end

//EOF
