/*****************************************************************************
* FILE:         I_speaud_ClientAcr.h
* PROJECT:      G3G project
* SW-COMPONENT: __APP_NAME__
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef _I_speaud_ClientAcr_H_
#define _I_speaud_ClientAcr_H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/
//Include FI interface of used service
#define CMB_FI_S_IMPORT_INTERFACE_CMB_ACRFI_STDVISITORS
#define CMB_FI_S_IMPORT_INTERFACE_CMB_ACRFI_FUNCTIONIDS
#include "cmb_fi_if.h"

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

//include base class
#include "speaud_AppMain.h"

// Ispeaud_tclClientAcr_Include: user specific code start
// Ispeaud_tclClientAcr_Include: user specific code end

class speaud_tclClientAcrCallbackIF;

class Ispeaud_tclClientAcr : public ahl_tclBaseOneThreadClientHandler, public speaud_tclBaseIf
{
public:
   Ispeaud_tclClientAcr(speaud_tclAppMain* poMainAppl, tU16 u16ServiceID, tU16 u16ServiceMajorVersion, tU16 u16ServiceMinorVersion, tU16 u16AppID):
		ahl_tclBaseOneThreadClientHandler(poMainAppl, u16ServiceID, u16ServiceMajorVersion, u16ServiceMinorVersion,u16AppID),
		speaud_tclBaseIf(poMainAppl) {;}
   virtual ~Ispeaud_tclClientAcr() {;}
   virtual const tChar* getIfName() const { return "Ispeaud_tclClientAcr"; };

   virtual tVoid vSetCallbackIf(speaud_tclClientAcrCallbackIF* poCallback) = 0;



   virtual tBool sendChannelRequestGet() = 0;
   virtual tVoid getChannelRequestStatus(cmb_fi_tcl_ChannelRequestStatusList& rChannelRequestStatusList) = 0;

   virtual tBool sendVoiceAdviceMStart(cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice) = 0;

// Ispeaud_tclClientAcrDeclarations: user specific code start
// Ispeaud_tclClientAcrDeclarations: user specific code end
};

#endif // _I_speaud_ClientAcr_H_


