/*****************************************************************************
* FILE:         speaud_ClientAcrIf.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_speech_audio
* Template:     ClientIf.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  CCA Clienthandler based on ahl_tclBaseOneThreadClientHandler
*
*               Generated file
*               Do here client specific implementation
*               Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end 
*              
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2016 Robert Bosch GmbH, Hildesheim
*****************************************************************************/

#ifndef __speaud_ClientAcrIf__IF__H_
#define __speaud_ClientAcrIf__IF__H_

/******************************************************************************/
/* INCLUDES                                                                   */
/******************************************************************************/

//include base class
#include "I_speaud_ClientAcrIf.h"
#include "speaud_AppMain.h"
#include "speaud_ClientAcrCallbackIf.h"

// speaud_tclClientAcrIf_Include: user specific code start
// speaud_tclClientAcrIf_Include: user specific code end

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/
class Ispeaud_tclClientAcr;

class speaud_tclClientAcrIf : public Ispeaud_tclClientAcrIf, public speaud_tclClientAcrCallbackIF
{
public:

   speaud_tclClientAcrIf(tVoid); 
   speaud_tclClientAcrIf(speaud_tclAppMain* poMainAppl);
   virtual ~speaud_tclClientAcrIf();

   virtual const tChar* getName() const { return "speaud_tclClientAcrIf"; };
   
   virtual tVoid vHandleMessage(speaud_tclBaseIf::TMsg* pMsg);
   virtual tVoid vHandleTraceMessage(const tUChar* puchData);
   virtual tVoid vGetReferences();
   virtual tVoid vStartCommunication();
   virtual tVoid vTraceInfo();

   /***************************************************************************
   * all public methods to send / getCurrentState.
   ***************************************************************************/



   virtual tBool sendChannelRequestGet(){
       //just forward send request
       SPEAUD_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendChannelRequestGet();
   }
   virtual tVoid getChannelRequestStatus(cmb_fi_tcl_ChannelRequestStatusList& rChannelRequestStatusList){
       //just forward send request
       SPEAUD_NULL_POINTER_CHECK(_poClientRef);
       _poClientRef->getChannelRequestStatus(rChannelRequestStatusList);
   }


   virtual tBool sendVoiceAdviceMStart(cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice){
       //just forward send request
       SPEAUD_NULL_POINTER_CHECK_VAL(_poClientRef);
       return _poClientRef->sendVoiceAdviceMStart(AudioChannelAdvice);
   }
private:
   /***************************************************************************
   * handling of incomming messages
   ***************************************************************************/
   virtual tVoid onChannelRequestStatus(cmb_fi_tcl_ChannelRequestStatusList ChannelRequestStatusList);

   virtual tVoid onVoiceAdviceMResult();

   // speaud_tclClientAcrIfDeclarations: user specific code start
   // speaud_tclClientAcrIfDeclarations: user specific code end

   virtual tVoid onServiceAvailable();
   virtual tVoid onServiceUnavailable();
   
private:
   Ispeaud_tclClientAcr* _poClientRef;

// speaud_tclClientAcrIfDeclarationsPart2: user specific code start
// speaud_tclClientAcrIfDeclarationsPart2: user specific code end

};

#endif // __speaud_ClientAcrIf__IF__H_


