/************************************************************************
* FILE:        	speaudAudioRouting.h
* PROJECT:     	Renault / Nissan A-IVI
* SW-COMPONENT:	speaud
*----------------------------------------------------------------------
*
* DESCRIPTION: class for audio routing
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date       | Author                 | Modification
* 27.05.2015 | CM-AI/EPB2 Schurig     | initial version
* 27.04.2016 | CM-CI1/ERN4-E Schurig  | Bugfix for overlapping messages
*
*************************************************************************/

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#include "audioRouting.h"
#include "Ispeaud_ClientAcr.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_SPEECH_AUDIO_ROUTING
#include "trcGenProj/Header/audioRouting.cpp.trc.h"
#endif

#include "../../../../../../ai_audio/components/audio_routing_lib/include/arl_tclISource.h"

#define ARL_S_IMPORT_INTERFACE_GENERIC
#define ARL_S_IMPORT_INTERFACE_STR_IF
#include "../../../../../../ai_audio/components/audio_routing_lib/audio_routing_lib.h"


/*************************************************************************
 * Constructors / Destructor
 ************************************************************************/
speaudAudioRouting::speaudAudioRouting(const speaud_tclAppMain* poMainAppl)
: I_speaudAudioRouting(poMainAppl), arl_tclISource((ahl_tclBaseOneThreadApp*)poMainAppl)
{
	ETG_TRACE_USR4(("speaudAudioRouting::speaudAudioRouting() entered"));
	_index = 0;
	_bRouteIsAllocated = false;
	_client = 0;
}

speaudAudioRouting::~speaudAudioRouting()
{
	ETG_TRACE_USR4(("speaudAudioRouting::~speaudAudioRouting() entered"));
}
/*************************************************************************
 *
 * FUNCTION:    vSetNaviSpeechRequest
 *
 * DESCRIPTION: Requests a new audio route for navigation announcement as
 *              long as there is no currently open.
 *
 * PARAMETER:   tBool bOpenChannel --> Indicates if channel should be opened
 *              tU8 index          --> Index of requested channel
 *
 * RETURNVALUE: none
 *
 ************************************************************************/
void speaudAudioRouting::vSetNaviSpeechRequest(bool bOpenChannel, tU8 index, tBool isSDSTriggered)
{
	ETG_TRACE_USR4(("speaudAudioRouting::vSetNaviSpeechRequest() entered"));
	_index = index;

	if(isSDSTriggered == true)
	{
		if(bOpenChannel == true)
		{
			ETG_TRACE_USR4(("ROUTE REQUEST FOR SDS TRIGGERED NAVI REPETITION FOR INDEX %d",_index));
			// Fix for NCG3D_36770 --> Close ARL_SRC_NAVI before open channel for ARL_SRC_NAVI_BY_SDS
			bSetAudioRouteRequest(ARL_SRC_NAVI,ARL_EN_ISRC_ACT_OFF);
			bSetAudioRouteRequest(ARL_SRC_NAVI_BY_SDS,ARL_EN_ISRC_ACT_ON);
		}
		else
		{
			ETG_TRACE_USR4(("CLOSE ROUTE REQUEST FOR SDS TRIGGERED NAVI REPETITION FOR INDEX %d",_index));
			bSetAudioRouteRequest(ARL_SRC_NAVI_BY_SDS,ARL_EN_ISRC_ACT_OFF);
		}
	}
	else
	{
		if(bOpenChannel == true)
		{
			ETG_TRACE_USR4(("ROUTE REQUEST FOR NAVIGATION FOR INDEX %d",_index));
			bSetAudioRouteRequest(ARL_SRC_NAVI,ARL_EN_ISRC_ACT_ON);

		}
		else
		{
			ETG_TRACE_USR4(("CLOSE ROUTE REQUEST FOR NAVIGATION FOR INDEX = %d",_index));
			bSetAudioRouteRequest(ARL_SRC_NAVI,ARL_EN_ISRC_ACT_OFF);
		}
	}
}

/*************************************************************************
 *
 * FUNCTION:    vOnNewAppStateNotify
 *
 * DESCRIPTION: reports source available as soon as audio is up
 *
 * PARAMETER:   tU32 u32OldAppState
 *              tU32 u32AppState
 *
 * RETURNVALUE: none
 *
 ************************************************************************/
void speaudAudioRouting::vOnNewAppStateNotify(tU32 u32OldAppState, tU32 u32AppState)
{
   ETG_TRACE_USR4(("vOnNewAppStateNotify: oldState=%d, newState=%d", u32OldAppState, u32AppState));
   vSetSrcAvailable(true);
}

/*************************************************************************
 *
 * FUNCTION:    bOnSrcActivity
 *
 * DESCRIPTION: calls vSourceActivityResult and set some values
 *              according the handed over parameters
 *
 * PARAMETER:   arl_tenSource enSrcNum
 *              const arl_tSrcActivity& rfcoSrcActivity
 *
 * RETURNVALUE: bool (true)
 *
 ************************************************************************/
tBool speaudAudioRouting::bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity)
{
	ETG_TRACE_USR4(("speaudAudioRouting::bOnSourceActivity() entered"));

	cmb_fi_tcl_AudioChannelAdvice AudioChannelAdvice;
	AudioChannelAdvice.Device = OSAL_C_STRING_DEVICE_ACOUSTICOUT_IF_SPEECH;

	// Channel needs to be opened
	if (rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_ON)
	{
		_bRouteIsAllocated = true;
		AudioChannelAdvice.Index = _index;

		ETG_TRACE_USR4(("VOICE ADVICE START FOR INDEX = %d",_index));

	    vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_ON);
	    cmb_fi_tcl_e8_AudioChannelAdvice advice;
	    advice.enType = cmb_fi_tcl_e8_AudioChannelAdvice::FI_EN_START;
	    AudioChannelAdvice.ChannelAdvice = advice;

	    _client->sendVoiceAdviceMStart(AudioChannelAdvice);
	}
	// Channel needs to be closed
	else if (rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_OFF)
    {
		_bRouteIsAllocated = false;
		ETG_TRACE_USR4(("VOICE ADVICE STOP RECEIVED,CLOSING ALL CHANNELS"));

		// run through the vector, close the channels and delete the entries
		for(int i=0 ; i<indexVector.size(); i++)
		{
			ETG_TRACE_USR4(("CLOSING INDEX %d",indexVector[i]));
			AudioChannelAdvice.Index = indexVector[i];
			vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_OFF);
			cmb_fi_tcl_e8_AudioChannelAdvice advice;
			advice.enType = cmb_fi_tcl_e8_AudioChannelAdvice::FI_EN_STOPIMMEDIATELY;
			AudioChannelAdvice.ChannelAdvice = advice;

			_client->sendVoiceAdviceMStart(AudioChannelAdvice);

			indexVector.erase(indexVector.begin());

			ETG_TRACE_USR4(("SIZE OF VECTOR IS %d",indexVector.size()));
		}
	}

    else if (rfcoSrcActivity.enType == midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE)
    {
    	ETG_TRACE_USR4(("VOICE ADVICE PAUSE"));
        vSourceActivityResult(enSrcNum, ARL_EN_ISRC_ACT_PAUSE);
    }

    return true;
}
/*************************************************************************
 *
 * FUNCTION:    bOnDeAllocate
 *
 * DESCRIPTION: returns true
 *              needs to be implemented according audio lib
 *
 * PARAMETER:   arl_tenSource enSrcNum
 *
 * RETURNVALUE: bool
 *
 ************************************************************************/
tBool speaudAudioRouting::bOnDeAllocate(arl_tenSource enSrcNum)
{
	ETG_TRACE_USR4(("speaudAudioRouting::bOnDeAllocate() entered"));
	return true;
}
/*************************************************************************
 *
 * FUNCTION:    bOnAllocate
 *
 * DESCRIPTION: returns true
 *              needs to be implemented according audio lib
 *
 * PARAMETER:   arl_tenSource enSrcNum
 *              const arl_tAllocRouteResult& rfcoAllocRoute
 *
 * RETURNVALUE: bool
 *
 ************************************************************************/
tBool speaudAudioRouting::bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute)
{
	ETG_TRACE_USR4(("speaudAudioRouting::bOnAllocate() entered"));
	return true;
}


/*************************************************************************
 *
 * FUNCTION:    vGetReferences
 *
 * DESCRIPTION: get reference to "Ispeaud_tclClientAcr"
 *
 * PARAMETER:   n/a
 *
 * RETURNVALUE: none
 *
 ************************************************************************/
void speaudAudioRouting::vGetReferences()
{
	_client = dynamic_cast<Ispeaud_tclClientAcr*>(_cpoMain->getHandler("Ispeaud_tclClientAcr"));
	SPEAUD_NULL_POINTER_CHECK(_client);
}

// needs to be implemented
void speaudAudioRouting::vHandleMessage(speaud_tclBaseIf::TMsg* pMsg) {}
void speaudAudioRouting::vHandleTraceMessage(const tUChar* puchData) {}
void speaudAudioRouting::vStartCommunication() {}
void speaudAudioRouting::vTraceInfo() {}














