/************************************************************************
* FILE:        	I_speaudAudioRoutingh
* PROJECT:		Nissan / Renault A-IVI
* SW-COMPONENT:	speaud
*----------------------------------------------------------------------
*
* DESCRIPTION: interface class to audio routing
*
*----------------------------------------------------------------------
* COPYRIGHT:    (c) 2015 Robert Bosch GmbH, Hildesheim
* HISTORY:
* Date      | Author             | Modification
* 27.05.2015| CM-AI/EPB2 Schurig | init
*
*************************************************************************/

#ifndef I_SPEAUDAUDIOROUTING_H_
#define I_SPEAUDAUDIOROUTING_H_

#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#endif //#ifndef OSAL_S_IMPORT_INTERFACE_GENERIC

#include "speaud_AppMain.h"

class I_speaudAudioRouting : public speaud_tclBaseIf
{
public:
	I_speaudAudioRouting(void);
	I_speaudAudioRouting(const speaud_tclAppMain* poMainAppl) : speaud_tclBaseIf (poMainAppl)
	{
		_index = 0;
		_bRouteIsAllocated = false;
	};

	virtual ~I_speaudAudioRouting(){};

	virtual const tChar* getIfName() const { return "I_speaudAudioRouting"; };

	virtual void vSetNaviSpeechRequest(bool isActive, tU8 index, tBool isSDSTriggered) = 0;

	bpstl::vector<tU8> indexVector;
	bpstl::vector<tU8>::iterator iter;
	tU8 _index;
	tBool _bRouteIsAllocated;
};

#endif // _I_SPEAUDAUDIOROUTING_H_
