/*****************************************************************************
* FILE:         hc_AppMain.h
* PROJECT:      G3G project
* SW-COMPONENT: fc_heatctrl
* Template:     applMain.h.tpl
*----------------------------------------------------------------------------
*
* DESCRIPTION:  Generated file
*               DO NOT CHANGE !!!!
*               
*               If necessary --> Changes possible only inside tags
*
*               //......................: user specific code start 
*               //......................: user specific code end
*
*----------------------------------------------------------------------------
* COPYRIGHT:    (c) 2017 Robert Bosch GmbH.
*               The reproduction, distribution and utilization of this file as
*               well as the communication of its contents to others without express
*               authorization is prohibited. Offenders will be held liable for the
*               payment of damages. All rights reserved in the event of the grant
*               of a patent, utility model or design.
*****************************************************************************/


#ifndef _FC_HEATCTRLMAIN_H_
#define _FC_HEATCTRLMAIN_H_

/******************************************************************************/
/*                                                                            */
/* INCLUDES                                                                   */
/*                                                                            */
/******************************************************************************/

#define AHL_S_IMPORT_INTERFACE_GENERIC
#define AHL_S_IMPORT_INTERFACE_CCA_EXTENSION
#include "ahl_if.h"

#include <string>
#include <map>
#include <set>

#include "hc_AppMain_Trace.h"

// hc_tclAppMainIncludes: user specific code start
#include "hc_tclThermalSensor_Types.h"
#include "hc_tclEmergencyFunction_Types.h"
#include "hc_tclITC_Types.h"
#include "hc_tclSimuMode_Types.h"
#include "hc_tclFANControl_Types.h"
// hc_tclAppMainIncludes: user specific code end

/******************************************************************************/
/*                                                                            */
/* DEFINES                                                                    */
/*                                                                            */
/******************************************************************************/


#define HC_NULL_POINTER_CHECK(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return;\
   }

#define HC_NULL_POINTER_CHECK_VAL(poClass) \
   if (poClass == NULL) {\
   FATAL_M_ASSERT_ALWAYS();\
   return 0;\
   }

// hc_tclAppMainDefine: user specific code start
#define HC_TEMP_INVALID_VALUE											   -2730
#define HC_UNCONFIGURED_TEMP                                      OSAL_C_S16_MAX
#define HC_UNCONFIGURED_SPEED                                     OSAL_C_U16_MAX
#define HC_UNCONFIGURED_CYCLETIME											0xFF
#define HC_UNCONFIGURED_BOOL												0xFF

#define HC_C_U16_ARRAYELEMENTS(a)                 (tU16)(sizeof(a)/sizeof(a[0]))
#define HC_C_U32_CONVERT_MS2MIN(t)                           (tU32)(t/(1000*60))
// hc_tclAppMainDefine: user specific code end


#define TRACE_BUFFER_MAXSIZE  250
#define HCINTERNAL_MSG_LEN    8       

/******************************************************************************/
/*                                                                            */
/* CLASS DEFINITION                                                           */
/*                                                                            */
/******************************************************************************/

class ahl_tclBaseOneThreadApp;
class hc_tclAppMain;

// hc_tclAppMainForwardDecl: user specific code start
// hc_tclAppMainForwardDecl: user specific code end

////////////////////////////////////////////////////////////////////////////////
// Base class for all Classes
class hc_tclBaseIf
{
protected:
   const hc_tclAppMain*   _cpoMain;

public:
   typedef enum {
      //internal messages
      eNewThermalInformation = 0,
      eNewThermalState = 1,
      eCmdIncMsgReceived = 100,

      // hc_tclAppMainIMsgDef: user specific code start
      eUpdateSimuMode,                  // update of simu
                                        // . used tUpdateSimuMode
      eNewThermalInfo_STANDARD,         // new standard thermal information
                                        // - used tThermalInfo_Internal
      eNewThermalInfo_AUTOSAR,          // new AUTOSAR thermal information
                                        // - used tThermalInfo_Internal
      eUpdateSensorState,               // update internal thermal sensor state
                                        // - used tThermalSensorInfo_Internal
      eUpdateSensorTemperature,         // update internal sensor temperature
                                        // - used tThermalSensorInfo_Internal
      eUpdateAbstractSensorState,       // update internal abstract sensor state
                                        // - used tThermalSensorInfo_Internal
      eUpdateAbstractSensorTemperature, // update internal abstract sensor temperature
                                        // - used tThermalSensorInfo_Internal
      eTriggerIMXTemp,                  // trigger reading of iMX temperature
      eNewEmergencyFunctionState,       // new emergency function state information
                                        // - used tEmergencyFunctionInfo_Internal
      eUpdateEmergencyFunctionState,    // update internal emergency function state
                                        // - used tEmergencyFunctionState_Internal
      eNewITCState,                     // new ITC state information
                                        // - used tITCInfo_Internal
      eUpdateITCState,                  // update internal ITC state
                                        // - used tITCState_Internal
      eTriggerFANUpdate,                // trigger update of fan information
      eUpdateFanState,                  // update fan control state
      eNewSensorFanSpeed,               // new  fan speed
      	  	  	  	  	  	  	  	  	// - used tSensorFanSpeed_Internal
      eUpdateFanSpeed,					// update fan speed
                                        // - used tFanSpeed
      eUpdateFanTestSpeed,              // update fan test speed
                                        // - used tFanTestSpeed
      eTriggerKDSChanged,               // trigger for KDS data changed
      eTriggerLoadSettings,             // trigger to load settings
      eTriggerXMModuleTemp,             // trigger reading of XM module temperature
      eTriggerTVModuleTemp,             // trigger reading of TV module temperature
      eTriggerDVDDriveTemp,             // trigger reading of DVD drive temperature
	  eTriggerINCResponseTomeout,       // trigger INC communication timeout handling
      // hc_tclAppMainIMsgDef: user specific code end

      eHeartbeat = 200,
      eCmdTraceCmdReceived,
      eCmdCsmSignalReceived,
      eCmdMCanChannelReady,
      eCmdMCanDataInd,      
      eMaxTypes
   }ECmdTypes;

   typedef struct TMsg{
      ECmdTypes  eCmd;
      tChar      strClassName[51];
      
      typedef struct {
          tU32 u32Len;
          tU8* pu8Data;
      }TDataTrailer;
      TDataTrailer tDataTrailer;
            
      union {
         tBool bData;
         tU8   u8Data;
         tS8   s8Data;
         tU16  u16Data;
         tS16  s16Data;
         tU32  u32Data;
         tS32  s32Data;
         tU8   au8Data[HCINTERNAL_MSG_LEN];
         typedef struct {
            tU16   u16MsgId;
            tU8    u8Opcode;
         } TMCanMsg;
         TMCanMsg tMCanMsg;

         // hc_tclAppMainIMsgUnion: user specific code start
         // update simulation mode
         tUpdateSimuMode UpdateSimuMode;
         // internal thermal information
         tThermalInfo_Internal tThermalInfo;
         // internal thermal sensor information
         tThermalSensorInfo_Internal tThermalSensorInfo;
         // internal emergency function state info of specified thermal sensor
         tEmergencyFunctionInfo_Internal tEmergencyFunctionInfo;
         // internal emergency function state
         tEmergencyFunctionState_Internal tEmergencyFunctionState;
         // internal ITC state info of specified thermal sensor
         tITCInfo_Internal tITCInfo;
         // internal ITC state update
         tITCState_Internal tITCState;
         // internal FAN speed request
         tSensorFanSpeed_Internal tFANSpeedReq;
         // fan speed
         tFanSpeed tFANSpeed;
         // fan test speed
         tFanTestSpeed tFANTestSpeed;
         // hc_tclAppMainIMsgUnion: user specific code end
      }u;
   } TMsg;

   hc_tclBaseIf(const hc_tclAppMain* cpoMain):_cpoMain(cpoMain) {;} 
   virtual ~hc_tclBaseIf() {_cpoMain = OSAL_NULL;} 
   virtual const tChar* getName() const = 0;
   virtual const tChar* getIfName() const = 0;

   virtual tVoid vHandleMessage(TMsg* pMsg) = 0;
   virtual tVoid vHandleTraceMessage(const tUChar* puchData) = 0;
   virtual tVoid vGetReferences() = 0;
   virtual tVoid vStartCommunication() = 0;
   virtual tVoid vTraceInfo() = 0;

   // hc_tclAppMainBaseIfDecl: user specific code start
   // hc_tclAppMainBaseIfDecl: user specific code end

};


class hc_tclAppMain : public ahl_tclBaseOneThreadApp
{

private:
   static hc_tclAppMain*   _poMainAppInstance;

public:
   static hc_tclAppMain* theServer();    


   hc_tclAppMain(tVoid);
   virtual ~hc_tclAppMain(tVoid);

   /**************************************************************************
   * Assingment Operater, will not be implemented.
   * Avoids Lint Prio 3 warning: Info 1732: new in constructor for class 
   * 'hc_tclAppMain' which has no assignment operator.
   * NOTE: This is a technique to disable the assignment operator for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclAppMain& operator= (const hc_tclAppMain &oApp);

   /**************************************************************************
   * Copy Constructor, will not be implemented.
   * Avoids Lint Prio 3 warning:Info 1733: new in constructor for class 
   * 'hc_tclAppMain' which has no copy constructor.
   * NOTE: This is a technique to disable the copy constructor for this
   * class. So if an attempt for the assignment is made compiler complains.
   **************************************************************************/
   hc_tclAppMain(const hc_tclAppMain &oApp); 

   /**************************************************************************
   * Overriding ahl_tclBaseOneThreadApp methods.
   **************************************************************************/
   virtual tBool bOnInit();
   virtual tVoid vOnApplicationClose();
   virtual tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);   
   virtual tVoid vOnTimer(tU16 nTimerId);

   using ahl_tclBaseOneThreadApp::vOnLoopback;
   virtual tVoid vOnLoopback(tU16 u16ServiceID, amt_tclServiceData* poMessage);

   virtual tVoid vDispatchInternalMsg(hc_tclBaseIf::TMsg* pInternalMsg);

#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostInternalMessage(hc_tclBaseIf::TMsg* pInternalMsg);
#endif

   tVoid vAddObj(hc_tclBaseIf* client) {
      _oObjList.insert(client);
   }

   tVoid vRemoveObj(hc_tclBaseIf* client){
      if(_oObjList.find(client) != _oObjList.end()) {
         _oObjList.erase(_oObjList.find(client));
      }
   }

   tVoid vStart();
   tBool _bStartPerformed;   

   //reference handling for __ created objects
private:
   std::set<hc_tclBaseIf*>  _oObjList;

public:
   tVoid vStartCommunication() const {
      std::set<hc_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vStartCommunication();
      }
   }

   tVoid vGetReferences() const {
      std::set<hc_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         (*iter)->vGetReferences();
      }
   }

public:
   hc_tclBaseIf*  getHandler(const tChar* cName) const{
      std::set<hc_tclBaseIf*>::iterator iter;
      for (iter = _oObjList.begin(); iter != _oObjList.end(); iter++) {
         // then check for specific implementation
         if (0 == OSAL_s32StringCompare((*iter)->getIfName(), cName)) {
            return (*iter);
         }
         if (0 == OSAL_s32StringCompare((*iter)->getName(), cName)) {
            return (*iter);
         }         
      }
      return NULL;
   }

   tVoid vLoadRegistry();

private:
   tVoid vTracePlugIn(tVoid);
   tVoid vTraceUnplug(tVoid);

   static tVoid vTraceCallbackFunction(const tUChar* puchData);
   static tVoid vHandleTraceMessage(const tUChar* puchData);
   static tVoid vHandleTraceMessageGen(const tUChar* puchData);

   static tUChar _auchTraceInputBuffer[TRACE_BUFFER_MAXSIZE];

public:
#ifndef _CCA_APPLICATION_WO_SERVICE
   virtual tVoid vPostMsgNewThermalInformation(const tChar* strIfName);
   virtual tVoid vPostMsgNewThermalState(const tChar* strIfName);
   virtual tVoid vPostMsgCmdIncMsgReceived(const tChar* strIfName, tU8* au8CmdIncMsgReceived, tU32 length);
#endif

   // hc_tclAppMainDecl: user specific code start
   // hc_tclAppMainDecl: user specific code end
}; 

class tclMCanClientMsgInfo
{
private:
    tBool                   _bSendingInProgress;
    tU32                    _u32TimeStampSend;
    tU32                    _u32TimeStampReceived;
    tU32                    _u32DebounceIntervall;
    tU32                    _u32TimeStampTimeout;
    tU32                    _u32TimeStampSendEnabled;
    tU32                    _u32Timeout;
    tBool                   _bContentChanged;
    tBool                   _bEnabled;
    tBool                   _bConfiured;
    tBool                   _bForce;

public:
    typedef tBool (*T_SendFunction) (tVoid*);
    typedef tVoid (*T_TimeoutFunction) (tVoid*);
    T_SendFunction      pFuncSendMsg;
    T_TimeoutFunction   pFuncTimeoutMsg;

    std::vector < tU32 > _vecStateBlockedIn;
        
    tclMCanClientMsgInfo() :
        _bSendingInProgress(FALSE),
        _u32TimeStampSend(0),
        _u32TimeStampReceived(0),
        _u32DebounceIntervall(0),
        _u32TimeStampTimeout(0),
        _u32TimeStampSendEnabled(0),
        _u32Timeout(1500),
        _bContentChanged(TRUE),
        _bEnabled(TRUE),
        _bConfiured(TRUE),
        _bForce(FALSE),
         pFuncSendMsg(NULL),
         pFuncTimeoutMsg(NULL) {};
    virtual ~tclMCanClientMsgInfo() {};

    tVoid vSetTimeout(tU32 u32Timeout) {_u32Timeout = u32Timeout;}
    tVoid vStartTimeoutDetection() {
        _bSendingInProgress   = TRUE;
        _u32TimeStampTimeout  = OSAL_ClockGetElapsedTime() + _u32Timeout;
    }
    tVoid vMsgSend() {
        _u32TimeStampSend     = OSAL_ClockGetElapsedTime();
        _bContentChanged      = FALSE;
        _u32TimeStampTimeout = _u32TimeStampSend + _u32DebounceIntervall;
        if ( (_u32DebounceIntervall != 0) && (_bForce)){
            _bContentChanged = TRUE;
        }
    }
    tVoid vMsgReceived(tBool bResetInSendingOnly = FALSE) {
        _bSendingInProgress = FALSE;
        if (!bResetInSendingOnly) _u32TimeStampReceived = OSAL_ClockGetElapsedTime();
    }
    tVoid vStartStatusSendPeriod() {
        _bEnabled = TRUE;
        _u32TimeStampSendEnabled = OSAL_ClockGetElapsedTime() + _u32Timeout;
    }

    tU32 u32GetLastSendTimestamp() {return _u32TimeStampSend;}
    tU32 u32GetLastRcvTimestamp() {return _u32TimeStampReceived;}

    tU32 u32MsgTimeout() {return _u32TimeStampTimeout;}
    tU32 u32GetMsgSendPeriodTimeout() {return _u32TimeStampSendEnabled;}

    tBool bSendingInProgress() {return _bSendingInProgress;}
    tVoid vDataChanged() {_bContentChanged = TRUE;}
    tBool bIsDataChanged() {return _bContentChanged;}
    tVoid vClearDataChanged() {_bContentChanged = FALSE;}

    tBool bIsMsgEnabled() {return _bEnabled;}
    tVoid vSetMsgEnabled(tBool bEnabled) {_bEnabled = bEnabled;}

    tBool bIsMsgConfigured() {return _bConfiured;}
    tVoid vSetMsgConfigured(tBool bConfiured) {_bConfiured = bConfiured;}

    tVoid vSetDebounceIntervall(tU32 u32Intervall) {_u32DebounceIntervall = u32Intervall;}
    tVoid vSetForceSend(tBool bForce) {_bForce = bForce;}
};
#endif // _FC_HEATCTRLMAIN_H_

