#ifndef _THERMALINCCALLBACKIF_H_
#define _THERMALINCCALLBACKIF_H_

/**
  * @swcomponent   Life Cycle Management
  * @{
  * @file          Thermal_incCallbackIf.h
  * @PROJECT:      CMD project
  * @SW-COMPONENT: fc_heatctrl
  * @Template:     incCallbackIf.h.tpl
  * ----------------------------------------------------------------------------
  *
  * @brief         generated file
  *                INC adapter
  *
  *                Do here client specific implementation
  *                Changes possible only inside tags
  *         
  *                //......................: user specific code start 
  *                //......................: user specific code end 
  * ----------------------------------------------------------------------------
  * @copyright     (c) 2017 Robert Bosch GmbH.
  *                The reproduction, distribution and utilization of this file as well as the
  *                communication of its contents to others without express authorization is prohibited.
  *                Offenders will be held liable for the payment of damages.
  *                All rights reserved in the event of the grant of a patent, utility model or design.
  * @}
  */

#include "hc_ClientThermalIncFiDef.h"

class ThermalIncCallbackIf
{
   public:
       virtual ~ThermalIncCallbackIf() {};
       virtual void onCOMPONENT_STATUS(::thermal_management_inc_fi::EApplicationStatus ApplicationStatus, tU8 ApplicationVersion) = 0;
       virtual void onREJECT(::thermal_management_inc_fi::ERejectReason RejectReason, tU8 RejectedMsgID) = 0;
       virtual void onGET_STATE(::thermal_management_inc_fi::EModuleState ModuleState) = 0;
       virtual void onSET_STATE(::thermal_management_inc_fi::EModuleID ModuleID, ::thermal_management_inc_fi::EModuleState ModuleState) = 0;
       virtual void onREQ_FAN(::thermal_management_inc_fi::EModuleID ModuleID, tU8 Percent) = 0;
       virtual void onGET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) = 0;
       virtual void onSET_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) = 0;
       virtual void onSET_TEST_TEMP(::thermal_management_inc_fi::EModuleID ModuleID, tS16 Temperature) = 0;
       virtual void onSET_TEST_FAN(::thermal_management_inc_fi::EFanID FanID, tU8 Persent) = 0;

    // ThermalIncCallbackIf_AddClassPart: user specific code start
    // ThermalIncCallbackIf_AddClassPart: user specific code end
};


#endif //_THERMALINCCALLBACKIF_H_

